/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.outside.service.impl;

import com.jxdinfo.hussar.application.model.SysAppRecycle;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.outside.feign.RemoteAppCallBackService;
import com.jxdinfo.hussar.application.service.IOutsideAppCallBackService;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.cloud.support.feign.dynamic.HussarDynamicFeignClientFactory;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.application.outside.service.impl.outsideAppCallBackServiceImpl")
public class OutsideAppCallBackServiceImpl
implements IOutsideAppCallBackService {
    private static HussarDynamicFeignClientFactory dynamicFeignClientFactory = (HussarDynamicFeignClientFactory)SpringContextHolder.getBean(HussarDynamicFeignClientFactory.class);

    public void deleteApp(SysApplication app) {
        String serviceName = app.getServiceName();
        RemoteAppCallBackService remoteAppCallBackService = this.initRemoteAppCallBackService(serviceName);
        remoteAppCallBackService.deleteApp(app);
    }

    public void beforeDeleteApp(SysApplication app) {
        String serviceName = app.getServiceName();
        RemoteAppCallBackService remoteAppCallBackService = this.initRemoteAppCallBackService(serviceName);
        remoteAppCallBackService.beforeDeleteApp(app);
    }

    public void addApp(SysApplication app) {
        String serviceName = app.getServiceName();
        RemoteAppCallBackService remoteAppCallBackService = this.initRemoteAppCallBackService(serviceName);
        remoteAppCallBackService.addApp(app);
    }

    public void updateApp(SysApplication app) {
        String serviceName = app.getServiceName();
        RemoteAppCallBackService remoteAppCallBackService = this.initRemoteAppCallBackService(serviceName);
        remoteAppCallBackService.updateApp(app);
    }

    public void deleteRecycleApp(SysAppRecycle appRecycle) {
        String serviceName = appRecycle.getServiceName();
        RemoteAppCallBackService remoteAppCallBackService = this.initRemoteAppCallBackService(serviceName);
        remoteAppCallBackService.deleteRecycleApp(appRecycle);
    }

    public void beforeDeleteRecycleApp(SysAppRecycle appRecycle) {
        String serviceName = appRecycle.getServiceName();
        RemoteAppCallBackService remoteAppCallBackService = this.initRemoteAppCallBackService(serviceName);
        remoteAppCallBackService.beforeDeleteRecycleApp(appRecycle);
    }

    public void revertRecycleApp(SysAppRecycle appRecycle) {
        String serviceName = appRecycle.getServiceName();
        RemoteAppCallBackService remoteAppCallBackService = this.initRemoteAppCallBackService(serviceName);
        remoteAppCallBackService.revertRecycleApp(appRecycle);
    }

    private RemoteAppCallBackService initRemoteAppCallBackService(String serviceName) {
        return (RemoteAppCallBackService)dynamicFeignClientFactory.getFeignClient(RemoteAppCallBackService.class, serviceName);
    }
}

