/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.factory;

import com.jxdinfo.hussar.application.dto.AppDevelopTeamDto;
import com.jxdinfo.hussar.application.dto.TransferMemberTypeDto;
import com.jxdinfo.hussar.application.dto.UpdateMemberTypeDto;
import com.jxdinfo.hussar.application.service.IHussarAppTeamCallBackService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class HussarApplicationTeamCallBackFactory
implements ApplicationContextAware {
    private static final Map<String, IHussarAppTeamCallBackService> map = new HashMap<String, IHussarAppTeamCallBackService>();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map beanMap = applicationContext.getBeansOfType(IHussarAppTeamCallBackService.class);
        this.setBeansToMap(beanMap);
    }

    private void setBeansToMap(Map<String, IHussarAppTeamCallBackService> beanMap) {
        if (HussarUtils.isNotEmpty(beanMap)) {
            for (IHussarAppTeamCallBackService appTeamCallBackService : beanMap.values()) {
                map.put(appTeamCallBackService.getAppType(), appTeamCallBackService);
            }
        }
    }

    public static IHussarAppTeamCallBackService getAppTeamCallBackService(String appType) {
        return map.get(appType);
    }

    public static void saveAppDevelopTeam(AppDevelopTeamDto appDevelopTeamDto, String appType) {
        IHussarAppTeamCallBackService callBackService = HussarApplicationTeamCallBackFactory.getAppTeamCallBackService(appType);
        if (ToolUtil.isNotEmpty((Object)callBackService)) {
            callBackService.saveAppDevelopTeam(appDevelopTeamDto);
        }
    }

    public static void updateAppDevelopTeam(AppDevelopTeamDto appDevelopTeamDto, String appType) {
        IHussarAppTeamCallBackService callBackService = HussarApplicationTeamCallBackFactory.getAppTeamCallBackService(appType);
        if (ToolUtil.isNotEmpty((Object)callBackService)) {
            callBackService.updateAppDevelopTeam(appDevelopTeamDto, appType);
        }
    }

    public static void updateMember(UpdateMemberTypeDto updateDto, String appType) {
        IHussarAppTeamCallBackService callBackService = HussarApplicationTeamCallBackFactory.getAppTeamCallBackService(appType);
        if (ToolUtil.isNotEmpty((Object)callBackService)) {
            callBackService.updateMember(updateDto);
        }
    }

    public static void removeMembers(Long appId, Long userId, String appType) {
        IHussarAppTeamCallBackService callBackService = HussarApplicationTeamCallBackFactory.getAppTeamCallBackService(appType);
        if (ToolUtil.isNotEmpty((Object)callBackService)) {
            callBackService.removeMembers(appId, userId);
        }
    }

    public static void transferAdministrator(TransferMemberTypeDto transferDto, String appType) {
        IHussarAppTeamCallBackService callBackService = HussarApplicationTeamCallBackFactory.getAppTeamCallBackService(appType);
        if (ToolUtil.isNotEmpty((Object)callBackService)) {
            callBackService.transferAdministrator(transferDto);
        }
    }
}

