/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.controller;

import com.jxdinfo.hussar.application.dto.AppDevelopTeamDto;
import com.jxdinfo.hussar.application.dto.MemberTypeFeignDto;
import com.jxdinfo.hussar.application.dto.TransferMemberTypeDto;
import com.jxdinfo.hussar.application.dto.UpdateMemberTypeDto;
import com.jxdinfo.hussar.application.factory.HussarApplicationTeamCallBackFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="com.jxdinfo.hussar.application.controller.outsideAppTeamCallBackController")
@RequestMapping(value={"/hussarBase/application/team/remote"})
public class OutsideAppTeamCallBackController {
    @PostMapping(value={"/saveAppDevelopTeam"})
    public void saveAppDevelopTeam(@RequestBody AppDevelopTeamDto appDevelopTeamDto) {
        HussarApplicationTeamCallBackFactory.saveAppDevelopTeam(appDevelopTeamDto, appDevelopTeamDto.getAppType());
    }

    @PostMapping(value={"/updateAppDevelopTeam"})
    public void updateAppDevelopTeam(@RequestBody AppDevelopTeamDto appDevelopTeamDto) {
        HussarApplicationTeamCallBackFactory.updateAppDevelopTeam(appDevelopTeamDto, appDevelopTeamDto.getAppType());
    }

    @PostMapping(value={"/updateMember"})
    public void updateMember(@RequestBody MemberTypeFeignDto memberTypeFeignDto) {
        UpdateMemberTypeDto updateDto = new UpdateMemberTypeDto();
        BeanUtils.copyProperties((Object)memberTypeFeignDto, (Object)updateDto);
        HussarApplicationTeamCallBackFactory.updateMember(updateDto, memberTypeFeignDto.getAppType());
    }

    @GetMapping(value={"/removeMembers"})
    public void removeMembers(@RequestParam(value="appId") Long appId, @RequestParam(value="userId") Long userId, @RequestParam(value="appType") String appType) {
        HussarApplicationTeamCallBackFactory.removeMembers(appId, userId, appType);
    }

    @PostMapping(value={"/transferAdministrator"})
    public void transferAdministrator(@RequestBody MemberTypeFeignDto memberTypeFeignDto) {
        TransferMemberTypeDto transferDto = new TransferMemberTypeDto();
        transferDto.setAppId(memberTypeFeignDto.getAppId());
        transferDto.setTeamId(memberTypeFeignDto.getTeamId());
        transferDto.setTargetUserId(memberTypeFeignDto.getUserId());
        HussarApplicationTeamCallBackFactory.transferAdministrator(transferDto, memberTypeFeignDto.getAppType());
    }
}

