/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.factory;

import com.jxdinfo.hussar.application.model.SysAppRecycle;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.IHussarAppCallBackService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class HussarApplicationCallBackFactory
implements ApplicationContextAware {
    private static final Map<String, IHussarAppCallBackService> map = new HashMap<String, IHussarAppCallBackService>();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map beanMap = applicationContext.getBeansOfType(IHussarAppCallBackService.class);
        this.setBeansToMap(beanMap);
    }

    private void setBeansToMap(Map<String, IHussarAppCallBackService> beanMap) {
        if (HussarUtils.isNotEmpty(beanMap)) {
            for (IHussarAppCallBackService appCallBackService : beanMap.values()) {
                map.put(appCallBackService.getAppType(), appCallBackService);
            }
        }
    }

    public static IHussarAppCallBackService getAppCallBackService(String appType) {
        return map.get(appType);
    }

    public static void addCallback(SysApplication app) {
        IHussarAppCallBackService callBackService = HussarApplicationCallBackFactory.getAppCallBackService(app.getAppType());
        if (ToolUtil.isNotEmpty((Object)callBackService)) {
            callBackService.addApp(app);
        }
    }

    public static void deleteApp(SysApplication app) {
        IHussarAppCallBackService callBackService = HussarApplicationCallBackFactory.getAppCallBackService(app.getAppType());
        if (ToolUtil.isNotEmpty((Object)callBackService)) {
            callBackService.deleteApp(app);
        }
    }

    public static void beforeDeleteApp(SysApplication app) {
        IHussarAppCallBackService callBackService = HussarApplicationCallBackFactory.getAppCallBackService(app.getAppType());
        if (ToolUtil.isNotEmpty((Object)callBackService)) {
            callBackService.beforeDeleteApp(app);
        }
    }

    public static void updateApp(SysApplication app) {
        IHussarAppCallBackService callBackService = HussarApplicationCallBackFactory.getAppCallBackService(app.getAppType());
        if (ToolUtil.isNotEmpty((Object)callBackService)) {
            callBackService.updateApp(app);
        }
    }

    public static void deleteRecycleApp(SysAppRecycle appRecycle) {
        IHussarAppCallBackService callBackService = HussarApplicationCallBackFactory.getAppCallBackService(appRecycle.getAppType());
        if (ToolUtil.isNotEmpty((Object)callBackService)) {
            callBackService.deleteRecycleApp(appRecycle);
        }
    }

    public static void revertRecycleApp(SysAppRecycle appRecycle) {
        IHussarAppCallBackService callBackService = HussarApplicationCallBackFactory.getAppCallBackService(appRecycle.getAppType());
        if (ToolUtil.isNotEmpty((Object)callBackService)) {
            callBackService.revertRecycleApp(appRecycle);
        }
    }

    public static void beforeDeleteRecycleApp(SysAppRecycle appRecycle) {
        IHussarAppCallBackService callBackService = HussarApplicationCallBackFactory.getAppCallBackService(appRecycle.getAppType());
        if (ToolUtil.isNotEmpty((Object)callBackService)) {
            callBackService.beforeDeleteRecycleApp(appRecycle);
        }
    }
}

