package com.jxdinfo.hussar.cloud.module.example.${tenantCode}.${serviceName}.${applicationCode}.service;

import com.jxdinfo.hussar.cloud.module.example.${tenantCode}.${serviceName}.${applicationCode}.config.ExpansionColumnInfoConfig;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.expansion.core.config.ExpansionExtensionTableConfigInfo;
import com.jxdinfo.hussar.support.expansion.core.config.ExpansionMethodConfigInfo;
import com.jxdinfo.hussar.support.expansion.core.config.ExpansionTableConfigInfo;
import com.jxdinfo.hussar.support.expansion.core.service.PluginExpansionColumnInfoService;
import com.jxdinfo.hussar.support.hotloaded.framework.annotation.Extract;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.Map;


@Extract(bus = "${id}")
public class ${tenantAndExpansion}ExpansionColumnService implements PluginExpansionColumnInfoService {

    @Autowired
    private ExpansionColumnInfoConfig expansionColumnInfoConfig;

    @Override
    public List<ExpansionTableConfigInfo> getExpansionColumnInfo(String tableName) {
        Map<String, List<ExpansionTableConfigInfo>> tableExpansionColumnInfo = expansionColumnInfoConfig.getTableExpansionColumnInfo();
        if (HussarUtils.isEmpty(tableExpansionColumnInfo)) {
            return null;
        }
        return tableExpansionColumnInfo.get(tableName);
    }

    @Override
    public List<ExpansionMethodConfigInfo> getExpansionMethodConfigInfoService(String modelId) {
        Map<String, List<ExpansionMethodConfigInfo>> tableExpansionMethodInfos = expansionColumnInfoConfig.getTableExpansionMethodInfos();
        if (HussarUtils.isEmpty(tableExpansionMethodInfos)) {
            return null;
        }
        return tableExpansionMethodInfos.get(modelId);
    }

    @Override
    public List<ExpansionExtensionTableConfigInfo> getExpansionExtensionTableConfigInfoService(String s) {
        Map<String, List<ExpansionExtensionTableConfigInfo>> tableExpansionSlaveTableInfos = expansionColumnInfoConfig.getTableExpansionSlaveTableInfos();
        if (HussarUtils.isEmpty(tableExpansionSlaveTableInfos)){
            return null;
        }
        return tableExpansionSlaveTableInfos.get(s);
    }

}