/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.app.imports.service.impl;

import com.google.common.collect.Lists;
import com.jxdinfo.hussar.applicationmix.service.IHussarBaseAppMixBoService;
import com.jxdinfo.hussar.applicationmix.vo.MixAppInfoVo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.app.FormDesignAppInfo;
import com.jxdinfo.hussar.formdesign.app.IApp;
import com.jxdinfo.hussar.formdesign.datasource.FormDesignDataSource;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class IAppImpl
implements IApp {
    private static final String STANDARD_APP_INFO = "standard_app_info";
    @Resource
    private IHussarBaseAppMixBoService hussarBaseAppMixBoService;

    public FormDesignAppInfo getAppInfo(String appId) {
        FormDesignAppInfo result = (FormDesignAppInfo)HussarCacheUtil.get((String)"app_info", (Object)appId);
        if (HussarUtils.isEmpty((Object)result)) {
            MixAppInfoVo info = this.hussarBaseAppMixBoService.getMixAppInfo(Long.valueOf(appId));
            if (info == null) {
                return new FormDesignAppInfo();
            }
            result = new FormDesignAppInfo();
            result.setObjId(info.getId().toString());
            result.setName(info.getAppName());
            result.setAppDescribe(info.getAppDescribe());
            result.setEnglishName(info.getAppEnglishName());
            result.setServiceName(info.getServiceName());
            result.setCreateTime(Date.from(info.getCreateTime().atZone(ZoneId.systemDefault()).toInstant()));
            result.setAppType(info.getAppType());
            SecurityUser loginUser = BaseSecurityUtil.getUser();
            result.setTenantName(loginUser.getTenantName());
            result.setTenantCode(loginUser.getTenantCode());
            HussarCacheUtil.put((String)"app_info", (Object)appId, (Object)result);
        }
        return result;
    }

    public String getDBNameByAppId(String s) {
        return "";
    }

    public List<FormDesignAppInfo> listAppInfo(String userId) {
        return Lists.newArrayList();
    }

    public FormDesignDataSource getDefaultByAppId(String appId) {
        return null;
    }

    public FormDesignAppInfo getStandardApp(String appId) {
        FormDesignAppInfo result = (FormDesignAppInfo)HussarCacheUtil.get((String)STANDARD_APP_INFO, (Object)appId);
        if (HussarUtils.isEmpty((Object)result)) {
            MixAppInfoVo info = this.hussarBaseAppMixBoService.getStandardAppInfo(Long.valueOf(appId));
            if (info == null) {
                return new FormDesignAppInfo();
            }
            result = new FormDesignAppInfo();
            result.setObjId(info.getId().toString());
            result.setName(info.getAppName());
            result.setAppDescribe(info.getAppDescribe());
            result.setEnglishName(info.getAppEnglishName());
            result.setServiceName(info.getServiceName());
            result.setCreateTime(Date.from(info.getCreateTime().atZone(ZoneId.systemDefault()).toInstant()));
            result.setAppType(info.getAppType());
            SecurityUser loginUser = BaseSecurityUtil.getUser();
            result.setTenantName(loginUser.getTenantName());
            result.setTenantCode(loginUser.getTenantCode());
            HussarCacheUtil.put((String)STANDARD_APP_INFO, (Object)appId, (Object)result);
        }
        return result;
    }

    public List<FormDesignAppInfo> listAllAppInfo(String userId) {
        return new ArrayList<FormDesignAppInfo>();
    }
}

