/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.app.imports.service.impl;

import com.jxdinfo.hussar.app.imports.service.AppImportService;
import com.jxdinfo.hussar.app.imports.service.MircoAppImportCtrlService;
import com.jxdinfo.hussar.applicationmix.model.SysEyImportAppMsg;
import com.jxdinfo.hussar.applicationmix.properties.HussarClusterProperties;
import com.jxdinfo.hussar.applicationmix.service.IHussarBaseAppMixBoService;
import com.jxdinfo.hussar.applicationmix.service.IHussarBaseImportAppMixMsgBoService;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.hotloaded.framework.integration.AutoIntegrationConfiguration;
import java.io.File;
import java.util.Arrays;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class AppImportCtrlServiceImpl
implements MircoAppImportCtrlService {
    private final Logger logger = LoggerFactory.getLogger(AppImportCtrlServiceImpl.class);
    @Autowired
    private IHussarBaseImportAppMixMsgBoService hussarBaseImportAppMixmsgBoService;
    @Resource
    private IHussarBaseAppMixBoService hussarBaseAppMixBoService;
    @Autowired
    private AppImportService appFileService;
    @Resource
    private HussarClusterProperties hussarClusterProperties;
    @Lazy
    @Resource
    private AutoIntegrationConfiguration autoIntegrationConfiguration;

    @HussarDs(value="#connName")
    public void doJob(String connName) {
        if (this.autoIntegrationConfiguration.enable()) {
            this.logger.info("======================+++++++++++++++++++++=========================================+++++++++++++++++++++===================");
            this.logger.info("======================+++++++++++++++++++\u5f00\u59cb\u6267\u884c\u5e94\u7528\u5bfc\u5165\u63a7\u5236\u5b9a\u65f6\u4efb\u52a1\uff01\uff01\uff01\uff01\uff01======================+++++++++=====================");
            String name = ((DynamicDatasourceService)SpringContextHolder.getBean(DynamicDatasourceService.class)).getCurrentDatasource().getName();
            if (this.isImportStatusExpect45Only0()) {
                this.logger.info("\u68c0\u6d4b\u5b8c\u6210\uff0c\u5b58\u5728\u5f85\u5bfc\u5165\u7684\u5e94\u7528\uff0c\u5f00\u59cb\u7f16\u8bd1\u5bfc\u5165\u5e94\u7528\uff0c\u5f53\u524d\u6570\u636e\u6e90\uff1a{}\u3002", (Object)name);
                this.getAndImoprtApplication();
                this.logger.info("\u6267\u884c\u5bfc\u5165\u5e94\u7528\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f\u3002");
            } else {
                this.logger.info("======================+++++++++++++++++++\u68c0\u6d4b\u5b8c\u6210\uff0c\u6ca1\u6709\u5f85\u5bfc\u5165\u7684\u5e94\u7528\u3002\u5f53\u524d\u6570\u636e\u6e90\uff1a{}\u3002\u6267\u884c\u5bfc\u5165\u5e94\u7528\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f\u3002======================+++++++++=====================", (Object)name);
                this.logger.info("======================+++++++++++++++++++++=========================================+++++++++++++++++++++===================");
            }
        }
    }

    public void checkAppImportMsg() {
        this.hussarBaseImportAppMixmsgBoService.checkAppImportMsg();
    }

    private boolean isImportStatusExpect45Only0() {
        return this.hussarBaseImportAppMixmsgBoService.isImportStatusExpect45Only0();
    }

    private void getAndImoprtApplication() {
        SysEyImportAppMsg eyImportAppmsg = this.hussarBaseImportAppMixmsgBoService.getEyImportAppMsg();
        boolean flag = this.hussarBaseImportAppMixmsgBoService.setImportStatusOne(eyImportAppmsg.getId());
        if (flag) {
            try {
                boolean importEyAppFlag = this.importEyApp(eyImportAppmsg);
                if (!importEyAppFlag) {
                    this.hussarBaseImportAppMixmsgBoService.setImportStatusFive(eyImportAppmsg.getId());
                }
            }
            catch (Exception e) {
                this.hussarBaseImportAppMixmsgBoService.setFailReason(eyImportAppmsg.getId(), e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private boolean importEyApp(SysEyImportAppMsg eyImportAppmsg) {
        String importFileBackUpPath = FileUtil.posixPath((String[])new String[]{this.hussarClusterProperties.getImportFile(), File.separator, eyImportAppmsg.getServerCode(), File.separator, eyImportAppmsg.getAppId().toString(), File.separator, eyImportAppmsg.getId().toString()});
        try {
            this.appFileService.importAndCompileApp(importFileBackUpPath, eyImportAppmsg.getServerCode(), eyImportAppmsg.getAppId(), eyImportAppmsg.getImportMsgSql(), Arrays.asList(eyImportAppmsg.getImportMsgKeys().split(",")), eyImportAppmsg.getId(), eyImportAppmsg.getServerName());
        }
        catch (Exception e) {
            this.hussarBaseImportAppMixmsgBoService.setFailReason(eyImportAppmsg.getId(), e.getMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

