/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.app.imports.runner;

import com.jxdinfo.hussar.app.imports.service.MircoAppImportCtrlService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.platform.core.http.HussarHttpServletRequest;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import com.jxdinfo.hussar.support.job.execution.core.processor.TaskContext;
import com.jxdinfo.hussar.support.job.execution.core.processor.sdk.BasicProcessor;
import com.jxdinfo.hussar.tenant.common.model.DefaultTenant;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class AppImportCtrlJob
implements BasicProcessor {
    private Logger logger = LoggerFactory.getLogger(AppImportCtrlJob.class);
    @Autowired(required=false)
    private ISysTenantService sysTenantService;
    @Autowired
    private SysDataSourceService sysDataSourceService;
    private MircoAppImportCtrlService appImportCtrlService = (MircoAppImportCtrlService)SpringContextHolder.getBean(MircoAppImportCtrlService.class);

    public ProcessResult process(TaskContext taskContext) throws Exception {
        String tenantCode = taskContext.getTenantCode();
        if (StringUtils.isBlank((CharSequence)tenantCode) || "0".equals(tenantCode)) {
            boolean tenantOpen = TenantCacheUtil.openTenant();
            HashSet<String> connNameList = new HashSet<String>();
            Map normalTenants = new HashMap<String, DefaultTenant>();
            if (tenantOpen) {
                List dataSourceList = this.sysDataSourceService.getAllTenantDataSource();
                Map<String, List<SysDataSource>> dataSourceMap = dataSourceList.stream().collect(Collectors.groupingBy(SysDataSource::getConnName));
                Set tenantConnNameList = this.sysTenantService.getConnNameList();
                if (HussarUtils.isNotEmpty((Object)tenantConnNameList)) {
                    for (String connName : tenantConnNameList) {
                        if (!dataSourceMap.containsKey(connName)) continue;
                        connNameList.add(connName);
                    }
                }
                normalTenants = this.sysTenantService.getNormalTenants();
            } else {
                connNameList.add("master");
                normalTenants.put("master", new DefaultTenant());
            }
            for (String connName : connNameList) {
                HussarTenantDefinition hussarTenantDefinition = (HussarTenantDefinition)normalTenants.get(connName);
                if (hussarTenantDefinition == null) {
                    throw new BaseException("\u672a\u67e5\u8be2\u5230\u6570\u636e\u6e90\u540d\u79f0\u4e3a" + connName + "\u7684\u79df\u6237");
                }
                HussarHttpServletRequest hussarHttpServletRequest = new HussarHttpServletRequest();
                hussarHttpServletRequest.addHeader("tcode", hussarTenantDefinition.getTenantCode());
                ServletRequestAttributes newServletRequestAttributes = new ServletRequestAttributes((HttpServletRequest)hussarHttpServletRequest);
                RequestContextHolder.setRequestAttributes((RequestAttributes)newServletRequestAttributes);
                HussarContextHolder.setTenant((HussarTenantDefinition)hussarTenantDefinition);
                this.appImportCtrlService.doJob(connName);
                HussarContextHolder.remove();
            }
        }
        return new ProcessResult(true, "success");
    }
}

