/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.app.imports.model;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginCodeGenerator {
    private static final Logger logger = LoggerFactory.getLogger(PluginCodeGenerator.class);
    private String templateName;
    private Map<String, Object> templateParam;
    private String templatepath;
    private String filepath;
    private String fileName;

    public PluginCodeGenerator(String templateName, Map<String, Object> templateParam, String templatepath, String filepath, String fileName) {
        this.templateName = templateName;
        this.templateParam = templateParam;
        this.templatepath = templatepath;
        this.filepath = filepath;
        this.fileName = fileName;
    }

    public PluginCodeGenerator(String templateName, Map<String, Object> templateParam, String filepath, String fileName) {
        this.templateName = templateName;
        this.templateParam = templateParam;
        this.filepath = filepath;
        this.fileName = fileName;
    }

    public void gen() {
        try {
            Configuration cfg = new Configuration(Configuration.VERSION_2_3_22);
            if (HussarUtils.isNotEmpty((Object)this.templatepath)) {
                cfg.setDirectoryForTemplateLoading(new File(this.templatepath));
            } else {
                cfg.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(PluginCodeGenerator.class, "/templates"));
            }
            cfg.setDefaultEncoding("UTF-8");
            cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
            Template temp = cfg.getTemplate(this.templateName);
            HashMap<String, Object> root = new HashMap<String, Object>(this.templateParam);
            File dir = new File(this.filepath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            OutputStream fos = Files.newOutputStream(new File(dir, this.fileName).toPath(), new OpenOption[0]);
            try {
                OutputStreamWriter out = new OutputStreamWriter(fos);
                temp.process(root, (Writer)out);
            }
            catch (Exception e) {
                throw new HussarException((Throwable)e);
            }
            finally {
                fos.flush();
                fos.close();
            }
        }
        catch (Exception e) {
            logger.info("\u751f\u6210{}\u51fa\u9519:{}", (Object)this.templateName, (Object)e.getMessage());
        }
        logger.info("------------------gen code " + this.fileName + " success!------------------");
    }
}

