<?xml version="1.0" encoding="UTF-8"?>
<project xmlns="http://maven.apache.org/POM/4.0.0"
         xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
         xsi:schemaLocation="http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd">
    <modelVersion>4.0.0</modelVersion>
    <parent>
        <groupId>com.jxdinfo.hussar</groupId>
        <artifactId>hussar-plugin-parent</artifactId>
        <version>9.3.7-htsz.4</version>
        <relativePath>../../../../hussar-plugin-parent/pom.xml</relativePath>
    </parent>

    <artifactId>${artifactId}</artifactId>


    <properties>
        <!--插件id和配置文件一致-->
        <plugin.id>${id}</plugin.id>
        <!--插件的启动类-->
        <plugin.class>${class}</plugin.class>
        <!--插件的版本号-->
        <plugin.version>v1.0.0</plugin.version>
        <!--插件的开发者-->
        <plugin.provider>${provider}</plugin.provider>
    </properties>
    <dependencies>
    </dependencies>
    <build>
        <plugins>
            <plugin>
                <groupId>org.apache.maven.plugins</groupId>
                <artifactId>maven-deploy-plugin</artifactId>
                <version><#noparse>${maven-deploy-plugin.version}</#noparse></version>
                <configuration>
                    <skip>true</skip>
                </configuration>
            </plugin>
            <plugin>
                <groupId>org.apache.maven.plugins</groupId>
                <artifactId>maven-dependency-plugin</artifactId>
                <version>3.2.0</version>
                <executions>
                    <execution>
                        <id>include-loader-jar</id>
                        <phase>generate-resources</phase>
                        <goals>
                            <goal>copy-dependencies</goal>
                        </goals>
                        <configuration>
                            <outputDirectory><#noparse>${project.build.directory}/lib</#noparse></outputDirectory>
                            <excludeTransitive>true</excludeTransitive>
                            <excludeArtifactIds>
                                hussar-system,lombok,maven-dependency-plugin,spring-boot-maven-plugin,build-helper-maven-plugin,spring-boot-configuration-processor,spring-boot-starter-actuator,hussar-cloud-module-example-application
                            </excludeArtifactIds>
                            <overWriteReleases>false</overWriteReleases>
                            <overWriteSnapshots>true</overWriteSnapshots>
                        </configuration>
                    </execution>
                </executions>
            </plugin>
            <plugin>
                <groupId>com.jxdinfo.hussar.support.hotloaded</groupId>
                <artifactId>hussar-hotloaded-plugin-packager278</artifactId>
                <version>9.3.0</version>
                <executions>
                    <execution>
                        <!-- 高版本Spring-boot 2.1.1.RELEASE 需要新增id -->
                        <id>repackage</id>
                        <goals>
                            <goal>repackage-plugin</goal>
                        </goals>
                        <configuration>
                            <classifier>plugin</classifier>
                            <excludeTransitive>true</excludeTransitive>
                            <excludeArtifactIds>
                                hussar-cloud-module-example-application,hussar-system,lombok,maven-dependency-plugin,spring-boot-maven-plugin,build-helper-maven-plugin,spring-boot-configuration-processor,spring-boot-starter-actuator
                            </excludeArtifactIds>
                        </configuration>
                    </execution>
                </executions>
            </plugin>
        </plugins>
    </build>

</project>
