<?xml version="1.0" encoding="UTF-8"?>
<project xmlns="http://maven.apache.org/POM/4.0.0"
         xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
         xsi:schemaLocation="http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd">
    <parent>
        <groupId>com.jxdinfo.hussar</groupId>
        <artifactId>${pluginParentName}</artifactId>
        <version>9.3.7-htsz.4</version>
        <relativePath>../../../../../${pluginParentName}/pom.xml</relativePath>
    </parent>
    <modelVersion>4.0.0</modelVersion>
    <version>1.0.0-RELEASE</version>

    <artifactId>${artifactId}</artifactId>

    <properties>
        <maven.compiler.source>8</maven.compiler.source>
        <maven.compiler.target>8</maven.compiler.target>
        <project.build.sourceEncoding>UTF-8</project.build.sourceEncoding>

        <!--插件id和配置文件一致-->
        <plugin.id>${id}</plugin.id>
        <!--插件的启动类-->
        <plugin.class>${class}</plugin.class>
        <!--插件的版本号-->
        <plugin.version>v1.0.0</plugin.version>
        <!--插件的开发者-->
        <plugin.provider>${provider}</plugin.provider>
    </properties>
    <dependencies>
        <dependency>
            <groupId>com.jxdinfo.hussar</groupId>
            <artifactId>${apiArtifactId}</artifactId>
            <version>1.0.0-RELEASE</version>
        </dependency>

    </dependencies>

    <build>
        <plugins>
            <plugin>
                <groupId>org.apache.maven.plugins</groupId>
                <artifactId>maven-deploy-plugin</artifactId>
                <version><#noparse>${maven-deploy-plugin.version}</#noparse></version>
                <configuration>
                    <skip>true</skip>
                </configuration>
            </plugin>
            <plugin>
                <groupId>org.apache.maven.plugins</groupId>
                <artifactId>maven-dependency-plugin</artifactId>
                <version>3.2.0</version>
                <executions>
                    <execution>
                        <phase>package</phase>
                        <goals>
                            <goal>copy-dependencies</goal>
                        </goals>
                        <configuration>
                            <outputDirectory><#noparse>${project.build.directory}/lib</#noparse></outputDirectory>
                            <excludeTransitive>true</excludeTransitive>
                            <excludeArtifactIds>hussar-web,hussar-cloud-module-example-application</excludeArtifactIds>
                        </configuration>
                    </execution>
                </executions>
            </plugin>
        </plugins>
    </build>
</project>
