/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.app.imports.util;

import com.jxdinfo.hussar.formdesign.common.file.impl.vue.VuePathServiceImpl;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class FileUtil {
    public static final String TABLE = "DataModel";
    public static final String TABLE_SUFFIX = ".dbd";
    public static final String MODULE = "Module";
    public static final String MODULE_SUFFIX = "";
    public static final String PAGE = "WebPage";
    public static final String PAGE_SUFFIX = ".wpd";
    public static final String WORKFLOW = "Workflow";
    public static final String WORKFLOW_SUFFIX = "";
    public static final String MOBILE_PAGE = "MobilePage";
    public static final String MOBILE_PAGE_SUFFIX = ".mpd";
    public static final String MICROAPP = "MicroApp";
    public static final String MICROAPP_SUFFIX = ".mad";
    public static final String EXTEND_JS = "FrontScript";
    public static final String EXTEND_JS_SUFFIX = ".jsd";
    public static final String EXTEND_VUE = "CustomPage";
    public static final String EXTEND_VUE_SUFFIX = ".cpd";
    public static final String EXTEND_MOBILE_JS = "MobileFrontScript";
    public static final String EXTEND_MOBILE_JS_SUFFIX = ".mjsd";
    public static final String EXTEND_MOBILE_VUE = "MobileCustomPage";
    public static final String EXTEND_MOBILE_VUE_SUFFIX = ".mcpd";
    public static final String EMPTY = "";
    public static final String META = ".meta";
    public static final String WORKFLOW_MODEL = "workFlowAndModels";
    public static final String WORKFLOW_MODEL_SUFFIX = ".wmd";
    public static final String META_ID = "d37c273c-d0ca-4f46-a1b1-0aa62754dcb3";
    public static final String APPS_STORE = "appsStore";

    private FileUtil() {
    }

    public static String transFileSuffix(String fileType) {
        if (ToolUtil.isEmpty((Object)fileType)) {
            return "";
        }
        switch (fileType) {
            case "DataModel": {
                return TABLE_SUFFIX;
            }
            case "Module": {
                return "";
            }
            case "WebPage": {
                return PAGE_SUFFIX;
            }
            case "Workflow": {
                return "";
            }
            case "MobilePage": {
                return MOBILE_PAGE_SUFFIX;
            }
            case "MicroApp": {
                return MICROAPP_SUFFIX;
            }
            case "FrontScript": {
                return EXTEND_JS_SUFFIX;
            }
            case "CustomPage": {
                return EXTEND_VUE_SUFFIX;
            }
            case "MobileFrontScript": {
                return EXTEND_MOBILE_JS_SUFFIX;
            }
            case "MobileCustomPage": {
                return EXTEND_MOBILE_VUE_SUFFIX;
            }
        }
        return "";
    }

    public static void modifyFilePaths(File file, String tenantCode) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        String javaPath = VuePathServiceImpl.formDesignProperties.getJavaPath().replaceAll("^/+|/+$", "").replace("/", ".");
        boolean modified = false;
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = reader.readLine()) != null) {
                String originalLine = line;
                if (line.trim().startsWith("package " + javaPath)) {
                    line = FileUtil.modifyPath(line, javaPath, tenantCode);
                } else if (line.trim().startsWith("import " + javaPath)) {
                    line = FileUtil.modifyPath(line, javaPath, tenantCode);
                }
                if (!line.equals(originalLine)) {
                    modified = true;
                }
                lines.add(line);
            }
        }
        if (modified) {
            var6_6 = null;
            try (FileWriter writer = new FileWriter(file);){
                for (String line : lines) {
                    writer.write(line + System.lineSeparator());
                }
            }
            catch (Throwable throwable) {
                var6_6 = throwable;
                throw throwable;
            }
        }
    }

    private static String modifyPath(String path, String javaPath, String tenantCode) {
        String afterBase = path.substring(path.indexOf(javaPath) + javaPath.length());
        String[] parts = afterBase.split("\\.");
        if (parts.length >= 2) {
            parts[1] = AppContextUtil.asIdentifier((String)tenantCode);
        }
        StringBuilder newPath = new StringBuilder();
        newPath.append(path.substring(0, path.indexOf(javaPath) + javaPath.length()));
        for (int i = 1; i < parts.length; ++i) {
            newPath.append(".").append(parts[i]);
        }
        return newPath.toString();
    }
}

