/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.app.imports.controller;

import com.alibaba.cloud.nacos.NacosServiceManager;
import com.alibaba.druid.pool.ha.PropertiesUtils;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jxdinfo.hussar.app.imports.util.ZipUtil;
import com.jxdinfo.hussar.applicationmix.properties.HussarProduceProperties;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.hotloaded.framework.integration.operator.PluginOperator;
import com.jxdinfo.hussar.support.hotloaded.framework.integration.operator.module.PluginInfo;
import com.jxdinfo.hussar.support.hotloaded.framework.utils.GlobalRegistryInfo;
import com.jxdinfo.hussar.support.hotloaded.framework.utils.PluginOperatorInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/application/appFile"})
public class HotLoadController {
    private static final Logger logger = LoggerFactory.getLogger(HotLoadController.class);
    @Lazy
    @Resource
    private PluginOperator pluginOperator;
    @Resource
    private HussarProduceProperties hussarProduceProperties;
    @Resource
    private NacosServiceManager nacosServiceManager;
    @Value(value="${plugin.uploadTempPath:E:/hussar-plugin/}")
    private String uploadTempPath;

    @GetMapping(value={"pluginList"})
    public ApiResponse<List<Map<String, String>>> pluginList(@RequestParam(value="tenantCode", required=false) String tenantCode, @RequestParam(value="fileName", required=false) String fileName) {
        List<File> fileList;
        String filePath = this.uploadTempPath;
        if (HussarUtils.isNotEmpty((Object)tenantCode)) {
            filePath = filePath + File.separator + tenantCode;
        }
        if (HussarUtils.isEmpty(fileList = this.listAllFiles(filePath))) {
            return ApiResponse.success();
        }
        if (HussarUtils.isNotEmpty((Object)fileName)) {
            fileList = fileList.stream().filter(file -> file.getName().contains(fileName)).collect(Collectors.toList());
        }
        ArrayList result = Lists.newArrayList();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneId.systemDefault());
        for (File file2 : fileList) {
            HashMap fileMap = Maps.newHashMap();
            fileMap.put("fileName", file2.getName());
            fileMap.put("uploadTime", formatter.format(Instant.ofEpochMilli(file2.lastModified())));
            if (HussarUtils.isNotEmpty((Object)tenantCode)) {
                fileMap.put("tenant", tenantCode);
            } else {
                File parentFile = file2.getParentFile();
                if (!this.uploadTempPath.equals(parentFile.getAbsolutePath())) {
                    fileMap.put("tenant", parentFile.getName());
                }
            }
            fileMap.put("path", (fileMap.get("tenant") == null ? "" : (String)fileMap.get("tenant") + File.separator) + file2.getName());
            result.add(fileMap);
        }
        return ApiResponse.success((Object)result);
    }

    private List<File> listAllFiles(String dirPath) {
        ArrayList<File> fileList = new ArrayList<File>();
        File dir = new File(dirPath);
        if (!dir.exists() || !dir.isDirectory()) {
            return Lists.newArrayList();
        }
        this.listFilesRecursive(dir, fileList);
        return fileList.stream().filter(file -> file.getName().endsWith(".jar")).collect(Collectors.toList());
    }

    private void listFilesRecursive(File dir, List<File> fileList) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.listFilesRecursive(file, fileList);
                    continue;
                }
                fileList.add(file);
            }
        }
    }

    @GetMapping(value={"hotLoad"})
    public ApiResponse<List<String>> hotLoad(@RequestParam(value="serviceName") String serviceName, @RequestParam(value="jarName") String jarName, HttpServletRequest request) throws Exception {
        if (HussarUtils.isEmpty((Object)jarName)) {
            throw new HussarException("\u8bf7\u9009\u62e9\u8981\u52a0\u8f7d\u7684\u63d2\u4ef6\u5305\uff01");
        }
        String idToken = (String)HussarCacheUtil.get((String)"hussar-token", (Object)"hussar-token:var:id-token");
        ArrayList message = Lists.newArrayList();
        List<String> colonyList = this.getIpAndPortByServiceName(serviceName);
        logger.info("\u5df2\u914d\u7f6e\u96c6\u7fa4\u8282\u70b9\uff1a{}", (Object)StringUtils.join(colonyList, (String)","));
        if (!colonyList.isEmpty()) {
            for (String colony : colonyList) {
                String url = colony + "/application/appFile/syncHotLoad";
                String param = "jarName=" + jarName;
                String authorization = request.getHeader("Authorization");
                String result = this.sendPost(url, param, idToken, authorization);
                logger.info("URL:{},\u8bf7\u6c42\u5df2\u53d1\u9001\uff0c\u54cd\u5e94\u4fe1\u606f\uff1a{}", (Object)url, (Object)result);
                if (ToolUtil.isEmpty((Object)result)) {
                    message.add("\u8282\u70b9\uff1a" + colony + " \u52a0\u8f7d\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u8282\u70b9\u5065\u5eb7\u72b6\u6001\uff01");
                    continue;
                }
                JSONObject json = JSONObject.parseObject((String)result);
                if (!json.get((Object)"code").equals(ResultCode.SUCCESS.getCode())) {
                    message.add("\u8282\u70b9\uff1a" + colony + "\u52a0\u8f7d\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + json.get((Object)"msg"));
                    continue;
                }
                if (!json.get((Object)"code").equals(ResultCode.SUCCESS.getCode())) continue;
                message.add("\u8282\u70b9\uff1a" + colony + " \u52a0\u8f7d\u6210\u529f\uff01");
            }
        } else {
            return ApiResponse.fail((String)"\u96c6\u7fa4\u8282\u70b9\u672a\u914d\u7f6e!");
        }
        return ApiResponse.success((Object)message);
    }

    @PostMapping(value={"syncHotLoad"})
    public ApiResponse<String> syncHotLoad(@RequestParam(value="jarName") String jarNameList) throws Exception {
        String[] nameList;
        for (String jarName : nameList = jarNameList.split(",")) {
            String jarPath = FileUtil.posixPath((String[])new String[]{this.uploadTempPath, jarName});
            File jarFile = new File(jarPath);
            Path jarFilePath = jarFile.toPath();
            String zipFileName = FileUtil.posixPath((String[])new String[]{this.uploadTempPath, jarName.substring(0, jarName.length() - 4) + File.separator});
            ZipUtil.unzip(jarPath, zipFileName);
            File unZipFile = new File(zipFileName);
            File importProperties = FileUtils.getFile((File)unZipFile, (String[])new String[]{"plugin.properties"});
            Properties properties = PropertiesUtils.loadProperties((String)importProperties.getAbsolutePath());
            String pluginId = properties.getProperty("plugin.id");
            try {
                PluginInfo loadPluginInfo;
                PluginInfo pluginInfo = this.pluginOperator.getPluginInfo(pluginId);
                if (ToolUtil.isNotEmpty((Object)pluginInfo)) {
                    this.pluginOperator.uninstall(pluginId, false);
                }
                if ((loadPluginInfo = this.pluginOperator.load(jarFilePath)) == null) {
                    throw new HussarException("\u63d2\u4ef6\u52a0\u8f7d\u5931\u8d25\uff01");
                }
                GlobalRegistryInfo.addOperatorPluginInfo((String)pluginId, (PluginOperatorInfo.OperatorType)PluginOperatorInfo.OperatorType.INSTALL, (boolean)true);
                if (this.pluginOperator.start(pluginId)) continue;
                throw new HussarException("Plugin" + pluginId + " start failure");
            }
            catch (Exception var2) {
                throw new HussarException("\u63d2\u4ef6\u5b89\u88c5\u542f\u52a8\u5931\u8d25\uff1a" + var2.getMessage());
            }
            finally {
                if (!ObjectUtils.isEmpty((Object)pluginId)) {
                    GlobalRegistryInfo.setOperatorPluginInfo((String)pluginId, (boolean)false);
                }
                FileUtils.deleteDirectory((File)unZipFile);
            }
        }
        return ApiResponse.success((String)"\u63d2\u4ef6\u5b89\u88c5\u6210\u529f\uff01");
    }

    private List<String> getIpAndPortByServiceName(String serviceName) throws NacosException {
        NamingService namingService = this.nacosServiceManager.getNamingService();
        List allInstances = namingService.getAllInstances(serviceName);
        ArrayList result = Lists.newArrayList();
        for (Instance instance : allInstances) {
            String info = "http://" + instance.getIp() + ":" + instance.getPort();
            result.add(info);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sendPost(String url, String param, String idToken, String authorization) {
        PrintWriter out = null;
        BufferedReader in = null;
        StringBuilder result = new StringBuilder();
        try {
            String line;
            URL realUrl = new URL(url);
            URLConnection conn = realUrl.openConnection();
            if (HussarUtils.isNotEmpty((Object)authorization)) {
                conn.setRequestProperty("Isolate-key", idToken);
            }
            if (HussarUtils.isNotEmpty((Object)idToken)) {
                conn.setRequestProperty("Authorization", authorization);
            }
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            conn.setRequestProperty("client-id", "hussar-base");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setConnectTimeout(120000);
            out = new PrintWriter(conn.getOutputStream());
            out.print(param);
            out.flush();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = in.readLine()) != null) {
                result.append(line);
            }
        }
        catch (Exception e) {
            System.out.println("\u53d1\u9001 POST \u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38\uff01" + e);
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return result.toString();
    }
}

