/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.app.imports.controller;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.app.imports.service.BizAppExportService;
import com.jxdinfo.hussar.app.imports.vo.ExportParamVO;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/speed/resources"})
public class BizAppExportController {
    @Resource
    private BizAppExportService exportService;

    @GetMapping
    public FormDesignResponse<Map<String, List<JSONObject>>> resourceTree(@RequestParam(value="appId") String appId) {
        FormDesignResponse response = new FormDesignResponse();
        response.setData((Object)this.exportService.resourceTree(appId));
        return response;
    }

    @PostMapping
    public Map<String, String> getJavaFile(@RequestBody ExportParamVO exportParamVO, HttpServletResponse response) {
        try {
            return this.exportService.export(exportParamVO, response);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @GetMapping(value={"/expansionResourceTree"})
    public FormDesignResponse<Map<String, List<JSONObject>>> expansionResourceTree(@RequestParam(value="appId") String appId) {
        FormDesignResponse response = new FormDesignResponse();
        response.setData((Object)this.exportService.expansionResourceTree(appId));
        return response;
    }

    @PostMapping(value={"/exportExpansion"})
    public Map<String, String> exportExpansion(@RequestBody ExportParamVO exportParamVO, HttpServletResponse response) {
        try {
            return this.exportService.exportExpansion(exportParamVO, response);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @PostMapping(value={"/offline"})
    public Map<String, String> exportOfflineToOffline(@RequestBody ExportParamVO exportParamVO, HttpServletResponse response) {
        try {
            return this.exportService.exportOffline(exportParamVO, response);
        }
        catch (Exception e) {
            e.printStackTrace();
            try (ServletOutputStream outputStream = response.getOutputStream();){
                response.setStatus(500);
                outputStream.write(0);
                outputStream.flush();
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
            }
            return null;
        }
    }

    @PostMapping(value={"/expansionOffline"})
    public Map<String, String> exportExpansionOfflineToOffline(@RequestBody ExportParamVO exportParamVO, HttpServletResponse response) {
        try {
            return this.exportService.exportExpansionOffline(exportParamVO, response);
        }
        catch (Exception e) {
            e.printStackTrace();
            try (ServletOutputStream outputStream = response.getOutputStream();){
                response.setStatus(500);
                outputStream.write(0);
                outputStream.flush();
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
            }
            return null;
        }
    }
}

