/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.app.imports.service.impl;

import com.alibaba.cloud.nacos.NacosServiceManager;
import com.alibaba.druid.pool.ha.PropertiesUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jxdinfo.hussar.app.imports.model.PluginCodeGenerator;
import com.jxdinfo.hussar.app.imports.service.AppImportService;
import com.jxdinfo.hussar.app.imports.util.MavenUtil;
import com.jxdinfo.hussar.app.imports.util.TarUtil;
import com.jxdinfo.hussar.app.imports.util.ZipUtil;
import com.jxdinfo.hussar.applicationmix.constants.AppExportConstants;
import com.jxdinfo.hussar.applicationmix.feign.RemoteAppImportService;
import com.jxdinfo.hussar.applicationmix.model.BatchImportRecord;
import com.jxdinfo.hussar.applicationmix.model.SysAppImportHistory;
import com.jxdinfo.hussar.applicationmix.model.SysAppPackage;
import com.jxdinfo.hussar.applicationmix.model.SysEyImportAppMsg;
import com.jxdinfo.hussar.applicationmix.model.SysLowCodeAppExtend;
import com.jxdinfo.hussar.applicationmix.params.ApplicationMixProjectCodeArgs;
import com.jxdinfo.hussar.applicationmix.properties.HussarAppExportProperties;
import com.jxdinfo.hussar.applicationmix.properties.HussarClusterProperties;
import com.jxdinfo.hussar.applicationmix.properties.HussarProduceProperties;
import com.jxdinfo.hussar.applicationmix.service.IBatchImportRecordBoService;
import com.jxdinfo.hussar.applicationmix.service.IHussarBaseAppMixBoService;
import com.jxdinfo.hussar.applicationmix.service.IHussarBaseAppMixFileBoService;
import com.jxdinfo.hussar.applicationmix.service.IHussarBaseAppMixPackageBoService;
import com.jxdinfo.hussar.applicationmix.service.IHussarBaseImportAppHistoryBoService;
import com.jxdinfo.hussar.applicationmix.service.IHussarBaseImportAppMixMsgBoService;
import com.jxdinfo.hussar.applicationmix.service.IHussarBaseSharePluginBoService;
import com.jxdinfo.hussar.applicationmix.vo.MixAppInfoVo;
import com.jxdinfo.hussar.authorization.menu.feign.RemoteSysMenuManageBoService;
import com.jxdinfo.hussar.authorization.permit.feign.RemoteHussarBaseResourceService;
import com.jxdinfo.hussar.authorization.permit.feign.RemoteSysFunctionModulesBoService;
import com.jxdinfo.hussar.authorization.permit.feign.RemoteSysFunctionResourcesBoService;
import com.jxdinfo.hussar.authorization.permit.feign.RemoteSysFunctionsBoService;
import com.jxdinfo.hussar.authorization.permit.feign.RemoteSysResourceMosulesBoService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.SerializeUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.model.ColumnInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.MetadataParam;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.service.HussarDdlService;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableField;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableInfo;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.common.constant.ExportResourceConstant;
import com.jxdinfo.hussar.formdesign.common.file.StorageDumpLoadService;
import com.jxdinfo.hussar.formdesign.common.file.impl.vue.VuePathServiceImpl;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.external.inducts.InductsProjectStoreService;
import com.jxdinfo.hussar.formdesign.external.inducts.InductsTableService;
import com.jxdinfo.hussar.formdesign.importcode.service.PublishService;
import com.jxdinfo.hussar.formdesign.inducts.model.ExportApplicationSource;
import com.jxdinfo.hussar.formdesign.inducts.model.ImportApplicationSource;
import com.jxdinfo.hussar.formdesign.inducts.model.ProjectStoreArgs;
import com.jxdinfo.hussar.formdesign.util.CodeRelocationUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.expansion.core.service.dto.SharePluginInfoDto;
import com.jxdinfo.hussar.support.hotloaded.framework.integration.operator.PluginOperator;
import com.jxdinfo.hussar.support.hotloaded.framework.integration.operator.module.PluginInfo;
import com.jxdinfo.hussar.support.hotloaded.framework.utils.GlobalRegistryInfo;
import com.jxdinfo.hussar.support.hotloaded.framework.utils.PluginOperatorInfo;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.service.IHussarTenantCommonService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.WorkflowLoadAppDto;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dto.PublishExtensionProcessDto;
import com.jxdinfo.hussar.workflow.godaxe.model.GodAxeModelService;
import com.jxdinfo.hussar.workflow.manage.engine.WorkflowAppMigrationService;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.pf4j.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AppImportServiceImpl
implements AppImportService {
    private static final Logger logger = LoggerFactory.getLogger(AppImportServiceImpl.class);
    private static final String MODULES = "packages" + File.separator + "hussar-remote-";
    private static final String VIEWS = "views";
    private static final String API = "api";
    private static final String MF = "mf";
    private static final String VUE_DIST = "dist";
    private static final ThreadLocal<Map<String, Object>> context = ThreadLocal.withInitial(HashMap::new);
    @Resource
    private InductsProjectStoreService inductsProjectStoreService;
    @Autowired(required=false)
    private IHussarTenantCommonService tenantCommonService;
    @Autowired
    private FormDesignProperties formdesignProperties;
    @Value(value="${plugin.runMode:dev}")
    private String active;
    @Resource
    private ISysTenantService sysTenantService;
    @Autowired
    private HussarDdlService ddlService;
    @Autowired
    private StorageDumpLoadService storageDumpLoadService;
    @Resource
    private InductsTableService inductsTableService;
    @Resource
    private RemoteAppImportService remoteAppImportService;
    @Resource
    private IHussarBaseAppMixBoService hussarBaseAppMixBoService;
    @Lazy
    @Resource
    private PluginOperator pluginOperator;
    @Autowired
    private PublishService publishService;
    @Resource
    private HussarClusterProperties hussarClusterProperties;
    @Resource
    private IHussarBaseImportAppMixMsgBoService hussarBaseImportAppMixmsgBoService;
    @Resource
    private HussarAppExportProperties hussarAppExportProperties;
    @Autowired
    private HussarProduceProperties hussarProduceProperties;
    @Resource
    private IHussarBaseAppMixFileBoService hussarBaseAppMixFileBoService;
    @Resource
    private IHussarBaseAppMixPackageBoService hussarBaseAppMixPackageBoService;
    @Resource
    private IHussarBaseImportAppHistoryBoService hussarBaseImportAppHistoryBoService;
    @Resource
    private NacosServiceManager nacosServiceManager;
    @Resource
    private RemoteSysFunctionsBoService remoteSysFunctionsBoService;
    @Resource
    private RemoteSysFunctionModulesBoService remoteSysFunctionModulesBoService;
    @Resource
    private RemoteHussarBaseResourceService remoteHussarBaseResourceService;
    @Resource
    private RemoteSysResourceMosulesBoService remoteSysResourceMosulesBoService;
    @Resource
    private RemoteSysFunctionResourcesBoService remoteSysFunctionResourcesBoService;
    @Resource
    private RemoteSysMenuManageBoService remoteSysMenuManageBoService;
    @Resource
    private GodAxeModelService godAxeModelService;
    @Resource
    private IBatchImportRecordBoService batchImportRecordBoService;
    @Resource
    private IHussarBaseSharePluginBoService sharePluginService;
    @Value(value="${plugin.pluginPrefix:}")
    private String pluginPrefix;
    @Value(value="${plugin.modulePath:}")
    private String modulePath;
    @Value(value="${plugin.prefixName:}")
    private String prefixName;
    @Value(value="${plugin.appPrefixName:}")
    private String appPrefixName;
    @Value(value="${plugin.pluginParentName:}")
    private String pluginParentName;
    @Value(value="${hussar-formdesign.version:v1.0.0}")
    private String systemVersion;
    @Value(value="${hussar-formdesign.storage.workspace:default}")
    private String defaultDir;
    @Value(value="${hussar-formdesign.open-plugin:false}")
    private boolean openPlugin;
    @Value(value="${cluster.clusterType:0}")
    private String clusterType;
    @Value(value="${plugin.packageVersion:}")
    private String packageVersion;
    @Value(value="${cluster.sharePlugin:0}")
    private String sharePlugin;
    @Value(value="${cluster.localPlugin:0}")
    private String localPlugin;
    @Value(value="${hussar-formdesign.nginx-front-path:/usr/local/var/www/dist}")
    private String nginxFrontPath;
    @Value(value="${hussar-formdesign.front-project-path:}")
    private String frontProjectPath;
    @Value(value="${hussar-formdesign.workspace:}")
    private String workspace;
    private static final Pattern P = Pattern.compile("[a-zA-z]");
    public static final String PRINT_PREFIX = "==============================";
    private static final String expansion = "";

    public Map<String, Object> importProduceApp(MultipartFile multipartFile, Long appId) {
        Map<String, Object> returnMap = new HashMap<String, Object>();
        String msg = "\u5bfc\u5165\u5305";
        File temp = null;
        try {
            InputStream inputStream = multipartFile.getInputStream();
            temp = Files.createTempDirectory("appImport" + appId, new FileAttribute[0]).toFile();
            String tempZipName = multipartFile.getOriginalFilename();
            String safeFileName = new File(tempZipName).getName();
            if (!safeFileName.matches("^(?!(.*[\\\\/]|^)[.]{2}[\\\\/]|.*[\\\\/][.]{2}$|.*[\\\\/]\\.{1}[\\\\/]).+$")) {
                throw new HussarException("\u6587\u4ef6\u540d\u4e0d\u5408\u6cd5");
            }
            if (tempZipName.endsWith(".hussar")) {
                tempZipName = tempZipName.substring(0, tempZipName.length() - 7);
            }
            File tempFile = new File(temp.getAbsolutePath() + File.separator + tempZipName + ".zip");
            FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)tempFile);
            ZipUtil.unzip(tempFile.getAbsolutePath(), temp.getAbsolutePath() + File.separator);
            File metaFile = new File(temp + File.separator + ExportResourceConstant.META_JSON);
            if (!metaFile.exists()) {
                returnMap.put("status", false);
                returnMap.put("msg", msg + "\u683c\u5f0f\u6709\u8bef\uff0c\u4e0d\u5b58\u5728meta.json\u6587\u4ef6");
                return returnMap;
            }
            byte[] meta = FileUtils.readFileToByteArray((File)metaFile);
            Map metaMap = (Map)SerializeUtils.deserialize((byte[])meta);
            if (metaMap == null) {
                returnMap.put("status", false);
                returnMap.put("msg", "meta.json\u6587\u4ef6\u89e3\u6790\u5931\u8d25");
                return returnMap;
            }
            String appName = metaMap.get("appName") == null ? expansion : metaMap.get("appName").toString();
            String tenantId = metaMap.get("tenantId") == null ? expansion : metaMap.get("tenantId").toString();
            String importType = metaMap.get("importType") == null ? expansion : metaMap.get("importType").toString();
            String sign = metaMap.get("sign") == null ? expansion : metaMap.get("sign").toString();
            String version = metaMap.get("version") == null ? expansion : metaMap.get("version").toString();
            Map metaInfo = metaMap.get("metaInfo") == null ? null : (Map)metaMap.get("metaInfo");
            String serviceNameZip = metaMap.get("serviceName") == null ? expansion : metaMap.get("serviceName").toString();
            MixAppInfoVo appInfo = this.hussarBaseAppMixBoService.getMixAppInfo(appId);
            if (ToolUtil.isNotEmpty((Object)metaInfo)) {
                Map<String, String> sysMetaInfo = this.getSysMetaInfo(appId);
                for (String name : metaInfo.keySet()) {
                    if (!ToolUtil.isNotEmpty((Object)sysMetaInfo.get(name)) || ((String)metaInfo.get(name)).equals(sysMetaInfo.get(name))) continue;
                    returnMap.put("status", false);
                    returnMap.put("msg", "\u5b58\u5728\u540c\u540d\u4e0d\u540c\u6765\u6e90\u6a21\u5757\u3001\u9875\u9762\u6216\u5de5\u4f5c\u6d41\uff0c\u4e0d\u53ef\u5bfc\u5165");
                    return returnMap;
                }
            }
            if (!this.systemVersion.equals(version)) {
                returnMap.put("status", false);
                returnMap.put("msg", "\u7cfb\u7edf\u7248\u672c\u4e0e" + msg + "\u7684\u7cfb\u7edf\u7248\u672c\u4e0d\u4e00\u81f4\uff01");
                return returnMap;
            }
            if (!"1".equals(importType)) {
                returnMap.put("status", false);
                returnMap.put("msg", msg + "\u7c7b\u578b\u4e0d\u6b63\u786e\uff0c\u4e0d\u662f\u5f53\u524d\u73af\u5883\u9700\u8981\u7684\u5305\uff01");
                return returnMap;
            }
            if (!appInfo.getServiceName().equals(serviceNameZip)) {
                returnMap.put("status", false);
                returnMap.put("msg", "\u5e94\u7528\u6240\u5c5e\u670d\u52a1\u4e0e" + msg + "\u7684\u5e94\u7528\u6240\u5c5e\u670d\u52a1\u4e0d\u4e00\u81f4\uff01");
                return returnMap;
            }
            ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            String tenantCode = servletRequestAttributes.getRequest().getHeader("tcode");
            if (!appInfo.getAppEnglishName().equals(appName)) {
                returnMap.put("status", false);
                returnMap.put("msg", "\u5e94\u7528\u82f1\u6587\u540d\u79f0\u4e0e" + msg + "\u7684\u5e94\u7528\u82f1\u6587\u540d\u79f0\u4e0d\u4e00\u81f4\uff01");
                return returnMap;
            }
            File tar = new File(temp + File.separator + appName + ".tar");
            String md5 = ZipUtil.getMd5(tar.getAbsolutePath());
            logger.info("\u751f\u4ea7\u73af\u5883\u5bfc\u5165\uff1aMD5={}", (Object)md5);
            if (!md5.equals(sign)) {
                returnMap.put("status", false);
                returnMap.put("msg", msg + "\u5df2\u88ab\u4fee\u6539\uff01");
                return returnMap;
            }
            TarUtil.unTar(tar, temp.getAbsolutePath() + File.separator);
            returnMap = this.importData(temp, tenantCode, expansion, false);
            returnMap.put("status", true);
            returnMap.put("tempPath", temp.getAbsolutePath());
            returnMap.put("appId", appId);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            try {
                if (temp.exists()) {
                    FileUtils.forceDelete((File)temp);
                }
            }
            catch (IOException ioException) {
                logger.error(ioException.getMessage());
            }
        }
        return returnMap;
    }

    public String getAppDsName(String serverCode) {
        return Optional.ofNullable(serverCode).flatMap(code -> Optional.ofNullable(this.sysTenantService.getTenantByTenantCode(code)).map(HussarTenantDefinition::getConnName)).orElse(null);
    }

    public Long addWaitingCompileTask(Long appId) {
        SysAppPackage sysAppPackage = new SysAppPackage();
        sysAppPackage.setStatus("3");
        sysAppPackage.setAppId(appId);
        sysAppPackage.setCreateTime(LocalDateTime.now());
        SysAppPackage appPackage = this.hussarBaseAppMixPackageBoService.save(sysAppPackage);
        return appPackage.getId();
    }

    public boolean saveTempPathFile(Long appId, String serverCode, String tempPath, String uuid) {
        String importFileBackUpPath = FileUtil.posixPath((String[])new String[]{this.hussarClusterProperties.getImportFile(), File.separator, serverCode, File.separator, appId.toString(), File.separator, uuid});
        File tempPathOfImportFile = new File(tempPath);
        try {
            File importFileBefore = new File(importFileBackUpPath);
            if (ToolUtil.isNotEmpty((Object)importFileBefore) && importFileBefore.exists()) {
                try {
                    FileUtils.forceDelete((File)importFileBefore);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            FileUtils.copyDirectory((File)tempPathOfImportFile, (File)new File(importFileBackUpPath));
        }
        catch (IOException e) {
            logger.error("\u4fdd\u5b58\u6587\u4ef6\u9519\u8bef", (Throwable)e);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean saveImportMsgToTable(SysEyImportAppMsg appImportMsg) {
        try {
            this.hussarBaseImportAppMixmsgBoService.save(appImportMsg);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public Map<String, Object> importApp(MultipartFile multipartFile, Long appId, String type) throws Exception {
        Map<String, Object> returnMap;
        File temp;
        block10: {
            Map<String, Object> map;
            Map metaMap;
            block9: {
                File metaFile;
                block8: {
                    temp = null;
                    returnMap = new HashMap<String, Object>();
                    InputStream inputStream = multipartFile.getInputStream();
                    temp = Files.createTempDirectory("appImport" + appId, new FileAttribute[0]).toFile();
                    File tempFile = new File(temp.getAbsolutePath() + File.separator + appId + ".zip");
                    FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)tempFile);
                    ZipUtil.unzip(tempFile.getAbsolutePath(), temp.getAbsolutePath() + File.separator);
                    metaFile = new File(temp + File.separator + ExportResourceConstant.META_JSON);
                    if (metaFile.exists()) break block8;
                    returnMap.put("status", false);
                    returnMap.put("msg", "\u521d\u59cb\u5316\u5305\u683c\u5f0f\u6709\u8bef\uff0c\u4e0d\u5b58\u5728meta.json\u6587\u4ef6");
                    HashMap<String, Object> hashMap = returnMap;
                    this.deleteTempFileWithoutWorkFlow(temp);
                    return hashMap;
                }
                byte[] meta = FileUtils.readFileToByteArray((File)metaFile);
                metaMap = (Map)SerializeUtils.deserialize((byte[])meta);
                if (metaMap != null) break block9;
                returnMap.put("status", false);
                returnMap.put("msg", "meta.json\u6587\u4ef6\u89e3\u6790\u5931\u8d25");
                HashMap<String, Object> hashMap = returnMap;
                this.deleteTempFileWithoutWorkFlow(temp);
                return hashMap;
            }
            try {
                String importType;
                String string = importType = metaMap.get("importType") == null ? expansion : metaMap.get("importType").toString();
                if ("0".equals(importType) || "2".equals(importType)) {
                    returnMap = this.initAppToOffline(appId, temp, metaMap, returnMap);
                    break block10;
                }
                returnMap.put("status", false);
                returnMap.put("msg", "\u521d\u59cb\u5316\u5305\u7c7b\u578b\u4e0d\u6b63\u786e\uff0c\u4e0d\u662f\u5f53\u524d\u73af\u5883\u9700\u8981\u7684\u5305\uff01");
                map = returnMap;
            }
            catch (Exception e) {
                try {
                    if (ToolUtil.isNotEmpty(temp) && temp.exists()) {
                        FileUtils.forceDelete((File)temp);
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    this.deleteTempFileWithoutWorkFlow(temp);
                    throw throwable;
                }
            }
            this.deleteTempFileWithoutWorkFlow(temp);
            return map;
        }
        this.deleteTempFileWithoutWorkFlow(temp);
        return returnMap;
    }

    public Map<String, Object> importExpansionApp(MultipartFile multipartFile, Long appId) throws Exception {
        File temp = null;
        Map<String, Object> returnMap = new HashMap<String, Object>();
        try {
            String importType;
            InputStream inputStream = multipartFile.getInputStream();
            temp = Files.createTempDirectory("appImport" + appId, new FileAttribute[0]).toFile();
            File tempFile = new File(temp.getAbsolutePath() + File.separator + appId + ".zip");
            FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)tempFile);
            ZipUtil.unzip(tempFile.getAbsolutePath(), temp.getAbsolutePath() + File.separator);
            File metaFile = new File(temp + File.separator + ExportResourceConstant.META_JSON);
            if (!metaFile.exists()) {
                returnMap.put("status", false);
                returnMap.put("msg", "\u521d\u59cb\u5316\u5305\u683c\u5f0f\u6709\u8bef\uff0c\u4e0d\u5b58\u5728meta.json\u6587\u4ef6");
                return returnMap;
            }
            byte[] meta = FileUtils.readFileToByteArray((File)metaFile);
            Map metaMap = (Map)SerializeUtils.deserialize((byte[])meta);
            if (metaMap == null) {
                returnMap.put("status", false);
                returnMap.put("msg", "meta.json\u6587\u4ef6\u89e3\u6790\u5931\u8d25");
                return returnMap;
            }
            String string = importType = metaMap.get("importType") == null ? expansion : metaMap.get("importType").toString();
            if (!"0".equals(importType) && !"2".equals(importType)) {
                returnMap.put("status", false);
                returnMap.put("msg", "\u521d\u59cb\u5316\u5305\u7c7b\u578b\u4e0d\u6b63\u786e\uff0c\u4e0d\u662f\u5f53\u524d\u73af\u5883\u9700\u8981\u7684\u5305\uff01");
                return returnMap;
            }
            returnMap = this.initExpansionAppToOffline(appId, temp, metaMap, returnMap);
        }
        catch (Exception e) {
            if (ToolUtil.isNotEmpty(temp) && temp.exists()) {
                FileUtils.forceDelete((File)temp);
            }
            throw e;
        }
        return returnMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadOffline(String tempPath, String filePath, HttpServletResponse response) {
        File file = new File(filePath);
        if (!file.exists()) {
            return;
        }
        try {
            String newFileName = URLEncoder.encode(file.getName(), "UTF-8");
            response.addHeader("Content-Disposition", "attachment;filename=" + newFileName);
            response.setContentType("multipart/form-data");
            try (BufferedInputStream bism = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]), 10240);
                 BufferedOutputStream bos = new BufferedOutputStream((OutputStream)response.getOutputStream());){
                int len;
                int i = bism.available();
                byte[] buff = new byte[i];
                while ((len = bism.read(buff)) > 0) {
                    bos.write(buff, 0, len);
                    bos.flush();
                }
            }
        }
        catch (IOException e) {
            logger.error("\u8f93\u51fa\u6587\u4ef6\u6d41\u65f6\u629b\u5f02\u5e38\uff0cfilePath={}", (Object)file.getAbsolutePath(), (Object)e);
        }
        finally {
            try {
                File tempFile = new File(tempPath);
                FileUtils.forceDelete((File)tempFile);
                FileUtils.forceDelete((File)file);
            }
            catch (IOException e) {
                logger.info("\u5173\u6d41\u5f02\u5e38:{}", (Object)e.getMessage());
            }
        }
    }

    public Boolean addPluginsModule(String applicationName, String chineseName, String serviceName) {
        this.executeScript(false, serviceName, applicationName);
        if (this.pluginPrefix != null && this.modulePath != null) {
            String absolutePath = this.modulePath;
            int end = absolutePath.lastIndexOf(File.separator);
            if (end != absolutePath.length() - 1) {
                absolutePath = absolutePath + File.separator;
            }
            String prefixPath = absolutePath + (ToolUtil.isNotEmpty((Object)this.prefixName) ? this.prefixName : "hussar-plugin");
            String appPrefixPath = absolutePath + (ToolUtil.isNotEmpty((Object)this.appPrefixName) ? this.appPrefixName : "hussar-web");
            File module = new File(prefixPath);
            SecurityUser securityUser = BaseSecurityUtil.getUser();
            if (ToolUtil.isEmpty((Object)securityUser)) {
                throw new BaseException("\u4e8c\u6b21\u8ba4\u8bc1\u5f02\u5e38\uff0c\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
            }
            if (module.exists()) {
                String userCode = securityUser.getTenantCode();
                String tenantCode = AppContextUtil.asIdentifier((String)userCode);
                String serviceNameCode = AppContextUtil.asIdentifier((String)serviceName);
                String applicationCode = AppContextUtil.asIdentifier((String)applicationName);
                String account = securityUser.getAccount();
                String tenantPath = prefixPath + File.separator + this.pluginPrefix + tenantCode;
                String tenAndService = AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)serviceNameCode);
                String tenAndServicePath = tenantPath + File.separator + this.pluginPrefix + tenAndService;
                String tenAndApp = AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)serviceNameCode) + "-" + AppContextUtil.asIdentifier((String)applicationName);
                String tenantAppPath = tenAndServicePath + File.separator + this.pluginPrefix + tenAndApp;
                String applicationPath = tenAndServicePath + File.separator + this.pluginPrefix + tenAndApp + File.separator + this.pluginPrefix + tenAndApp + "-application";
                String apiPath = tenAndServicePath + File.separator + this.pluginPrefix + tenAndApp + File.separator + this.pluginPrefix + tenAndApp + "-api";
                File application = new File(tenantAppPath);
                if (!application.exists()) {
                    application.mkdirs();
                    String relativeRPath = "src.main.resources";
                    String resourcePath = appPrefixPath + File.separator + relativeRPath.replace(".", File.separator);
                    String relativeMainPath = "src.main";
                    String mainPath = applicationPath + File.separator + relativeMainPath.replace(".", File.separator);
                    String mainApiPath = apiPath + File.separator + relativeMainPath.replace(".", File.separator);
                    String tenantCodeLow = tenantCode.toLowerCase();
                    String serviceNameCodeLow = serviceNameCode.toLowerCase();
                    String applicationCodeLow = applicationCode.toLowerCase();
                    HashMap<String, Object> apiPomParam = new HashMap<String, Object>();
                    apiPomParam.put("artifactId", this.pluginPrefix + tenAndApp + "-api");
                    apiPomParam.put("pluginParentName", this.pluginPrefix + tenAndApp);
                    apiPomParam.put("pluginVersion", this.packageVersion);
                    String apiPomTName = "apiPom.ftl";
                    String apiPomFName = "pom.xml";
                    PluginCodeGenerator apiPomGen = new PluginCodeGenerator(apiPomTName, apiPomParam, apiPath, apiPomFName);
                    apiPomGen.gen();
                    String relativeApiPath = "java.com.jxdinfo.hussar.cloud.module.example." + tenantCodeLow + "." + serviceNameCodeLow + "." + applicationCodeLow;
                    String apiFolderPath = mainApiPath + File.separator + relativeApiPath.replace(".", File.separator);
                    File directory = new File(apiFolderPath);
                    if (!directory.exists()) {
                        directory.mkdirs();
                    }
                    String relativeConfigPath = "java.com.jxdinfo.hussar.cloud.module.example." + tenantCodeLow + "." + serviceNameCodeLow + "." + applicationCodeLow + ".config";
                    String configPath = mainPath + File.separator + relativeConfigPath.replace(".", File.separator);
                    String configBeanTName = "PluginMybatisPlusConfiguration.ftl";
                    String configBeanFName = "PluginMybatisPlusConfiguration.java";
                    String appPath = tenantCodeLow + "/" + serviceNameCodeLow + "/" + applicationCodeLow;
                    HashMap<String, Object> configParams = new HashMap<String, Object>();
                    configParams.put("tenantCode", tenantCodeLow);
                    configParams.put("applicationCode", applicationCodeLow);
                    configParams.put("serviceName", serviceNameCodeLow);
                    configParams.put("applicationPath", appPath);
                    PluginCodeGenerator configBeanGen = new PluginCodeGenerator(configBeanTName, configParams, configPath, configBeanFName);
                    configBeanGen.gen();
                    String dbConfigBeanTName = "pluginConfigrationGen.ftl";
                    String dbConfigBeanFName = "PluginConfigration.java";
                    HashMap<String, Object> dbConfigParams = new HashMap<String, Object>();
                    dbConfigParams.put("tenantCode", tenantCodeLow);
                    dbConfigParams.put("applicationCode", applicationCodeLow);
                    dbConfigParams.put("serviceName", serviceNameCodeLow);
                    PluginCodeGenerator dbConfigBeanGen = new PluginCodeGenerator(dbConfigBeanTName, dbConfigParams, configPath, dbConfigBeanFName);
                    dbConfigBeanGen.gen();
                    String relativeParamsPath = "java.com.jxdinfo.hussar.cloud.module.example." + tenantCodeLow + "." + serviceNameCodeLow + "." + applicationCodeLow;
                    String paramsPath = mainPath + File.separator + relativeParamsPath.replace(".", File.separator);
                    String newAppName = applicationName;
                    Pattern p = Pattern.compile("[a-zA-z]");
                    String appFirst = applicationName.substring(0, 1);
                    if (p.matcher(appFirst).find()) {
                        newAppName = appFirst.toUpperCase() + applicationName.substring(1);
                    }
                    String tenantUp = tenantCode;
                    String tenantFist = tenantCode.substring(0, 1);
                    if (!"_".equals(tenantFist)) {
                        tenantUp = tenantFist.toUpperCase() + tenantCode.substring(1);
                    }
                    String className = tenantUp + newAppName + "ParamsPlugin";
                    String paramsTName = "ParamsPlugin.ftl";
                    String paramsFName = className + ".java";
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("className", className);
                    params.put("tenantCode", tenantCodeLow);
                    params.put("applicationCode", applicationCodeLow);
                    params.put("serviceName", serviceNameCodeLow);
                    PluginCodeGenerator paramsGen = new PluginCodeGenerator(paramsTName, params, paramsPath, paramsFName);
                    paramsGen.gen();
                    String pluginPath = mainPath + File.separator + "resources";
                    String pluginTName = "plugin.ftl";
                    String pluginFName = "plugin.properties";
                    String classPath = "com.jxdinfo.hussar.cloud.module.example." + tenantCodeLow + "." + serviceNameCodeLow + "." + applicationCodeLow + "." + className;
                    HashMap<String, Object> pluginParam = new HashMap<String, Object>();
                    pluginParam.put("id", tenAndApp);
                    pluginParam.put("class", classPath);
                    pluginParam.put("provider", account);
                    pluginParam.put("description", chineseName);
                    PluginCodeGenerator pluginGen = new PluginCodeGenerator(pluginTName, pluginParam, pluginPath, pluginFName);
                    pluginGen.gen();
                    pluginParam.put("id", tenAndApp);
                    pluginParam.put("class", classPath);
                    pluginParam.put("provider", account);
                    pluginParam.put("artifactId", this.pluginPrefix + tenAndApp + "-application");
                    pluginParam.put("apiArtifactId", this.pluginPrefix + tenAndApp + "-api");
                    pluginParam.put("pluginParentName", ToolUtil.isNotEmpty((Object)this.pluginParentName) ? this.pluginParentName : "hussar-plugin-parent");
                    pluginParam.put("pluginVersion", this.packageVersion);
                    String appPomTName = "appPom.ftl";
                    String appPomFName = "pom.xml";
                    PluginCodeGenerator appPomGen = new PluginCodeGenerator(appPomTName, pluginParam, applicationPath, appPomFName);
                    appPomGen.gen();
                    HashMap<String, Object> pluginPomParam = new HashMap<String, Object>();
                    pluginPomParam.put("pluginVersion", this.packageVersion);
                    pluginPomParam.put("artifactId", this.pluginPrefix + tenAndApp);
                    pluginPomParam.put("applicationArtifactId", this.pluginPrefix + tenAndApp + "-application");
                    pluginPomParam.put("apiArtifactId", this.pluginPrefix + tenAndApp + "-api");
                    String pluginPomTName = "pluginPom.ftl";
                    String pluginPomFName = "pom.xml";
                    PluginCodeGenerator pluginPomGen = new PluginCodeGenerator(pluginPomTName, pluginPomParam, tenantAppPath, pluginPomFName);
                    pluginPomGen.gen();
                    String pomUrl = absolutePath + this.prefixName + File.separator + "pom.xml";
                    String moduleName = this.pluginPrefix + tenantCode + File.separator + this.pluginPrefix + tenAndService + File.separator + this.pluginPrefix + tenAndApp;
                    this.editPomXml(pomUrl, moduleName);
                }
                try {
                    SharePluginInfoDto pluginInfoDto = new SharePluginInfoDto();
                    pluginInfoDto.setSharePluginId(tenAndApp);
                    pluginInfoDto.setTenantCode(userCode);
                    pluginInfoDto.setAppCode(applicationName);
                    pluginInfoDto.setAppName(chineseName);
                    pluginInfoDto.setAppVersion(expansion);
                    pluginInfoDto.setRunMode(this.active);
                    pluginInfoDto.setServiceName(serviceName);
                    String pluginParentPath = new File(this.hussarProduceProperties.getPluginPath()).getParent();
                    String pluginBackUpPath = FileUtil.posixPath((String[])new String[]{pluginParentPath, "hussar-plugin-back"});
                    pluginInfoDto.setBackupPluginPath(pluginBackUpPath);
                    HussarTenantDefinition tenantByTenantCode = this.sysTenantService.getTenantByTenantCode(userCode);
                    if (HussarUtils.isNotEmpty((Object)tenantByTenantCode)) {
                        pluginInfoDto.setConnName(tenantByTenantCode.getConnName());
                    }
                    this.sharePluginService.savePluginInfo(pluginInfoDto);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return true;
            }
        }
        logger.warn("\u6587\u4ef6\u6a21\u5757\u751f\u6210\u5931\u8d25");
        return false;
    }

    public Boolean addExpansionPluginsModule(String applicationName, String serviceName, boolean isImport) {
        this.executeScript(true, serviceName, applicationName);
        if (this.pluginPrefix != null && this.modulePath != null) {
            String absolutePath = this.modulePath;
            int end = absolutePath.lastIndexOf(File.separator);
            if (end != absolutePath.length() - 1) {
                absolutePath = absolutePath + File.separator;
            }
            String prefixPath = absolutePath + (ToolUtil.isNotEmpty((Object)this.prefixName) ? this.prefixName : "hussar-plugin");
            String appPrefixPath = absolutePath + (ToolUtil.isNotEmpty((Object)this.appPrefixName) ? this.appPrefixName : "hussar-web");
            File module = new File(prefixPath);
            SecurityUser securityUser = BaseSecurityUtil.getUser();
            PublishExtensionProcessDto processDto = new PublishExtensionProcessDto();
            processDto.setAppCode(applicationName);
            MixAppInfoVo appInfo = this.hussarBaseAppMixBoService.getMixAppInfoByCode(applicationName);
            if (HussarUtils.isNotEmpty((Object)appInfo)) {
                processDto.setAppId(appInfo.getId().toString());
            }
            if (ToolUtil.isEmpty((Object)securityUser)) {
                throw new BaseException("\u4e8c\u6b21\u8ba4\u8bc1\u5f02\u5e38\uff0c\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
            }
            if (module.exists()) {
                String userCode = securityUser.getTenantCode();
                String tenantCode = AppContextUtil.asIdentifier((String)userCode);
                String serviceNameCode = AppContextUtil.asIdentifier((String)serviceName);
                String applicationCode = AppContextUtil.asIdentifier((String)applicationName);
                String account = securityUser.getAccount();
                String tenantPath = prefixPath + File.separator + this.pluginPrefix + tenantCode;
                String tenAndService = AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)serviceNameCode);
                String tenAndServicePath = tenantPath + File.separator + this.pluginPrefix + tenAndService;
                String tenAndApp = AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)serviceNameCode) + "-" + AppContextUtil.asIdentifier((String)applicationName);
                String expansionPath = tenAndServicePath + File.separator + this.pluginPrefix + tenAndApp + expansion;
                File application = new File(expansionPath);
                String standardApplicationName = applicationName.length() >= 10 ? applicationName.substring(0, applicationName.length() - 10) : applicationName;
                SharePluginInfoDto sharePluginInfoDto = this.sharePluginService.queryPluginInfo(userCode, standardApplicationName);
                if (HussarUtils.isEmpty((Object)sharePluginInfoDto)) {
                    throw new BaseException("\u8bf7\u5148\u5bfc\u5165\u6807\u51c6\u5e94\u7528");
                }
                String standardPluginId = sharePluginInfoDto.getSharePluginId();
                String standardAppVersion = sharePluginInfoDto.getAppVersion();
                if (HussarUtils.isEmpty((Object)standardPluginId) || HussarUtils.isEmpty((Object)standardAppVersion)) {
                    throw new BaseException("\u6807\u51c6\u5e94\u7528\u5b58\u50a8\u4fe1\u606f\u4e3a\u7a7a");
                }
                String expansionPluginId = AppContextUtil.asIdentifier((String)tenantCode) + "-" + standardPluginId + "-" + standardAppVersion + "_extension";
                if (!application.exists() && !isImport) {
                    try {
                        this.godAxeModelService.saveExtendWorkflowWithAppCode(processDto);
                    }
                    catch (Exception e) {
                        logger.error("\u521b\u5efa\u6269\u5c55\u5e94\u7528\uff0c\u4e3a\u6d41\u7a0b\u53d1\u5e03\u65b0\u7248\u672c\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                    }
                    application.mkdirs();
                    String relativeRPath = "src.main.resources";
                    String resourcePath = appPrefixPath + File.separator + relativeRPath.replace(".", File.separator);
                    String relativeMainPath = "src.main";
                    String mainExpansionPath = expansionPath + File.separator + relativeMainPath.replace(".", File.separator);
                    String tenantCodeLow = tenantCode.toLowerCase();
                    String serviceNameCodeLow = serviceNameCode.toLowerCase();
                    String applicationCodeLowExpansion = applicationCode.toLowerCase() + expansion;
                    String expansionRelativeConfigPath = "java.com.jxdinfo.hussar.cloud.module.example." + tenantCodeLow + "." + serviceNameCodeLow + "." + applicationCodeLowExpansion + ".config";
                    String expansionConfigPath = mainExpansionPath + File.separator + expansionRelativeConfigPath.replace(".", File.separator);
                    File directory = new File(expansionConfigPath);
                    if (!directory.exists()) {
                        directory.mkdirs();
                    }
                    String expansionConfigBeanTName = "ExpansionColumnInfoConfig.ftl";
                    String expansionConfigBeanFName = "ExpansionColumnInfoConfig.java";
                    HashMap<String, Object> expansionConfigParams = new HashMap<String, Object>();
                    expansionConfigParams.put("tenantCode", tenantCodeLow);
                    expansionConfigParams.put("serviceName", serviceNameCodeLow);
                    expansionConfigParams.put("applicationCode", applicationCodeLowExpansion);
                    PluginCodeGenerator expansionConfigBeanGen = new PluginCodeGenerator(expansionConfigBeanTName, expansionConfigParams, expansionConfigPath, expansionConfigBeanFName);
                    expansionConfigBeanGen.gen();
                    String dbConfigBeanTName = "pluginConfigrationGen.ftl";
                    String dbConfigBeanFName = "PluginConfigration.java";
                    HashMap<String, Object> dbConfigParams = new HashMap<String, Object>();
                    dbConfigParams.put("tenantCode", tenantCodeLow);
                    dbConfigParams.put("applicationCode", applicationCodeLowExpansion);
                    dbConfigParams.put("serviceName", serviceNameCodeLow);
                    PluginCodeGenerator dbConfigBeanGen = new PluginCodeGenerator(dbConfigBeanTName, dbConfigParams, expansionConfigPath, dbConfigBeanFName);
                    dbConfigBeanGen.gen();
                    String configBeanTName = "PluginMybatisPlusConfiguration.ftl";
                    String configBeanFName = "PluginMybatisPlusConfiguration.java";
                    String appPath = tenantCodeLow + "/" + serviceNameCodeLow + "/" + applicationCodeLowExpansion;
                    HashMap<String, Object> configParams = new HashMap<String, Object>();
                    configParams.put("tenantCode", tenantCodeLow);
                    configParams.put("applicationCode", applicationCodeLowExpansion);
                    configParams.put("serviceName", serviceNameCodeLow);
                    configParams.put("applicationPath", appPath);
                    PluginCodeGenerator configBeanGen = new PluginCodeGenerator(configBeanTName, configParams, expansionConfigPath, configBeanFName);
                    configBeanGen.gen();
                    String expansionRelativeServicePath = "java.com.jxdinfo.hussar.cloud.module.example." + tenantCodeLow + "." + serviceNameCodeLow + "." + applicationCodeLowExpansion + ".service";
                    String expansionServicePath = mainExpansionPath + File.separator + expansionRelativeServicePath.replace(".", File.separator);
                    String appExpansionName = applicationName;
                    String appExpansionFirst = appExpansionName.substring(0, 1);
                    Pattern p = Pattern.compile("[a-zA-z]");
                    if (p.matcher(appExpansionFirst).find()) {
                        appExpansionName = appExpansionFirst.toUpperCase() + applicationName.substring(1);
                    }
                    String serviceUp = serviceNameCode;
                    String serviceFirst = serviceNameCode.substring(0, 1);
                    if (!"_".equals(serviceFirst)) {
                        serviceUp = serviceFirst.toUpperCase() + tenantCode.substring(1);
                    }
                    String tenantUp = tenantCode;
                    String tenantFist = tenantCode.substring(0, 1);
                    if (!"_".equals(tenantFist)) {
                        tenantUp = tenantFist.toUpperCase() + tenantCode.substring(1);
                    }
                    String tenantAndExpansion = tenantUp + serviceUp + appExpansionName;
                    String expansionServiceBeanTName = "ExpansionColumnService.ftl";
                    String expansionServiceBeanFName = tenantAndExpansion + "ExpansionColumnService.java";
                    HashMap<String, Object> expansionServiceParams = new HashMap<String, Object>();
                    expansionServiceParams.put("id", tenAndApp + expansion);
                    expansionServiceParams.put("tenantCode", tenantCodeLow);
                    expansionServiceParams.put("serviceName", serviceNameCodeLow);
                    expansionServiceParams.put("applicationCode", applicationCodeLowExpansion);
                    expansionServiceParams.put("tenantAndExpansion", tenantAndExpansion);
                    PluginCodeGenerator expansionServiceBeanGen = new PluginCodeGenerator(expansionServiceBeanTName, expansionServiceParams, expansionServicePath, expansionServiceBeanFName);
                    expansionServiceBeanGen.gen();
                    String pluginExpansionRelativePath = "java.com.jxdinfo.hussar.cloud.module.example." + tenantCodeLow + "." + serviceNameCodeLow + "." + applicationCodeLowExpansion;
                    String pluginExpansionPath = mainExpansionPath + File.separator + pluginExpansionRelativePath.replace(".", File.separator);
                    String pluginExpansionBeanTName = "PluginExpansion.ftl";
                    String pluginExpansionBeanFName = tenantAndExpansion + "PluginExpansion.java";
                    HashMap<String, Object> pluginExpansionParams = new HashMap<String, Object>();
                    pluginExpansionParams.put("tenantCode", tenantCodeLow);
                    pluginExpansionParams.put("serviceName", serviceNameCodeLow);
                    pluginExpansionParams.put("applicationCode", applicationCodeLowExpansion);
                    pluginExpansionParams.put("tenantAndExpansion", tenantAndExpansion);
                    PluginCodeGenerator plugonExpansionBeanGen = new PluginCodeGenerator(pluginExpansionBeanTName, pluginExpansionParams, pluginExpansionPath, pluginExpansionBeanFName);
                    plugonExpansionBeanGen.gen();
                    String expansionPluginPath = mainExpansionPath + File.separator + "resources";
                    String pluginTName = "plugin.ftl";
                    String pluginFName = "plugin.properties";
                    String expansionClassPath = "com.jxdinfo.hussar.cloud.module.example." + tenantCodeLow + "." + serviceNameCodeLow + "." + applicationCodeLowExpansion + "." + tenantAndExpansion + "PluginExpansion";
                    HashMap<String, Object> expansionPluginParam = new HashMap<String, Object>();
                    expansionPluginParam.put("id", expansionPluginId);
                    expansionPluginParam.put("class", expansionClassPath);
                    expansionPluginParam.put("provider", account);
                    expansionPluginParam.put("description", applicationName + expansion);
                    PluginCodeGenerator expansionPluginGen = new PluginCodeGenerator(pluginTName, expansionPluginParam, expansionPluginPath, pluginFName);
                    expansionPluginGen.gen();
                    String expansionDevFilePath = expansionPluginPath + File.separator + "expansion-columninfo-dev.yml";
                    File devFile = new File(expansionDevFilePath);
                    try {
                        if (!devFile.exists()) {
                            devFile.createNewFile();
                            logger.info("\u6587\u4ef6\u5df2\u521b\u5efa: {}", (Object)devFile.getAbsolutePath());
                        } else {
                            System.out.println("\u6587\u4ef6\u5df2\u5b58\u5728: " + devFile.getAbsolutePath());
                        }
                        FileWriter writer = new FileWriter(devFile, false);
                        writer.close();
                    }
                    catch (IOException e) {
                        throw new HussarException("expansion-columninfo-dev.yml\u6587\u4ef6\u521b\u5efa\u5931\u8d25");
                    }
                    String expansionProdFilePath = expansionPluginPath + File.separator + "expansion-columninfo-prod.yml";
                    File prodFile = new File(expansionProdFilePath);
                    try {
                        if (!prodFile.exists()) {
                            prodFile.createNewFile();
                            System.out.println("\u6587\u4ef6\u5df2\u521b\u5efa: " + prodFile.getAbsolutePath());
                        } else {
                            System.out.println("\u6587\u4ef6\u5df2\u5b58\u5728: " + prodFile.getAbsolutePath());
                        }
                        FileWriter writer = new FileWriter(prodFile, false);
                        writer.close();
                    }
                    catch (IOException e) {
                        throw new HussarException("expansion-columninfo-prod.yml\u521b\u5efa\u5931\u8d25");
                    }
                    expansionPluginParam.put("id", tenAndApp + expansion);
                    expansionPluginParam.put("class", expansionClassPath);
                    expansionPluginParam.put("provider", account);
                    expansionPluginParam.put("artifactId", this.pluginPrefix + tenAndApp + expansion);
                    String expansionPomTName = "expansionPom.ftl";
                    String expansionPomFName = "pom.xml";
                    PluginCodeGenerator expansionPomGen = new PluginCodeGenerator(expansionPomTName, expansionPluginParam, expansionPath, expansionPomFName);
                    expansionPomGen.gen();
                    String pomUrl = absolutePath + this.prefixName + File.separator + "pom.xml";
                    String expansionModuleName = this.pluginPrefix + tenantCode + File.separator + this.pluginPrefix + tenAndService + File.separator + this.pluginPrefix + tenAndApp + expansion;
                    this.editPomXml(pomUrl, expansionModuleName);
                    sharePluginInfoDto.setExpansionPluginId(expansionPluginId);
                    this.sharePluginService.savePluginInfo(sharePluginInfoDto);
                    return true;
                }
                if (application.exists() && isImport) {
                    Throwable throwable;
                    String relativeMainPath = "src.main";
                    String expansionPluginPropertiesPath = expansionPath + File.separator + relativeMainPath.replace(".", File.separator) + File.separator + "resources" + File.separator + "plugin.properties";
                    Properties properties = new Properties();
                    try {
                        throwable = null;
                        try (FileInputStream fis = new FileInputStream(expansionPluginPropertiesPath);){
                            properties.load(fis);
                            properties.setProperty("plugin.id", expansionPluginId);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    catch (IOException e) {
                        throw new HussarException("\u4fee\u6539\u6269\u5c55\u914d\u7f6e\u6587\u4ef6\u5931\u8d25");
                    }
                    try {
                        throwable = null;
                        try (FileOutputStream fos = new FileOutputStream(expansionPluginPropertiesPath);){
                            properties.store(fos, "Updated plugin.id");
                        }
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            throw throwable3;
                        }
                    }
                    catch (IOException e) {
                        throw new HussarException("\u4fee\u6539\u6269\u5c55\u914d\u7f6e\u6587\u4ef6\u5931\u8d25");
                    }
                    sharePluginInfoDto.setExpansionPluginId(expansionPluginId);
                    this.sharePluginService.savePluginInfo(sharePluginInfoDto);
                    return true;
                }
            }
        }
        logger.warn("\u6587\u4ef6\u6a21\u5757\u751f\u6210\u5931\u8d25");
        return false;
    }

    private void executeScript(boolean isExpansion, String serviceName, String appName) {
        File frontProject;
        String os = System.getProperty("os.name").toLowerCase();
        boolean isWindows = os.indexOf("windows") != -1;
        String hussarFrontPath = this.workspace + this.frontProjectPath;
        if (!hussarFrontPath.endsWith(File.separator)) {
            hussarFrontPath = hussarFrontPath + File.separator;
        }
        if (!(frontProject = new File(hussarFrontPath = hussarFrontPath.replace("\\", "/"))).exists()) {
            return;
        }
        appName = AppContextUtil.asIdentifier((String)serviceName) + "_" + AppContextUtil.asIdentifier((String)appName);
        String tcode = AppContextUtil.asIdentifier((String)HussarContextHolder.getHussarTenant().getTenantCode());
        String frontModulePath = MODULES + tcode + "-" + appName;
        File frontModule = new File(hussarFrontPath + frontModulePath);
        if (frontModule.exists()) {
            return;
        }
        String[] command = isWindows ? (isExpansion ? new String[]{"cmd.exe", "/c", "node", "./config/module-federation/gen-mf-extension-template.mjs", appName, tcode} : new String[]{"cmd.exe", "/c", "node", "./config/module-federation/gen-mf-template.mjs", appName, tcode}) : (isExpansion ? new String[]{"sh", "-c", "node ./config/module-federation/gen-mf-extension-template.mjs " + appName + " " + tcode} : new String[]{"sh", "-c", "node ./config/module-federation/gen-mf-template.mjs " + appName + " " + tcode});
        try {
            ProcessBuilder pb = new ProcessBuilder(command).directory(new File(hussarFrontPath.replace("\\", "/"))).redirectErrorStream(true);
            Process process = pb.start();
            try (InputStream is = process.getInputStream();){
                int bytesRead;
                byte[] buffer = new byte[1024];
                while ((bytesRead = is.read(buffer)) != -1) {
                    logger.info("[Node Output] " + new String(buffer, 0, bytesRead, StandardCharsets.UTF_8));
                }
            }
            int exitCode = process.waitFor();
            logger.info("\u6267\u884c\u5b8c\u6210\uff0c\u9000\u51fa\u7801: " + exitCode);
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void editPomXml(String pomUrl, String moduleName) {
        logger.info("pomUrl:{}", (Object)pomUrl);
        System.getProperty("java.classpath");
        try (FileReader fis = new FileReader(pomUrl);){
            MavenXpp3Reader reader = new MavenXpp3Reader();
            Model model = reader.read((Reader)fis);
            List modules = model.getModules();
            if (!modules.contains(moduleName)) {
                modules.add(moduleName);
                model.setModules(modules);
            }
            try (FileWriter writer = new FileWriter(pomUrl);){
                MavenXpp3Writer mavenXpp3Writer = new MavenXpp3Writer();
                mavenXpp3Writer.write((Writer)writer, model);
            }
        }
        catch (Exception e) {
            logger.info("\u5f80\u6839\u76ee\u5f55\u7684pom\u6587\u4ef6\u4e2d\u52a0\u5165{}\u51fa\u9519:{}}", (Object)moduleName, (Object)e.getMessage());
        }
    }

    private Map<String, String> getSysMetaInfo(Long appId) throws IOException {
        String codePath = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getAbsoluteOfflineWorkspaceRoot(), appId.toString(), this.formdesignProperties.getProjectRootPath(), this.formdesignProperties.getProjectCodePath()});
        File[] codeFiles = new File(codePath).listFiles();
        HashMap<String, String> sysMetaInfo = new HashMap<String, String>();
        if (ToolUtil.isNotEmpty((Object)codeFiles)) {
            for (File file : codeFiles) {
                if (!file.getName().endsWith(".meta") || file.getName().contains("appsStore")) continue;
                long fileLength = file.length();
                byte[] fileContent = new byte[(int)fileLength];
                try (FileInputStream in = null;){
                    in = new FileInputStream(file);
                    int n = in.read(fileContent);
                }
                JSONObject modelObject = JSON.parseObject((String)new String(fileContent, StandardCharsets.UTF_8));
                sysMetaInfo.put(file.getName(), modelObject.getString("id"));
            }
        }
        return sysMetaInfo;
    }

    private Map<String, Object> importData(File file, String serverCode, String dsName, boolean isSync) {
        File dataFile = new File(file.getAbsolutePath(), ExportResourceConstant.TABLEINFO + File.separator + ExportResourceConstant.TABLE_INFO_JSON);
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        HashMap<String, String> sqlMap = new HashMap<String, String>();
        ArrayList<JSONObject> addTableResultList = new ArrayList<JSONObject>();
        ArrayList<JSONObject> modifyTableResults = new ArrayList<JSONObject>();
        if (dataFile.exists()) {
            try {
                byte[] bytes = FileUtils.readFileToByteArray((File)dataFile);
                Map tableStructures = (Map)SerializeUtils.deserialize((byte[])bytes);
                if (tableStructures != null) {
                    for (String s : tableStructures.keySet()) {
                        logger.info("\u751f\u4ea7\u73af\u5883\u5bfc\u5165\uff1as={}", (Object)s);
                        List tableStructure = (List)JSON.parseObject((String)((String)tableStructures.get(s)), (TypeReference)new TypeReference<List<TableInfo>>(){}, (Feature[])new Feature[0]);
                        s = this.getAppDsName(serverCode);
                        try {
                            this.generateSql(tableStructure, s, serverCode, sqlMap, addTableResultList, modifyTableResults);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            logger.error(e.getMessage());
                        }
                    }
                }
            }
            catch (IOException e) {
                logger.error("\u751f\u4ea7\u73af\u5883\u5bfc\u5165\uff1a{}", (Object)e.getMessage());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        dataMap.put("sql", JSON.toJSONString(sqlMap));
        dataMap.put("createTables", addTableResultList);
        dataMap.put("alterTables", modifyTableResults);
        return dataMap;
    }

    private void generateSql(List<TableInfo> tableStructure, String dataSource, String serverCode, Map<String, String> sqlMap, List<JSONObject> addTableResultList, List<JSONObject> modifyTableResults) {
        StringBuilder sql = new StringBuilder();
        JSONObject addTables = new JSONObject();
        ArrayList<String> addTableName = new ArrayList<String>();
        addTables.put("dataSourceName", (Object)dataSource);
        addTables.put("tableNames", addTableName);
        JSONObject editTables = new JSONObject();
        HashMap<String, List<String>> tableMessage = new HashMap<String, List<String>>();
        editTables.put("dataSourceName", (Object)dataSource);
        editTables.put("tableMessage", tableMessage);
        for (TableInfo tableInfo : tableStructure) {
            try {
                Optional newTableInfo = DataModelUtil.filterTable((String)dataSource, (String)"BASE TABLE", (String)tableInfo.getName());
                if (!newTableInfo.isPresent()) {
                    String createTableSql = this.ddlService.getDdlSql(this.getCreateTableParam(tableInfo, dataSource, addTableName), new ArrayList(), null);
                    sql.append(createTableSql);
                    continue;
                }
                String updateTableSql = this.ddlService.getDdlSql(this.getUpdateTableParam(tableInfo, (TableInfo)newTableInfo.get(), dataSource, tableMessage), this.getColumnDto(((TableInfo)newTableInfo.get()).getFields()), tableInfo.getName());
                sql.append(updateTableSql);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("\u6267\u884c\u5bfc\u5165SQL\u51fa\u9519:{}", (Object)e.getMessage());
            }
        }
        addTableResultList.add(addTables);
        modifyTableResults.add(editTables);
        sqlMap.put(dataSource, sql.toString());
    }

    private MetadataParam getCreateTableParam(TableInfo tableInfo, String dataSource, List<String> addTableName) {
        addTableName.add(tableInfo.getName());
        MetadataParam param = new MetadataParam();
        List<ColumnInfoDto> columnDto = this.getColumnDto(tableInfo.getFields());
        param.setTableInfo(this.getTableInfoDto(tableInfo, dataSource, columnDto));
        param.setColumnInfo(columnDto);
        return param;
    }

    private List<ColumnInfoDto> getColumnDto(List<TableField> tableFields) {
        ArrayList<ColumnInfoDto> columnInfos = new ArrayList<ColumnInfoDto>();
        for (TableField tableField : tableFields) {
            ColumnInfoDto columnInfo = new ColumnInfoDto();
            columnInfo.setColumnName(tableField.getName());
            columnInfo.setColumnComment(tableField.getComment());
            columnInfo.setRequired("0");
            if ("PRI".equals(tableField.getPrimarys())) {
                columnInfo.setPk("1");
                columnInfo.setRequired("1");
                columnInfo.setPrimarys("1");
            } else {
                columnInfo.setPk("0");
            }
            if (tableField.getDataIsEmpty()) {
                columnInfo.setRequired("1");
            }
            columnInfo.setDataIsEmpty(Integer.valueOf(tableField.getDataIsEmpty() ? 1 : 0));
            columnInfo.setDataLength(Long.valueOf(tableField.getDataLength()));
            columnInfo.setDataDot(Integer.valueOf(tableField.getDataDot()));
            columnInfo.setDataType(tableField.getType().toUpperCase());
            columnInfos.add(columnInfo);
        }
        return columnInfos;
    }

    private TableInfoDto getTableInfoDto(TableInfo tableInfo, String dataSource, List<ColumnInfoDto> columnDto) {
        TableInfoDto tableDto = new TableInfoDto();
        tableDto.setTableName(tableInfo.getName());
        tableDto.setPollName(dataSource);
        tableDto.setTableAlias(tableInfo.getName());
        tableDto.setTableDec(tableInfo.getComment());
        tableDto.setColumnList(HussarUtils.copyProperties(columnDto, MetadataColumn.class));
        return tableDto;
    }

    private MetadataParam getUpdateTableParam(TableInfo tableInfo, TableInfo newTableInfo, String dataSource, Map<String, List<String>> tableMessage) {
        ArrayList<String> messageList = new ArrayList<String>();
        MetadataParam param = new MetadataParam();
        param.setDeletedCols(new ArrayList());
        param.setColumnInfo(new ArrayList());
        List<ColumnInfoDto> columnDto = this.getColumnDto(tableInfo.getFields());
        param.setTableInfo(this.getTableInfoDto(tableInfo, dataSource, columnDto));
        this.mcontrastWith(tableInfo, newTableInfo, messageList, param);
        if (!messageList.isEmpty()) {
            tableMessage.put(tableInfo.getName(), messageList);
        }
        return param;
    }

    private void mcontrastWith(TableInfo tableInfo, TableInfo newTableInfo, List<String> tableMessage, MetadataParam param) {
        ArrayList<ColumnInfoDto> columnInfoDtos = new ArrayList<ColumnInfoDto>();
        ArrayList<TableField> editField = new ArrayList<TableField>();
        ArrayList<TableField> delField = new ArrayList<TableField>();
        Map addFieldsMap = tableInfo.getFields().stream().collect(Collectors.toMap(TableField::getName, Function.identity(), (k1, k2) -> k1));
        block0: for (Object oldField : newTableInfo.getFields()) {
            boolean flag = false;
            for (TableField newField : tableInfo.getFields()) {
                if (!HussarUtils.equals((Object)oldField.getName(), (Object)newField.getName())) continue;
                flag = true;
                addFieldsMap.remove(oldField.getName());
                if (HussarUtils.equals((Object)oldField.getType().toLowerCase(), (Object)newField.getType().toLowerCase()) && oldField.getDataIsEmpty() == newField.getDataIsEmpty() && oldField.getDataLength() == newField.getDataLength() && oldField.getDataDot() == newField.getDataDot() && HussarUtils.equals((Object)oldField.getComment(), (Object)newField.getComment()) && HussarUtils.equals((Object)"PRI", (Object)oldField.getPrimarys()) == HussarUtils.equals((Object)"PRI", (Object)newField.getPrimarys())) continue block0;
                tableMessage.add(String.format("%s\u5217\uff1a%s(%s)", "\u4fee\u6539", oldField.getName(), oldField.getComment()));
                editField.add(newField);
            }
        }
        if (HussarUtils.isNotEmpty(editField)) {
            List<ColumnInfoDto> editFieldColumnDto = this.getColumnDto(editField);
            for (ColumnInfoDto columnInfoDto : editFieldColumnDto) {
                columnInfoDto.setOperation("edit");
            }
            columnInfoDtos.addAll(editFieldColumnDto);
        }
        if (HussarUtils.isNotEmpty(addFieldsMap.values())) {
            ArrayList<TableField> addField = new ArrayList<TableField>(addFieldsMap.values());
            List<ColumnInfoDto> addFieldColumnDto = this.getColumnDto(addField);
            for (ColumnInfoDto columnInfoDto : addFieldColumnDto) {
                tableMessage.add(String.format("%s\u5217\uff1a%s(%s)", "\u65b0\u589e", columnInfoDto.getColumnName(), columnInfoDto.getColumnComment()));
                columnInfoDto.setOperation("add");
            }
            columnInfoDtos.addAll(addFieldColumnDto);
        }
        if (HussarUtils.isNotEmpty(delField)) {
            param.setDeletedCols(this.getColumnDto(delField));
        }
        param.setColumnInfo(columnInfoDtos);
    }

    private Map<String, Object> initAppToOffline(Long appId, File temp, Map<String, Object> metaMap, Map<String, Object> returnMap) throws Exception {
        File tar;
        String md5;
        String appName = metaMap.get("appName") == null ? expansion : metaMap.get("appName").toString();
        String tenantId = metaMap.get("tenantId") == null ? expansion : metaMap.get("tenantId").toString();
        String javaPath = metaMap.get("javaPath") == null ? expansion : metaMap.get("javaPath").toString();
        String sign = metaMap.get("sign") == null ? expansion : metaMap.get("sign").toString();
        String serviceNameZip = metaMap.get("serviceName") == null ? expansion : metaMap.get("serviceName").toString();
        String dsName = metaMap.get("ds") == null ? expansion : metaMap.get("ds").toString();
        Map metaInfo = metaMap.get("metaInfo") == null ? null : (Map)metaMap.get("metaInfo");
        MixAppInfoVo appInfo = this.hussarBaseAppMixBoService.getMixAppInfo(appId);
        if (ToolUtil.isNotEmpty((Object)metaInfo)) {
            Map<String, String> sysMetaInfo = this.getSysMetaInfo(appId);
            for (String name : metaInfo.keySet()) {
                if (!ToolUtil.isNotEmpty((Object)sysMetaInfo.get(name)) || ((String)metaInfo.get(name)).equals(sysMetaInfo.get(name))) continue;
                returnMap.put("status", false);
                returnMap.put("msg", "\u5b58\u5728\u540c\u540d\u4f46\u4e0d\u540c\u6765\u6e90\u7684\u6a21\u5757\u3001\u9875\u9762\u6216\u5de5\u4f5c\u6d41\uff0c\u4e0d\u53ef\u5bfc\u5165");
                return returnMap;
            }
        }
        if (!(md5 = ZipUtil.getMd5((tar = new File(temp + File.separator + appName + ".tar")).getAbsolutePath())).equals(sign)) {
            returnMap.put("status", false);
            returnMap.put("msg", "\u521d\u59cb\u5316\u5305\u5df2\u88ab\u4fee\u6539\uff01");
            return returnMap;
        }
        TarUtil.unTar(tar, temp.getAbsolutePath() + File.separator);
        File axe = new File(temp.getAbsolutePath() + File.separator + ExportResourceConstant.PROJECT_STORE);
        ExportApplicationSource exportApplicationSource = this.getExportApplicationSource(appName, tenantId, javaPath, dsName);
        String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
        ImportApplicationSource importApplicationSource = this.getImportApplicationSource(appInfo.getAppEnglishName(), tenantCode);
        HashMap<String, Object> storeReserveMap = new HashMap<String, Object>();
        storeReserveMap.put("appId", appId);
        ProjectStoreArgs projectStoreArgs = this.getProjectStoreArgs(exportApplicationSource, importApplicationSource, axe, storeReserveMap);
        projectStoreArgs.getReserveMap().put("serviceNameZip", serviceNameZip);
        this.inductsProjectStoreService.handlerProjectStore(JSONObject.parseObject((String)JSONObject.toJSONString((Object)projectStoreArgs)));
        this.inductsProjectStoreService.importProjectStore(appId.toString(), axe.getAbsolutePath());
        File defaultCss = new File(FileUtil.posixPath((String[])new String[]{temp.getAbsolutePath(), this.defaultDir}));
        this.storageDumpLoadService.load(this.defaultDir, defaultCss);
        ApplicationMixProjectCodeArgs applicationMixProjectCodeArgs = this.getProjectCodeArgs(exportApplicationSource, importApplicationSource, temp, null);
        this.handlerProjectCode(applicationMixProjectCodeArgs, appInfo.getServiceName(), serviceNameZip);
        WorkflowLoadAppDto workflowLoadAppDto = new WorkflowLoadAppDto();
        workflowLoadAppDto.setAppType(appInfo.getAppType());
        workflowLoadAppDto.setAppCode(appInfo.getAppEnglishName());
        workflowLoadAppDto.setAppId(appId.toString());
        workflowLoadAppDto.setImportType("2");
        workflowLoadAppDto.setServiceName(appInfo.getServiceName());
        workflowLoadAppDto.setFilePath(temp.getAbsolutePath() + File.separator + ExportResourceConstant.WORKFLOW);
        if (new File(workflowLoadAppDto.getFilePath()).exists()) {
            try {
                WorkflowAppMigrationService.loadApp((WorkflowLoadAppDto)workflowLoadAppDto);
            }
            catch (Exception e) {
                logger.error("\u6269\u5c55\u5f00\u53d1\u5305\u5bfc\u5165\uff0c\u5bfc\u5165\u6d41\u7a0b\u62a5\u9519\uff1a{}", (Object)e.getMessage());
            }
        }
        returnMap = this.importData(temp, tenantCode, dsName, false);
        returnMap.put("status", true);
        this.publishService.resourceBatch(appId.toString());
        SysLowCodeAppExtend appExtend = new SysLowCodeAppExtend();
        appExtend.setAppId(appId);
        appExtend.setAppEnglishName(appInfo.getAppEnglishName());
        appExtend.setIsInit("1");
        this.hussarBaseAppMixBoService.updateLowCodeAppExtendByAppId(appExtend);
        logger.info("\u5e94\u7528\uff1a{}\u521d\u59cb\u5316\u6210\u529f", (Object)appInfo.getAppEnglishName());
        return returnMap;
    }

    private Map<String, Object> initExpansionAppToOffline(Long appId, File temp, Map<String, Object> metaMap, Map<String, Object> returnMap) throws Exception {
        String appName = metaMap.get("appName") == null ? expansion : metaMap.get("appName").toString();
        String tenantId = metaMap.get("tenantId") == null ? expansion : metaMap.get("tenantId").toString();
        String javaPath = metaMap.get("javaPath") == null ? expansion : metaMap.get("javaPath").toString();
        String sign = metaMap.get("sign") == null ? expansion : metaMap.get("sign").toString();
        String serviceNameZip = metaMap.get("serviceName") == null ? expansion : metaMap.get("serviceName").toString();
        String dsName = metaMap.get("ds") == null ? expansion : metaMap.get("ds").toString();
        File tar = new File(temp + File.separator + appName + ".tar");
        String md5 = ZipUtil.getMd5(tar.getAbsolutePath());
        if (!md5.equals(sign)) {
            returnMap.put("status", false);
            returnMap.put("msg", "\u521d\u59cb\u5316\u5305\u5df2\u88ab\u4fee\u6539\uff01");
            return returnMap;
        }
        MixAppInfoVo appInfo = this.hussarBaseAppMixBoService.getMixAppInfo(appId);
        String serviceName = appInfo.getServiceName();
        String appNameNow = appInfo.getAppEnglishName();
        this.addExpansionPluginsModule(appNameNow, serviceName, false);
        TarUtil.unTar(tar, temp.getAbsolutePath() + File.separator);
        File axe = new File(temp.getAbsolutePath() + File.separator + ExportResourceConstant.PROJECT_STORE);
        ExportApplicationSource exportApplicationSource = this.getExportApplicationSource(appName, tenantId, javaPath, dsName);
        String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
        ImportApplicationSource importApplicationSource = this.getImportApplicationSource(appInfo.getAppEnglishName(), tenantCode);
        HashMap<String, Object> storeReserveMap = new HashMap<String, Object>();
        storeReserveMap.put("appId", appId);
        ProjectStoreArgs projectStoreArgs = this.getProjectStoreArgs(exportApplicationSource, importApplicationSource, axe, storeReserveMap);
        projectStoreArgs.getReserveMap().put("serviceNameZip", serviceNameZip);
        this.inductsProjectStoreService.handlerProjectStore(JSONObject.parseObject((String)JSONObject.toJSONString((Object)projectStoreArgs)));
        this.inductsProjectStoreService.importProjectStore(appId.toString(), axe.getAbsolutePath());
        File expansionJava = new File(temp.getAbsolutePath() + File.separator + ExportResourceConstant.JAVA);
        File expansionResource = new File(temp.getAbsolutePath() + File.separator + "resources");
        File expansionVue = new File(temp.getAbsolutePath() + File.separator + ExportResourceConstant.VUE);
        String expansionModulePath = this.getExpansionModulePath(appNameNow, serviceName);
        String expansionPath = MODULES + AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)serviceName) + "_" + AppContextUtil.asIdentifier((String)appNameNow) + File.separator + "src";
        String expansionVuePath = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getFrontProjectPath(), expansionPath}) + expansion;
        String relativeRPath = "src.main.resources";
        String expansionResourcePath = expansionModulePath + File.separator + relativeRPath.replace(".", File.separator);
        String expansionJavaPath = FileUtil.posixPath((String[])new String[]{expansionModulePath, VuePathServiceImpl.formDesignProperties.getJavaCodePath(), VuePathServiceImpl.formDesignProperties.getJavaPath(), AppImportServiceImpl.getAppBackCodePrefixByAppId(appInfo)});
        WorkflowLoadAppDto workflowLoadAppDto = new WorkflowLoadAppDto();
        workflowLoadAppDto.setAppType(appInfo.getAppType());
        workflowLoadAppDto.setAppCode(appInfo.getAppEnglishName());
        workflowLoadAppDto.setAppId(appId.toString());
        workflowLoadAppDto.setImportType("2");
        workflowLoadAppDto.setServiceName(appInfo.getServiceName());
        workflowLoadAppDto.setFilePath(temp.getAbsolutePath() + File.separator + ExportResourceConstant.WORKFLOW);
        if (new File(workflowLoadAppDto.getFilePath()).exists()) {
            try {
                WorkflowAppMigrationService.loadApp((WorkflowLoadAppDto)workflowLoadAppDto);
            }
            catch (Exception e) {
                logger.error("\u6269\u5c55\u5f00\u53d1\u5305\u5bfc\u5165\uff0c\u5bfc\u5165\u6d41\u7a0b\u62a5\u9519\uff1a{}", (Object)e.getMessage());
            }
        }
        if (expansionJava.exists()) {
            AppImportServiceImpl.copyToDirectoryNotExpansion(expansionJava, new File(expansionJavaPath));
        }
        if (expansionResource.exists()) {
            AppImportServiceImpl.copyToDirectory(expansionResource, new File(expansionResourcePath));
        }
        if (expansionVue.exists()) {
            AppImportServiceImpl.copyToDirectory(expansionVue, new File(expansionVuePath));
        }
        logger.info("\u6269\u5c55\u5e94\u7528\uff1a{}\u5bfc\u5165\u6210\u529f", (Object)appName);
        returnMap.put("status", true);
        return returnMap;
    }

    public static String getAppBackCodePrefixByAppId(MixAppInfoVo appInfo) {
        String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
        return appInfo == null ? null : FileUtil.posixPath((String[])new String[]{AppContextUtil.asIdentifier((String)tenantCode), AppContextUtil.asIdentifier((String)appInfo.getServiceName()), AppContextUtil.asIdentifier((String)appInfo.getAppEnglishName())}).toLowerCase();
    }

    private String getExpansionModulePath(String applicationName, String serviceName) {
        String expansionModulePath = null;
        if (this.pluginPrefix != null && this.modulePath != null) {
            String absolutePath = this.modulePath;
            int end = absolutePath.lastIndexOf(File.separator);
            if (end != absolutePath.length() - 1) {
                absolutePath = absolutePath + File.separator;
            }
            String prefixPath = absolutePath + (ToolUtil.isNotEmpty((Object)this.prefixName) ? this.prefixName : "hussar-plugin");
            File module = new File(prefixPath);
            SecurityUser securityUser = BaseSecurityUtil.getUser();
            if (ToolUtil.isEmpty((Object)securityUser)) {
                throw new BaseException("\u4e8c\u6b21\u8ba4\u8bc1\u5f02\u5e38\uff0c\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
            }
            if (module.exists()) {
                String userCode = securityUser.getTenantCode();
                String tenantCode = AppContextUtil.asIdentifier((String)userCode);
                String serviceNameCode = AppContextUtil.asIdentifier((String)serviceName);
                String tenantPath = prefixPath + File.separator + this.pluginPrefix + tenantCode;
                String tenAndService = AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)serviceNameCode);
                String tenAndServicePath = tenantPath + File.separator + this.pluginPrefix + tenAndService;
                String tenAndApp = AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)serviceNameCode) + "-" + AppContextUtil.asIdentifier((String)applicationName);
                expansionModulePath = tenAndServicePath + File.separator + this.pluginPrefix + tenAndApp + expansion;
            }
        }
        return expansionModulePath;
    }

    private static void copyToDirectory(File srcDir, File destDir) throws IOException {
        for (File file : Objects.requireNonNull(srcDir.listFiles())) {
            if (file.isDirectory()) {
                FileUtils.copyDirectoryToDirectory((File)file, (File)destDir);
                continue;
            }
            FileUtils.copyFileToDirectory((File)file, (File)destDir);
        }
    }

    private static void copyToDirectoryNotExpansion(File srcDir, File destDir) throws IOException {
        String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
        for (File file : Objects.requireNonNull(srcDir.listFiles())) {
            if (file.isDirectory()) {
                File newDestDir = new File(destDir, file.getName());
                if (!newDestDir.exists()) {
                    newDestDir.mkdirs();
                }
                AppImportServiceImpl.copyToDirectoryNotExpansion(file, newDestDir);
                continue;
            }
            com.jxdinfo.hussar.app.imports.util.FileUtil.modifyFilePaths(file, tenantCode.toLowerCase());
            FileUtils.copyFileToDirectory((File)file, (File)destDir);
        }
    }

    private ExportApplicationSource getExportApplicationSource(String appName, String tenantId, String javaPath, String dsName) {
        ExportApplicationSource exportApplicationSource = new ExportApplicationSource();
        exportApplicationSource.setAppName(appName);
        exportApplicationSource.setTenantId(tenantId);
        exportApplicationSource.setJavaPath(javaPath);
        exportApplicationSource.setDsName(dsName);
        return exportApplicationSource;
    }

    private ImportApplicationSource getImportApplicationSource(String appName, String serverCode) {
        ImportApplicationSource importApplicationSource = new ImportApplicationSource();
        importApplicationSource.setAppName(appName);
        importApplicationSource.setTenantId(serverCode);
        importApplicationSource.setJavaPath(this.formdesignProperties.getJavaPath());
        String dsName = HussarUtils.isNotEmpty((Object)serverCode) ? this.getAppDsName(serverCode) : "master";
        importApplicationSource.setDsName(dsName);
        return importApplicationSource;
    }

    private ProjectStoreArgs getProjectStoreArgs(ExportApplicationSource exportApplicationSource, ImportApplicationSource importApplicationSource, File axe, Map<String, Object> reserveMap) {
        ProjectStoreArgs projectStoreArgs = new ProjectStoreArgs();
        projectStoreArgs.setAxeDir(axe);
        projectStoreArgs.setExportApplicationSource(exportApplicationSource);
        projectStoreArgs.setImportApplicationSource(importApplicationSource);
        projectStoreArgs.setReserveMap(reserveMap);
        return projectStoreArgs;
    }

    private ApplicationMixProjectCodeArgs getProjectCodeArgs(ExportApplicationSource exportApplicationSource, ImportApplicationSource importApplicationSource, File zipDir, Map<String, Object> reserveMap) {
        ApplicationMixProjectCodeArgs applicationMixProjectCodeArgs = new ApplicationMixProjectCodeArgs();
        applicationMixProjectCodeArgs.setZipDir(zipDir);
        applicationMixProjectCodeArgs.setExportApplicationSource(exportApplicationSource);
        applicationMixProjectCodeArgs.setImportApplicationSource(importApplicationSource);
        applicationMixProjectCodeArgs.setReserveMap(reserveMap);
        return applicationMixProjectCodeArgs;
    }

    public void handlerProjectCode(ApplicationMixProjectCodeArgs applicationMixProjectCodeArgs, String serviceName, String serviceNameZip) throws Exception {
        CountDownLatch fileCountDownLatch = new CountDownLatch(6);
        CountDownLatch dirUpdateCountDownLatch = new CountDownLatch(1);
        logger.debug("[{}]{}\uff1a\u5f00\u59cb\u8f6c\u6362", (Object)applicationMixProjectCodeArgs.getZipDir(), (Object)System.currentTimeMillis());
        File zipDir = applicationMixProjectCodeArgs.getZipDir();
        File java = new File(zipDir, ExportResourceConstant.JAVA);
        File vue = new File(zipDir, ExportResourceConstant.VUE);
        File mobileVue = new File(zipDir, AppExportConstants.MOBILE_VUE);
        File api = new File(zipDir, ExportResourceConstant.API);
        File mobileApi = new File(zipDir, AppExportConstants.MOBILE_API);
        File mobileRouter = new File(zipDir, AppExportConstants.MOBILE_ROUTER);
        new Thread(() -> {
            try {
                this.updateDir(zipDir, applicationMixProjectCodeArgs, serviceName, serviceNameZip);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                dirUpdateCountDownLatch.countDown();
            }
        }).start();
        dirUpdateCountDownLatch.await();
        this.updateFile(java, ExportResourceConstant.JAVA, applicationMixProjectCodeArgs, fileCountDownLatch, serviceName, serviceNameZip);
        this.updateFile(vue, ExportResourceConstant.VUE, applicationMixProjectCodeArgs, fileCountDownLatch, serviceName, serviceNameZip);
        this.updateFile(mobileVue, AppExportConstants.MOBILE_VUE, applicationMixProjectCodeArgs, fileCountDownLatch, serviceName, serviceNameZip);
        this.updateFile(api, ExportResourceConstant.API, applicationMixProjectCodeArgs, fileCountDownLatch, serviceName, serviceNameZip);
        this.updateFile(mobileApi, AppExportConstants.MOBILE_API, applicationMixProjectCodeArgs, fileCountDownLatch, serviceName, serviceNameZip);
        this.updateFile(mobileRouter, AppExportConstants.MOBILE_ROUTER, applicationMixProjectCodeArgs, fileCountDownLatch, serviceName, serviceNameZip);
        logger.debug("[" + new Date() + "]{" + applicationMixProjectCodeArgs.getZipDir() + "}\uff1a\u8f6c\u6362\u7ed3\u675f");
        fileCountDownLatch.await();
        logger.debug("[{}]------------\u51c6\u5907\u5199\u51fa\u6587\u4ef6---------------", (Object)System.currentTimeMillis());
        String javaPath = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getPluginProjectPath(), this.hussarAppExportProperties.getPluginPrefix() + AppContextUtil.asIdentifier((String)applicationMixProjectCodeArgs.getImportApplicationSource().getTenantId()), this.hussarAppExportProperties.getPluginPrefix() + AppContextUtil.asIdentifier((String)applicationMixProjectCodeArgs.getImportApplicationSource().getTenantId()) + "-" + AppContextUtil.asIdentifier((String)serviceName), this.hussarAppExportProperties.getPluginPrefix() + AppContextUtil.asIdentifier((String)applicationMixProjectCodeArgs.getImportApplicationSource().getTenantId()) + "-" + AppContextUtil.asIdentifier((String)serviceName) + "-" + applicationMixProjectCodeArgs.getImportApplicationSource().getAppName()});
        String mobileApiPath = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getMobileFrontProjectPath(), this.hussarAppExportProperties.getMobileFrontApiPath()});
        String mobileRouterPath = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getMobileFrontProjectPath(), this.hussarAppExportProperties.getMobileFrontRouterPath()});
        String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
        String vuePath = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getFrontProjectPath(), MODULES + AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)serviceName) + "_" + AppContextUtil.asIdentifier((String)applicationMixProjectCodeArgs.getImportApplicationSource().getAppName()), "src"});
        String mobileVuePath = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getMobileFrontProjectPath(), this.hussarAppExportProperties.getMobileVueCodePath()});
        if (java.exists()) {
            File[] files;
            ExportApplicationSource exportApplicationSource = applicationMixProjectCodeArgs.getExportApplicationSource();
            ImportApplicationSource importApplicationSource = applicationMixProjectCodeArgs.getImportApplicationSource();
            String javaSrcPath = importApplicationSource.getJavaPath().replace(".", File.separator);
            String tenantId = importApplicationSource.getTenantId();
            String appName = importApplicationSource.getAppName();
            String exportTenantCodeLow = AppContextUtil.asIdentifier((String)exportApplicationSource.getTenantId()).toLowerCase();
            String exportServiceNameLow = AppContextUtil.asIdentifier((String)serviceNameZip).toLowerCase();
            String exportAppNameLow = AppContextUtil.asIdentifier((String)exportApplicationSource.getAppName()).toLowerCase();
            for (File file : files = java.listFiles()) {
                File outermostDirectory = this.getOutermostDirectory(file, exportTenantCodeLow, exportServiceNameLow, exportAppNameLow);
                if (HussarUtils.isEmpty((Object)outermostDirectory)) {
                    throw new BaseException("\u5bfc\u5165\u5931\u8d25\uff01");
                }
                String[] split = file.getName().split("-");
                split[1] = AppContextUtil.asIdentifier((String)tenantId);
                split[2] = AppContextUtil.asIdentifier((String)serviceName);
                split[3] = AppContextUtil.asIdentifier((String)appName);
                StringBuffer sb = new StringBuffer();
                for (int x = 0; x < split.length; ++x) {
                    if (x == split.length - 1) {
                        sb.append(split[x]);
                        continue;
                    }
                    sb.append(split[x]).append("-");
                }
                String appPathInPlugin = FileUtil.posixPath((String[])new String[]{javaPath, sb.toString(), "src", "main", "java", javaSrcPath, AppContextUtil.asIdentifier((String)tenantId).toLowerCase(), AppContextUtil.asIdentifier((String)serviceName).toLowerCase(), AppContextUtil.asIdentifier((String)appName).toLowerCase()});
                FileUtils.copyDirectory((File)outermostDirectory, (File)new File(appPathInPlugin));
            }
        }
        if (vue.exists()) {
            FileUtils.copyDirectory((File)vue, (File)new File(vuePath));
            this.inductsProjectStoreService.webPrefixCommon();
        }
        if (mobileVue.exists()) {
            FileUtils.copyDirectory((File)mobileVue, (File)new File(mobileVuePath));
        }
        if (mobileApi.exists()) {
            FileUtils.copyDirectory((File)mobileApi, (File)new File(mobileApiPath));
            this.inductsProjectStoreService.h5PrefixCommon();
        }
        if (mobileRouter.exists()) {
            FileUtils.copyDirectory((File)mobileRouter, (File)new File(mobileRouterPath));
        }
        logger.debug("[{}]----------\u5199\u51fa\u6587\u4ef6\u7ed3\u675f--------------", (Object)System.currentTimeMillis());
    }

    private File getOutermostDirectory(File dir, String tenantCode, String serviceName, String appName) {
        List<File> fileList = this.findOutermostDirectory(dir, appName);
        if (HussarUtils.isEmpty(fileList)) {
            return null;
        }
        for (File file : fileList) {
            File fileParentFile;
            File parentFile = file.getParentFile();
            if (!HussarUtils.isNotEmpty((Object)parentFile) || !serviceName.equals(parentFile.getName()) || !HussarUtils.isNotEmpty((Object)(fileParentFile = parentFile.getParentFile())) || !tenantCode.equals(fileParentFile.getName())) continue;
            return file;
        }
        return null;
    }

    private List<File> findOutermostDirectory(File dir, String targetName) {
        LinkedList<File> queue = new LinkedList<File>();
        queue.offer(dir);
        ArrayList<File> outermostDirectoryList = new ArrayList<File>();
        while (!queue.isEmpty()) {
            File currentDir = (File)queue.poll();
            File[] files = currentDir.listFiles();
            if (files == null) continue;
            for (File file : files) {
                if (!file.isDirectory()) continue;
                if (file.getName().equals(targetName)) {
                    outermostDirectoryList.add(file);
                }
                queue.offer(file);
            }
        }
        return outermostDirectoryList;
    }

    private void updateDir(File file, ApplicationMixProjectCodeArgs applicationMixProjectCodeArgs, String serviceName, String serviceNameZip) {
        File[] fs;
        ImportApplicationSource importApplicationSource = applicationMixProjectCodeArgs.getImportApplicationSource();
        ExportApplicationSource exportApplicationSource = applicationMixProjectCodeArgs.getExportApplicationSource();
        for (File f : fs = file.listFiles()) {
            File[] tenantFiles;
            if (!f.isDirectory()) continue;
            boolean isJava = "java".equals(f.getName());
            for (File tenantFile : tenantFiles = f.listFiles()) {
                if (!tenantFile.getName().equalsIgnoreCase(this.tenantCodeDirname(exportApplicationSource.getTenantId()))) continue;
                try {
                    File[] serviceFiles;
                    File tenantNewFile = this.rename(f, tenantFile.getName(), this.tenantCodeDirname(importApplicationSource.getTenantId()), isJava);
                    for (File serviceFile : serviceFiles = tenantNewFile.listFiles()) {
                        File[] appFiles;
                        if (!serviceFile.getName().equalsIgnoreCase(AppContextUtil.asIdentifier((String)serviceNameZip))) continue;
                        File serviceNewFile = this.rename(tenantNewFile, serviceFile.getName(), AppContextUtil.asIdentifier((String)serviceName), isJava);
                        for (File appFile : appFiles = serviceNewFile.listFiles()) {
                            if (!appFile.getName().equalsIgnoreCase(this.appNameDirname(exportApplicationSource.getAppName()))) continue;
                            this.rename(serviceNewFile, appFile.getName(), this.appNameDirname(importApplicationSource.getAppName()), isJava);
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String tenantCodeDirname(String tenantCode) {
        return AppContextUtil.asIdentifier((String)tenantCode);
    }

    private File rename(File parent, String oldName, String newName, boolean isJava) throws IOException {
        if (isJava) {
            newName = newName.toLowerCase();
        }
        File oldFile = new File(parent, oldName);
        if (newName.equals(oldName)) {
            return oldFile;
        }
        File newFile = new File(parent, newName);
        if (!oldFile.exists()) {
            throw new FileNotFoundException(oldFile.getPath());
        }
        if (newFile.exists()) {
            throw new FileAlreadyExistsException(newFile.getPath());
        }
        if (!oldFile.renameTo(newFile)) {
            throw new IOException("failed to rename " + oldName + " to " + newName);
        }
        return newFile;
    }

    private String appNameDirname(String appName) {
        return AppContextUtil.asIdentifier((String)appName);
    }

    private void updateFile(File dirPath, String type, ApplicationMixProjectCodeArgs applicationMixProjectCodeArgs, CountDownLatch countDownLatch, String serviceName, String oldServiceName) {
        new Thread(() -> {
            try {
                ArrayList<File> files = new ArrayList<File>();
                this.getFile(dirPath, files);
                ImportApplicationSource importApplicationSource = applicationMixProjectCodeArgs.getImportApplicationSource();
                ExportApplicationSource exportApplicationSource = applicationMixProjectCodeArgs.getExportApplicationSource();
                CodeRelocationUtil.Placement target = this.getPlacement(importApplicationSource.getAppName(), importApplicationSource.getDsName(), importApplicationSource.getJavaPath(), importApplicationSource.getTenantId(), serviceName);
                CodeRelocationUtil.Placement source = this.getPlacement(exportApplicationSource.getAppName(), exportApplicationSource.getDsName(), exportApplicationSource.getJavaPath(), exportApplicationSource.getTenantId(), oldServiceName);
                for (File file : files) {
                    String content;
                    if (!file.exists()) continue;
                    CodeRelocationUtil.Result relocate = null;
                    try {
                        content = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
                        if (ExportResourceConstant.JAVA.equals(type)) {
                            relocate = file.getName().endsWith(".xml") ? CodeRelocationUtil.relocate((CodeRelocationUtil.SourceType)CodeRelocationUtil.SourceType.MAPPER, (String)content, (CodeRelocationUtil.Placement)source, (CodeRelocationUtil.Placement)target, null) : CodeRelocationUtil.relocate((CodeRelocationUtil.SourceType)CodeRelocationUtil.SourceType.JAVA, (String)content, (CodeRelocationUtil.Placement)source, (CodeRelocationUtil.Placement)target, null);
                        } else {
                            CodeRelocationUtil.SourceType utilType = ExportResourceConstant.VUE.equals(type) ? CodeRelocationUtil.SourceType.VUE : CodeRelocationUtil.SourceType.JS;
                            relocate = CodeRelocationUtil.relocate((CodeRelocationUtil.SourceType)utilType, (String)content, (CodeRelocationUtil.Placement)source, (CodeRelocationUtil.Placement)target, null);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if (relocate == null) continue;
                    content = relocate.getContent();
                    try {
                        FileUtils.writeStringToFile((File)file, (String)content, (String)"UTF-8", (boolean)false);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                countDownLatch.countDown();
            }
        }).start();
    }

    private void getFile(File file, List<File> files) {
        if (file.isDirectory()) {
            File[] fs = file.listFiles();
            if (com.jxdinfo.hussar.formdesign.common.util.ToolUtil.isNotEmpty((Object)fs)) {
                for (File f : fs) {
                    this.getFile(f, files);
                }
            }
        } else if (!file.getName().endsWith(".class")) {
            files.add(file);
        }
    }

    private CodeRelocationUtil.Placement getPlacement(String appName, String dsName, String backPackagePrefix, String tenantCode, String serviceName) {
        CodeRelocationUtil.Placement placement = new CodeRelocationUtil.Placement();
        placement.setAppName(appName);
        placement.setDsName(dsName);
        placement.setBackPackagePrefix(backPackagePrefix);
        if (HussarUtils.isEmpty((Object)tenantCode)) {
            tenantCode = "0";
        }
        placement.setTenantCode(tenantCode);
        placement.setServiceName(serviceName);
        return placement;
    }

    private void deleteTempFileWithoutWorkFlow(File temp) throws IOException {
        File[] childFiles;
        if (ToolUtil.isNotEmpty((Object)temp) && temp.exists() && ToolUtil.isNotEmpty((Object)(childFiles = temp.listFiles()))) {
            File workflow = new File(temp.getAbsolutePath() + File.separator + ExportResourceConstant.WORKFLOW);
            for (File file : childFiles) {
                if (workflow.getAbsolutePath().equals(file.getAbsolutePath())) continue;
                FileUtils.forceDelete((File)file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importAndCompileApp(String tempPath, String serverCode, Long appId, String sql, List<String> coverList, Long compileId, String serverName) throws IOException {
        MixAppInfoVo appInfo = this.hussarBaseAppMixBoService.getMixAppInfo(appId);
        String serviceName = appInfo.getServiceName();
        String appEnglishName = appInfo.getAppEnglishName();
        long time0 = System.currentTimeMillis();
        File temp = new File(tempPath);
        try {
            long time1 = System.currentTimeMillis();
            this.backUpAppFiles(appId, serverCode, appEnglishName, serviceName);
            long time2 = System.currentTimeMillis();
            logger.info("{}-BackUp files:{}{}", new Object[]{PRINT_PREFIX + appEnglishName, (time2 - time1) / 1000L + "s", PRINT_PREFIX});
            File axe = new File(temp.getAbsolutePath() + File.separator + ExportResourceConstant.PROJECT_STORE);
            long time3 = System.currentTimeMillis();
            if ("21".equals(appInfo.getAppType())) {
                File metaFile = new File(temp + File.separator + ExportResourceConstant.META_JSON);
                byte[] meta = FileUtils.readFileToByteArray((File)metaFile);
                Map metaMap = (Map)SerializeUtils.deserialize((byte[])meta);
                String javaPath = metaMap.get("javaPath") == null ? expansion : metaMap.get("javaPath").toString();
                String serviceNameZip = metaMap.get("serviceName") == null ? expansion : metaMap.get("serviceName").toString();
                String dsName = metaMap.get("ds") == null ? expansion : metaMap.get("ds").toString();
                String originTenantCode = metaMap.get("tenantId") == null ? expansion : metaMap.get("tenantId").toString();
                ExportApplicationSource exportApplicationSource = this.getExportApplicationSource(appEnglishName, originTenantCode, javaPath, dsName);
                ImportApplicationSource importApplicationSource = this.getImportApplicationSource(appEnglishName, serverCode);
                HashMap<String, Object> storeReserveMap = new HashMap<String, Object>();
                storeReserveMap.put("appId", appId);
                ProjectStoreArgs projectStoreArgs = this.getProjectStoreArgs(exportApplicationSource, importApplicationSource, axe, storeReserveMap);
                projectStoreArgs.getReserveMap().put("serviceNameZip", serviceNameZip);
                this.inductsProjectStoreService.handlerProjectStore(JSONObject.parseObject((String)JSONObject.toJSONString((Object)projectStoreArgs)));
            }
            this.inductsProjectStoreService.importProjectStore(appId.toString(), axe.getAbsolutePath());
            File funResMenuFile = new File(temp.getAbsolutePath() + File.separator + AppExportConstants.FUN_RES_MENU + File.separator + AppExportConstants.FUN_RES_MENU_JSON);
            if (funResMenuFile.exists()) {
                this.importFunResMenu(appId, funResMenuFile);
            }
            if ("21".equals(appInfo.getAppType())) {
                try {
                    this.publishService.resourceBatch(appId.toString());
                }
                catch (Exception e) {
                    logger.error("\u6269\u5c55\u5f00\u53d1\u5305\u5bfc\u5165\uff0c\u53d1\u5e03\u8d44\u6e90\u62a5\u9519\uff1a{}", (Object)e.getMessage());
                }
            }
            long time4 = System.currentTimeMillis();
            logger.info("{}-Load axe files:{}{}", new Object[]{PRINT_PREFIX + appEnglishName, (time4 - time3) / 1000L + "s", PRINT_PREFIX});
            WorkflowLoadAppDto workflowLoadAppDto = new WorkflowLoadAppDto();
            workflowLoadAppDto.setAppType(appInfo.getAppType());
            workflowLoadAppDto.setAppCode(appEnglishName);
            workflowLoadAppDto.setAppId(appId.toString());
            workflowLoadAppDto.setImportType("1");
            workflowLoadAppDto.setServiceName(appInfo.getServiceName());
            workflowLoadAppDto.setFilePath(temp.getAbsolutePath() + File.separator + ExportResourceConstant.WORKFLOW);
            try {
                WorkflowAppMigrationService.loadApp((WorkflowLoadAppDto)workflowLoadAppDto);
            }
            catch (Exception e) {
                logger.error("\u6269\u5c55\u5f00\u53d1\u5305\u5bfc\u5165\uff0c\u5bfc\u5165\u6d41\u7a0b\u62a5\u9519\uff1a{}", (Object)e.getMessage());
            }
            long time7 = System.currentTimeMillis();
            File jar = this.importCode(temp, appInfo, serviceName, serverCode);
            long time8 = System.currentTimeMillis();
            logger.info("{}-Import code:{}{}", new Object[]{PRINT_PREFIX + appEnglishName, (time8 - time7) / 1000L + "s", PRINT_PREFIX});
            long time9 = System.currentTimeMillis();
            if (ToolUtil.isNotEmpty((Object)sql)) {
                this.inductsTableService.executeSql(sql);
            }
            long time10 = System.currentTimeMillis();
            logger.info("{}-Execute sql:{}{}", new Object[]{PRINT_PREFIX + appEnglishName, (time10 - time9) / 1000L + "s", PRINT_PREFIX});
            this.hussarBaseImportAppMixmsgBoService.setImportStatusTwo(compileId);
            long time13 = System.currentTimeMillis();
            if (!this.compileFront(appEnglishName, serverCode, compileId, serviceName, tempPath).booleanValue()) {
                throw new BaseException("\u524d\u7aef\u6587\u4ef6\u521b\u5efa\u5931\u8d25!");
            }
            long time14 = System.currentTimeMillis();
            logger.info("{}-Compile front code:{}{}", new Object[]{PRINT_PREFIX + appEnglishName, (time14 - time13) / 1000L, "s=============================="});
            long time15 = System.currentTimeMillis();
            long time16 = System.currentTimeMillis();
            logger.info("{}-Maven package:{}{}", new Object[]{PRINT_PREFIX + appEnglishName, (time16 - time15) / 1000L, "s=============================="});
            this.hussarBaseImportAppMixmsgBoService.setImportStatusThree(compileId);
            Map<String, Object> threadMap = context.get();
            if (jar != null && jar.exists()) {
                logger.info("\u9879\u76ee\u90e8\u7f72\u65b9\u5f0f{}", (Object)this.clusterType);
                String pluginId = threadMap.get("pluginId") + "-" + threadMap.get("version");
                if ("22".equals(appInfo.getAppType())) {
                    pluginId = (String)threadMap.get("pluginId");
                }
                if ("0".equals(this.clusterType)) {
                    long time17 = System.currentTimeMillis();
                    this.loadPluginJar(pluginId, jar);
                    long time18 = System.currentTimeMillis();
                    logger.info(PRINT_PREFIX + appEnglishName + "-Load plugin jar:" + (time18 - time17) / 1000L + "s" + PRINT_PREFIX);
                } else {
                    long time19 = System.currentTimeMillis();
                    long time20 = System.currentTimeMillis();
                    logger.info(PRINT_PREFIX + appEnglishName + "-Upload local jar:" + (time20 - time19) / 1000L + "s" + PRINT_PREFIX);
                    long time23 = System.currentTimeMillis();
                    this.clusterLoadPluginJar(jar, serverCode, serviceName, appEnglishName, pluginId, compileId);
                    long time24 = System.currentTimeMillis();
                    logger.info(PRINT_PREFIX + appEnglishName + "-Cluster load files:" + (time24 - time23) / 1000L + "s" + PRINT_PREFIX);
                }
                this.hussarBaseImportAppMixmsgBoService.setImportStatusFour(compileId);
            }
            this.updateCompileStatus(compileId, "1", null);
            SysEyImportAppMsg dbd = this.hussarBaseImportAppMixmsgBoService.getById(compileId);
            if ("\u540c\u6b65".equals(dbd.getAppFrom())) {
                if (ToolUtil.isNotEmpty((Object)temp) && temp.exists()) {
                    FileUtils.forceDelete((File)temp);
                }
            } else {
                this.deleteTempFileWithoutZipAndAddHistory(temp, appId);
            }
            context.remove();
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                if (!(e instanceof BaseException)) {
                    this.updateCompileStatus(compileId, "2", this.getErrorInfoFromException(e));
                }
                this.rollbackPluginFile(appId, serverCode, appEnglishName, serviceName);
                this.rollbackOrDeleteAppFile(appId, serverCode, appEnglishName, serviceName, true);
                this.hussarBaseImportAppMixmsgBoService.setFailReason(compileId, e.getMessage());
                if (ToolUtil.isNotEmpty((Object)temp) && temp.exists()) {
                    FileUtils.forceDelete((File)temp);
                }
                context.remove();
            }
            catch (Throwable throwable) {
                context.remove();
                long time25 = System.currentTimeMillis();
                logger.info("{}-Total:{}{}", new Object[]{PRINT_PREFIX + appEnglishName, (time25 - time0) / 1000L + "s", PRINT_PREFIX});
                throw throwable;
            }
            long time25 = System.currentTimeMillis();
            logger.info("{}-Total:{}{}", new Object[]{PRINT_PREFIX + appEnglishName, (time25 - time0) / 1000L + "s", PRINT_PREFIX});
        }
        long time25 = System.currentTimeMillis();
        logger.info("{}-Total:{}{}", new Object[]{PRINT_PREFIX + appEnglishName, (time25 - time0) / 1000L + "s", PRINT_PREFIX});
    }

    public void uploadLocalJarFile(File localJar) {
        try {
            logger.info("\u672c\u5730jar\u8def\u5f84\uff1a{},\u6587\u4ef6\u5927\u5c0f\uff1a{}", (Object)localJar.getAbsolutePath(), (Object)localJar.length());
            File shareJarFile = new File(this.hussarClusterProperties.getSharePlugin(), File.separator + localJar.getName());
            FileUtils.copyFile((File)localJar, (File)shareJarFile);
            logger.info("\u4e0a\u4f20\u6210\u529f\uff0c\u4e0a\u4f20jar\u8def\u5f84{}\uff1a,\u6587\u4ef6\u5927\u5c0f\uff1a{}", (Object)shareJarFile.getAbsolutePath(), (Object)shareJarFile.length());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadPluginJar(String pluginId, File jar) throws Exception {
        boolean isRevert = false;
        Path backUpPath = null;
        try {
            PluginInfo pluginInfo = this.pluginOperator.getPluginInfo(pluginId);
            if (ToolUtil.isNotEmpty((Object)pluginInfo)) {
                isRevert = true;
                this.pluginOperator.uninstall(pluginId, false);
            }
            this.uploadPluginAndStart(jar);
        }
        catch (Exception e) {
            PluginInfo pluginInfo = this.pluginOperator.getPluginInfo(pluginId);
            if (ToolUtil.isEmpty((Object)pluginInfo) && isRevert && backUpPath != null) {
                this.revertPlugin(backUpPath);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void revertPlugin(Path backUpPath) throws Exception {
        File backUpJar = backUpPath.toFile();
        if (backUpJar.exists()) {
            String[] names = backUpJar.getName().split("_");
            StringBuffer sb = new StringBuffer();
            for (int i = 2; i < names.length; ++i) {
                sb.append(names[i]);
            }
            File jar = new File(backUpJar.getParentFile(), sb.toString());
            try {
                FileUtils.copyFile((File)backUpJar, (File)jar);
                this.uploadPluginAndStart(jar);
            }
            finally {
                FileUtils.forceDelete((File)jar);
            }
        }
    }

    private synchronized void uploadPluginAndStart(File jar) throws Exception {
        Path jarPath = jar.toPath();
        String pluginId = null;
        try {
            PluginInfo pluginInfo = this.pluginOperator.load(jarPath);
            if (pluginInfo == null) {
                logger.error("Plugin '{}' install failure, this pluginInfo id is empty.", pluginId);
                throw new NullPointerException("Plugin " + pluginId + " install failure, this pluginInfo id is empty");
            }
            PluginDescriptor pluginDescriptor = pluginInfo.getPluginDescriptor();
            if (pluginDescriptor == null) {
                logger.error("Plugin install failure.");
                throw new NullPointerException("Plugin install failure");
            }
            pluginId = pluginDescriptor.getPluginId();
            GlobalRegistryInfo.addOperatorPluginInfo((String)pluginId, (PluginOperatorInfo.OperatorType)PluginOperatorInfo.OperatorType.INSTALL, (boolean)true);
            if (!this.pluginOperator.start(pluginId)) {
                this.pluginOperator.uninstall(pluginId, false);
                throw new Exception("Plugin" + pluginId + " start failure");
            }
            logger.info("Plugin '{}' install success", (Object)pluginId);
        }
        catch (Exception var2) {
            try {
                logger.error("Plugin '{}' install failure. {}", pluginId, (Object)var2);
                if (!ObjectUtils.isEmpty(pluginId)) {
                    try {
                        this.pluginOperator.uninstall(pluginId, false);
                    }
                    catch (Exception var3) {
                        logger.error("Plugin '{}' uninstall failure. {}", (Object)pluginId, (Object)var3.getMessage());
                    }
                }
                throw var2;
            }
            catch (Throwable throwable) {
                if (!ObjectUtils.isEmpty(pluginId)) {
                    GlobalRegistryInfo.setOperatorPluginInfo(pluginId, (boolean)false);
                }
                throw throwable;
            }
        }
        if (!ObjectUtils.isEmpty((Object)pluginId)) {
            GlobalRegistryInfo.setOperatorPluginInfo((String)pluginId, (boolean)false);
        }
    }

    private void clusterLoadPluginJar(File jar, String serverCode, String serviceName, String appEnglishName, String pluginId, Long compileId) throws Exception {
        String idToken = (String)HussarCacheUtil.get((String)"hussar-token", (Object)"hussar-token:var:id-token");
        List<String> arrayList = this.getIpAndPortByServiceName(serviceName);
        logger.info("{}\u5df2\u914d\u7f6e\u96c6\u7fa4\u8282\u70b9\uff1a{}", (Object)serviceName, (Object)StringUtils.join(arrayList, (String)","));
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        if (!arrayList.isEmpty()) {
            for (String string : arrayList) {
                String url = string + "/application/appFile/synchronousImport";
                MultipartBody body = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", jar.getName(), RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)jar)).addFormDataPart("tenantId", serverCode).addFormDataPart("serviceName", serviceName).addFormDataPart("appEnglishName", appEnglishName).addFormDataPart("compileId", compileId.toString()).addFormDataPart("pluginId", pluginId).build();
                Request request = new Request.Builder().url(url).method("POST", (RequestBody)body).addHeader("Isolate-key", idToken).build();
                Response response = client.newCall(request).execute();
                if (ResultCode.SUCCESS.getCode() == response.code()) {
                    this.hussarBaseImportAppMixmsgBoService.setFailReason(compileId, response.message());
                    this.updateCompileStatusCluster(compileId, "2", string + "\u8282\u70b9\u5206\u53d1\u5931\u8d25\uff01" + response.message());
                }
                response.close();
            }
        } else {
            this.hussarBaseImportAppMixmsgBoService.setFailReason(compileId, "\u96c6\u7fa4\u8282\u70b9\u672a\u914d\u7f6e");
            this.updateCompileStatus(compileId, "2", "\u96c6\u7fa4\u8282\u70b9\u672a\u914d\u7f6e");
            throw new Exception("\u96c6\u7fa4\u8282\u70b9\u672a\u914d\u7f6e");
        }
    }

    private void updateCompileStatusCluster(Long compileId, String status, String msg) {
        SysAppPackage sysAppPackage = this.hussarBaseAppMixPackageBoService.getById(compileId);
        if (ToolUtil.isNotEmpty((Object)sysAppPackage)) {
            sysAppPackage.setStatus(status);
            if (ToolUtil.isNotEmpty((Object)msg)) {
                if (ToolUtil.isNotEmpty((Object)sysAppPackage.getErrorMsg())) {
                    sysAppPackage.setErrorMsg(msg + sysAppPackage.getErrorMsg());
                } else {
                    sysAppPackage.setErrorMsg(msg);
                }
            }
            this.hussarBaseAppMixPackageBoService.updateById(sysAppPackage);
        }
    }

    private Boolean compileFront(String appEnglishName, String serverCode, Long compileId, String serviceName, String tempPath) throws Exception {
        block6: {
            String version;
            block5: {
                Map<String, Object> threadMap = context.get();
                version = (String)threadMap.get("version");
                if (!"dev".equals(this.active)) break block5;
                File distPathFile = new File(tempPath + File.separator + "vue" + File.separator + VUE_DIST + ExportResourceConstant._HUSSAR);
                if (!distPathFile.exists()) break block6;
                String ngPath = this.nginxFrontPath + File.separator + AppContextUtil.asIdentifier((String)serverCode) + File.separator;
                File ngFileDir = new File(ngPath);
                if (!ngFileDir.exists()) {
                    ngFileDir.mkdirs();
                }
                String unzipDist = tempPath + File.separator + "vue" + File.separator + VUE_DIST + File.separator;
                ZipUtil.unzip(distPathFile.getAbsolutePath(), unzipDist);
                File distWithOutVersion = new File(unzipDist + AppContextUtil.asIdentifier((String)serviceName) + "_" + AppContextUtil.asIdentifier((String)appEnglishName));
                File distWithVersion = new File(unzipDist + AppContextUtil.asIdentifier((String)serviceName) + "_" + AppContextUtil.asIdentifier((String)appEnglishName) + "_" + version);
                distWithOutVersion.renameTo(distWithVersion);
                FileUtils.copyDirectoryToDirectory((File)distWithVersion, (File)ngFileDir);
                File ngFile = new File(ngFileDir + File.separator + VUE_DIST + ExportResourceConstant._HUSSAR);
                if (!ngFile.exists()) break block6;
                ngFile.delete();
                break block6;
            }
            File temp = new File(tempPath);
            File[] childFiles = temp.listFiles();
            File zipFile = null;
            assert (childFiles != null);
            for (File file : childFiles) {
                if (!file.getName().endsWith(".zip")) continue;
                zipFile = file;
            }
            if (zipFile == null) {
                throw new HussarException("\u672a\u627e\u5230zip\u6587\u4ef6");
            }
            List<String> serviceList = this.getIpAndPortByServiceName("hussar-web");
            logger.info("\u5df2\u914d\u7f6e\u96c6\u7fa4\u8282\u70b9\uff1a{}", (Object)StringUtils.join(serviceList, (String)","));
            String idToken = (String)HussarCacheUtil.get((String)"hussar-token", (Object)"hussar-token:var:id-token");
            OkHttpClient client = new OkHttpClient().newBuilder().build();
            for (String service : serviceList) {
                String url = service + "/hussarBase/application/mix/compileFront";
                MultipartBody body = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", zipFile.getName(), RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)zipFile)).addFormDataPart("appCode", appEnglishName).addFormDataPart("serverCode", serverCode).addFormDataPart("compileId", compileId.toString()).addFormDataPart("serviceName", serviceName).addFormDataPart("version", version).build();
                Request request = new Request.Builder().url(url).method("POST", (RequestBody)body).addHeader("Isolate-key", idToken).build();
                Response response = client.newCall(request).execute();
                response.close();
            }
        }
        return true;
    }

    private void updateCompileStatus(Long compileId, String status, String msg) {
        SysAppPackage sysAppPackage = this.hussarBaseAppMixPackageBoService.getById(compileId);
        if (ToolUtil.isNotEmpty((Object)sysAppPackage) && !"2".equals(sysAppPackage.getStatus())) {
            sysAppPackage.setStatus(status);
            if (ToolUtil.isNotEmpty((Object)msg)) {
                sysAppPackage.setErrorMsg(msg);
            }
            this.hussarBaseAppMixPackageBoService.updateById(sysAppPackage);
        }
    }

    private void deleteTempFileWithoutZipAndAddHistory(File temp, Long appId) throws IOException {
        File[] childFiles;
        if (ToolUtil.isNotEmpty((Object)temp) && temp.exists() && ToolUtil.isNotEmpty((Object)(childFiles = temp.listFiles()))) {
            for (File file : childFiles) {
                if (file.getName().endsWith(".zip")) {
                    SysAppImportHistory sysAppImportHistory = new SysAppImportHistory();
                    sysAppImportHistory.setAppId(appId);
                    String packageName = file.getName();
                    packageName = packageName.substring(0, packageName.length() - 4) + ".hussar";
                    sysAppImportHistory.setSyncStatus(expansion);
                    sysAppImportHistory.setPackagePath(file.getAbsolutePath());
                    sysAppImportHistory.setImportTime(new Timestamp(System.currentTimeMillis()));
                    sysAppImportHistory.setPackageName(packageName);
                    this.hussarBaseImportAppHistoryBoService.saveOrUpdate(sysAppImportHistory);
                    continue;
                }
                FileUtils.forceDelete((File)file);
            }
        }
    }

    private void backUpAppFiles(Long appId, String serverCode, String appEnglishName, String serviceName) throws IOException {
        Map<String, String> pathMap = this.getAppFilePath(appId, serverCode, appEnglishName, serviceName);
        String pluginPath = pathMap.get("pluginPath");
        File plugin = new File(pluginPath);
        String pluginBackUpPath = pathMap.get("pluginBackUpPath");
        if (plugin.exists()) {
            FileUtils.copyDirectory((File)plugin, (File)new File(pluginBackUpPath));
        }
    }

    private Map<String, String> getAppFilePath(Long appId, String serverCode, String appEnglishName, String serviceName) {
        String tenantDir = AppContextUtil.asIdentifier((String)serverCode);
        String enName = AppContextUtil.asIdentifier((String)appEnglishName);
        serviceName = AppContextUtil.asIdentifier((String)serviceName);
        String appPath = tenantDir + File.separator + serviceName + File.separator + enName;
        String vuePath = FileUtil.posixPath((String[])new String[]{this.hussarProduceProperties.getFrontPath(), this.hussarAppExportProperties.getVueCodePath(), MODULES, appPath, VIEWS});
        String apiPath = FileUtil.posixPath((String[])new String[]{this.hussarProduceProperties.getFrontPath(), this.hussarAppExportProperties.getFrontApiPath(), MODULES, appPath, API});
        String tenantAndSer = tenantDir + "-" + serviceName;
        String tenantAndApp = tenantDir + "-" + serviceName + "-" + enName;
        String pluginPath = FileUtil.posixPath((String[])new String[]{this.hussarProduceProperties.getPluginPath(), this.pluginPrefix + tenantDir, this.pluginPrefix + tenantAndSer, this.pluginPrefix + tenantAndApp});
        String frontBackUpPath = FileUtil.posixPath((String[])new String[]{this.hussarProduceProperties.getWebPath(), "frontBackUp", serviceName, enName});
        String vueBackUpPath = FileUtil.posixPath((String[])new String[]{frontBackUpPath, this.hussarAppExportProperties.getVueCodePath(), MODULES, appPath, VIEWS});
        String apiBackUpPath = FileUtil.posixPath((String[])new String[]{frontBackUpPath, this.hussarAppExportProperties.getFrontApiPath(), MODULES, appPath, API});
        String pluginParentPath = new File(this.hussarProduceProperties.getPluginPath()).getParent();
        String pluginBackUpPath = FileUtil.posixPath((String[])new String[]{pluginParentPath, "hussar-plugin-back", this.pluginPrefix + tenantDir, this.pluginPrefix + tenantAndSer, this.pluginPrefix + tenantAndApp});
        HashMap<String, String> pathMap = new HashMap<String, String>();
        pathMap.put("vuePath", vuePath);
        pathMap.put("apiPath", apiPath);
        pathMap.put("frontBackUpPath", frontBackUpPath);
        pathMap.put("vueBackUpPath", vueBackUpPath);
        pathMap.put("apiBackUpPath", apiBackUpPath);
        pathMap.put("pluginPath", pluginPath);
        pathMap.put("pluginBackUpPath", pluginBackUpPath);
        return pathMap;
    }

    private void importFunResMenu(Long appId, File file) throws IOException, ClassNotFoundException {
        byte[] meta = FileUtils.readFileToByteArray((File)file);
        Map funResMenuMap = (Map)SerializeUtils.deserialize((byte[])meta);
        if (HussarUtils.isEmpty((Object)funResMenuMap)) {
            return;
        }
        List sysFunctions = (List)funResMenuMap.get("sysFunctions");
        sysFunctions.forEach(fun -> fun.setAppId(appId));
        this.remoteSysFunctionsBoService.saveOrUpdateList(sysFunctions);
        List sysFunctionModules = (List)funResMenuMap.get("sysFunctionModules");
        sysFunctionModules.forEach(functionModules -> functionModules.setAppId(appId));
        this.remoteSysFunctionModulesBoService.saveOrUpdateList(sysFunctionModules);
        List sysResources = (List)funResMenuMap.get("sysResources");
        sysResources.forEach(resource -> resource.setAppId(appId));
        this.remoteHussarBaseResourceService.saveOrUpdateList(sysResources);
        List sysResourceModules = (List)funResMenuMap.get("sysResourceModules");
        sysResourceModules.forEach(resourceModules -> resourceModules.setAppId(appId));
        this.remoteSysResourceMosulesBoService.saveOrUpdateList(sysResourceModules);
        List sysFunctionResources = (List)funResMenuMap.get("sysFunctionResources");
        this.remoteSysFunctionResourcesBoService.saveOrUpdateList(sysFunctionResources);
        List sysMenus = (List)funResMenuMap.get("sysMenus");
        this.remoteSysMenuManageBoService.saveOrUpdateList(sysMenus);
    }

    private File importCode(File temp, MixAppInfoVo appInfo, String serviceName, String tenantId) throws Exception {
        File jar = null;
        HashMap threadMap = Maps.newHashMap();
        File jarFile = new File(temp, ExportResourceConstant.JAVA + File.separator + "pluginJar.jar");
        if (jarFile.exists()) {
            String uninstallId;
            PluginInfo pluginInfo;
            String appEnglishName = appInfo.getAppEnglishName();
            String unzipJarPath = FileUtil.posixPath((String[])new String[]{temp.getAbsolutePath(), ExportResourceConstant.JAVA + File.separator + "pluginJar" + File.separator});
            ZipUtil.unzip(jarFile.getAbsolutePath(), unzipJarPath);
            File importProperties = FileUtils.getFile((File)new File(unzipJarPath), (String[])new String[]{"plugin.properties"});
            Properties properties = PropertiesUtils.loadProperties((String)importProperties.getAbsolutePath());
            String pluginId = properties.getProperty("plugin.id");
            threadMap.put("pluginId", pluginId);
            String originVersion = properties.getProperty("plugin.version");
            String version = this.dealWithVersion(originVersion);
            threadMap.put("version", version);
            String newJarName = AppContextUtil.asIdentifier((String)tenantId) + "-" + AppContextUtil.asIdentifier((String)serviceName) + "-" + AppContextUtil.asIdentifier((String)appEnglishName);
            File renameJar = new File(temp, ExportResourceConstant.JAVA + File.separator + newJarName + ".jar");
            if ("dev".equals(this.active)) {
                String currentDate = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
                renameJar = new File(temp, ExportResourceConstant.JAVA + File.separator + appEnglishName + "-" + currentDate + ".jar");
            }
            this.rePackage(jarFile.toPath(), renameJar.toPath(), rePackage -> {
                if (!"22".equals(appInfo.getAppType())) {
                    String pluginIdVersion = pluginId + "-" + version;
                    rePackage.setProperty("plugin.id", pluginIdVersion);
                }
                return rePackage;
            });
            File destDir = new File(this.hussarProduceProperties.getPluginPath() + File.separator + version);
            if ("21".equals(appInfo.getAppType()) && "dev".equals(this.active)) {
                destDir = new File(this.hussarProduceProperties.getHybridExtraPath());
            }
            if ("22".equals(appInfo.getAppType())) {
                destDir = new File(this.hussarProduceProperties.getPluginPath() + File.separator + AppContextUtil.asIdentifier((String)tenantId));
            }
            try {
                String standardApplicationName;
                SharePluginInfoDto sharePluginInfoDto;
                SharePluginInfoDto record = this.sharePluginService.queryPluginInfo(tenantId, appEnglishName);
                if (HussarUtils.isEmpty((Object)record) || !version.equals(record.getAppVersion())) {
                    if (HussarUtils.isNotEmpty((Object)record)) {
                        this.sharePluginService.removePluginInfo(tenantId, appEnglishName);
                    }
                    SharePluginInfoDto pluginInfoDto = new SharePluginInfoDto();
                    pluginInfoDto.setSharePluginId(pluginId);
                    pluginInfoDto.setTenantCode(tenantId);
                    pluginInfoDto.setAppCode(appEnglishName);
                    pluginInfoDto.setAppName(appInfo.getAppName());
                    pluginInfoDto.setAppVersion(version);
                    pluginInfoDto.setRunMode(this.active);
                    pluginInfoDto.setServiceName(serviceName);
                    String pluginParentPath = new File(this.hussarProduceProperties.getPluginPath()).getParent();
                    String pluginBackUpPath = FileUtil.posixPath((String[])new String[]{pluginParentPath, "hussar-plugin-back"});
                    pluginInfoDto.setBackupPluginPath(pluginBackUpPath);
                    HussarTenantDefinition tenantByTenantCode = this.sysTenantService.getTenantByTenantCode(tenantId);
                    if (HussarUtils.isNotEmpty((Object)tenantByTenantCode)) {
                        pluginInfoDto.setConnName(tenantByTenantCode.getConnName());
                    }
                    if (!"22".equals(appInfo.getAppType())) {
                        this.sharePluginService.savePluginInfo(pluginInfoDto);
                        this.addExpansionPluginsModule(appEnglishName + "_extension", serviceName, true);
                    }
                }
                if (HussarUtils.isNotEmpty((Object)record)) {
                    SharePluginInfoDto queryDto = new SharePluginInfoDto();
                    queryDto.setAppVersion(record.getAppVersion());
                    queryDto.setSharePluginId(record.getSharePluginId());
                    List oldSharePluginList = this.sharePluginService.queryPluginInfoList(queryDto);
                    if (oldSharePluginList.isEmpty()) {
                        this.pluginOperator.uninstall(record.getSharePluginId() + "-" + record.getAppVersion(), false);
                    }
                }
                if ("22".equals(appInfo.getAppType()) && HussarUtils.isNotEmpty((Object)(sharePluginInfoDto = this.sharePluginService.queryPluginInfo(tenantId, standardApplicationName = appEnglishName.length() >= 10 ? appEnglishName.substring(0, appEnglishName.length() - 10) : appEnglishName)))) {
                    sharePluginInfoDto.setExpansionPluginId(pluginId);
                    this.sharePluginService.savePluginInfo(sharePluginInfoDto);
                }
            }
            catch (Exception record) {
                // empty catch block
            }
            if ("prod".equals(this.active) && ToolUtil.isNotEmpty((Object)(pluginInfo = this.pluginOperator.getPluginInfo(uninstallId = "22".equals(appInfo.getAppType()) ? pluginId : pluginId + "-" + version)))) {
                this.pluginOperator.uninstall(uninstallId, false);
            }
            FileUtils.copyFileToDirectory((File)renameJar, (File)destDir);
            jar = new File(this.hussarProduceProperties.getPluginPath() + File.separator + version, renameJar.getName());
            if ("22".equals(appInfo.getAppType())) {
                jar = new File(this.hussarProduceProperties.getPluginPath() + File.separator + AppContextUtil.asIdentifier((String)tenantId), renameJar.getName());
            }
        }
        context.set(threadMap);
        return jar;
    }

    private String dealWithVersion(String version) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < version.length(); ++i) {
            char ch = version.charAt(i);
            if (!(ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9') && ch != '_') continue;
            builder.append(ch);
        }
        return builder.toString();
    }

    private void rePackage(Path src, Path dst, Function<Properties, Properties> customizer) throws IOException {
        try (ZipInputStream zipInput = new ZipInputStream(Files.newInputStream(src, new OpenOption[0]));
             ZipOutputStream zipOutput = new ZipOutputStream(Files.newOutputStream(dst, new OpenOption[0]));){
            ZipEntry entryInput;
            while ((entryInput = zipInput.getNextEntry()) != null) {
                ZipEntry entryOutput = new ZipEntry(entryInput.getName());
                entryOutput.setTime(entryInput.getTime());
                entryOutput.setComment(entryInput.getComment());
                entryOutput.setExtra(entryInput.getExtra());
                zipOutput.putNextEntry(entryOutput);
                if (Objects.equals("plugin.properties", entryInput.getName())) {
                    Properties pluginProps = new Properties();
                    pluginProps.load(zipInput);
                    pluginProps = customizer.apply(pluginProps);
                    pluginProps.store(zipOutput, null);
                } else {
                    IOUtils.copy((InputStream)zipInput, (OutputStream)zipOutput);
                    zipInput.closeEntry();
                }
                zipOutput.closeEntry();
            }
        }
    }

    private void importPlugin(File java, String appName, String serviceName, String tenantId) throws IOException, XmlPullParserException {
        String modulePath = FileUtil.posixPath((String[])new String[]{this.hussarProduceProperties.getPluginPath(), this.pluginPrefix + AppContextUtil.asIdentifier((String)tenantId), this.pluginPrefix + AppContextUtil.asIdentifier((String)tenantId) + "-" + AppContextUtil.asIdentifier((String)serviceName), this.pluginPrefix + AppContextUtil.asIdentifier((String)tenantId) + "-" + AppContextUtil.asIdentifier((String)serviceName) + "-" + AppContextUtil.asIdentifier((String)appName)});
        File module = new File(modulePath);
        String appPath = FileUtil.posixPath((String[])new String[]{this.hussarProduceProperties.getPluginPath(), this.pluginPrefix + AppContextUtil.asIdentifier((String)tenantId), this.pluginPrefix + AppContextUtil.asIdentifier((String)tenantId) + "-" + AppContextUtil.asIdentifier((String)serviceName), this.pluginPrefix + AppContextUtil.asIdentifier((String)tenantId) + "-" + AppContextUtil.asIdentifier((String)serviceName) + "-" + AppContextUtil.asIdentifier((String)appName), this.pluginPrefix + AppContextUtil.asIdentifier((String)tenantId) + "-" + AppContextUtil.asIdentifier((String)serviceName) + "-" + AppContextUtil.asIdentifier((String)appName) + "-application"});
        File application = new File(appPath);
        File applicationJava = new File(java, this.pluginPrefix + AppContextUtil.asIdentifier((String)tenantId) + "-" + AppContextUtil.asIdentifier((String)serviceName) + "-" + AppContextUtil.asIdentifier((String)appName) + "-application");
        String apiPath = FileUtil.posixPath((String[])new String[]{this.hussarProduceProperties.getPluginPath(), this.pluginPrefix + AppContextUtil.asIdentifier((String)tenantId), this.pluginPrefix + AppContextUtil.asIdentifier((String)tenantId) + "-" + AppContextUtil.asIdentifier((String)serviceName), this.pluginPrefix + AppContextUtil.asIdentifier((String)tenantId) + "-" + AppContextUtil.asIdentifier((String)serviceName) + "-" + AppContextUtil.asIdentifier((String)appName), this.pluginPrefix + AppContextUtil.asIdentifier((String)tenantId) + "-" + AppContextUtil.asIdentifier((String)serviceName) + "-" + AppContextUtil.asIdentifier((String)appName) + "-api"});
        File api = new File(apiPath);
        File apiJava = new File(java, this.pluginPrefix + AppContextUtil.asIdentifier((String)tenantId) + "-" + AppContextUtil.asIdentifier((String)serviceName) + "-" + AppContextUtil.asIdentifier((String)appName) + "-api");
        this.updateApiFile(apiJava, api, applicationJava, application);
        this.updatePluinFile(applicationJava, application, appName, tenantId, serviceName);
        FileUtils.copyDirectory((File)java, (File)module);
    }

    private void updateApiFile(File apiJava, File apiModule, File applicationJava, File applicationModule) throws IOException, XmlPullParserException {
        boolean isApiExist = apiModule.exists();
        boolean isAppExist = applicationModule.exists();
        File apiPom = new File(apiJava, "pom.xml");
        File appPom = new File(applicationJava, "pom.xml");
        if (isApiExist && isAppExist) {
            this.updateApiPomFile(apiJava, apiModule, applicationModule, apiPom, appPom);
        }
    }

    private void updateApiPomFile(File apiJava, File apiModule, File applicationModule, File apiPom, File appPom) throws IOException, XmlPullParserException {
        File apiModulePom = FileUtils.getFile((File)apiModule, (String[])new String[]{"pom.xml"});
        File appModulePom = FileUtils.getFile((File)applicationModule, (String[])new String[]{"pom.xml"});
        if (apiModulePom.exists() && appModulePom.exists()) {
            MavenXpp3Reader reader = new MavenXpp3Reader();
            try (FileInputStream oldApiFis = new FileInputStream(apiModulePom);
                 FileInputStream newApiFis = new FileInputStream(apiPom);
                 FileInputStream newAppFis = new FileInputStream(appPom);){
                Model oldApiModel = reader.read((InputStream)oldApiFis);
                Model newApiModel = reader.read((InputStream)newApiFis);
                Model newAppModel = reader.read((InputStream)newAppFis);
                String oldApiPomVersion = oldApiModel.getVersion();
                if (ToolUtil.isEmpty((Object)oldApiPomVersion)) {
                    newApiModel.setVersion("1.0.0-RELEASE");
                } else {
                    int pomIndex = oldApiPomVersion.indexOf(".");
                    int pomVersion = Integer.parseInt(oldApiPomVersion.substring(0, pomIndex)) + 1;
                    String newApiPomVersion = pomVersion + oldApiPomVersion.substring(pomIndex);
                    newApiModel.setVersion(newApiPomVersion);
                    String apiArtifactId = oldApiModel.getArtifactId();
                    List dependencies = newAppModel.getDependencies();
                    if (HussarUtils.isNotEmpty((Object)dependencies)) {
                        for (Dependency dependency : dependencies) {
                            String artifactId = dependency.getArtifactId();
                            if (!artifactId.equals(apiArtifactId)) continue;
                            dependency.setVersion(newApiPomVersion);
                            break;
                        }
                    }
                }
                MavenXpp3Writer mavenXpp3Writer = new MavenXpp3Writer();
                try (FileWriter apiWriter = new FileWriter(apiPom);
                     FileWriter appWriter = new FileWriter(appPom);){
                    mavenXpp3Writer.write((Writer)apiWriter, newApiModel);
                    mavenXpp3Writer.write((Writer)appWriter, newAppModel);
                }
            }
        }
    }

    private void updatePluinFile(File java, File module, String appName, String tenantId, String serviceName) throws IOException, XmlPullParserException {
        boolean isExist = module.exists();
        File pom = new File(java, "pom.xml");
        if (!pom.exists()) {
            this.createPluginFile(java, appName, tenantId, serviceName);
            return;
        }
        if (isExist) {
            this.updateConfigFile(java, module, pom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPluginFile(File java, String appName, String tenantId, String serviceName) throws IOException {
        File temp = Files.createTempDirectory("java" + tenantId + appName, new FileAttribute[0]).toFile();
        try {
            String tempJavaPath = FileUtil.posixPath((String[])new String[]{temp.getAbsolutePath(), this.formdesignProperties.getJavaCodePath()});
            FileUtils.copyDirectory((File)java, (File)new File(tempJavaPath));
            FileUtils.forceDelete((File)java);
            java.mkdirs();
            String appEnglishName = AppContextUtil.asIdentifier((String)appName);
            String tenantCode = AppContextUtil.asIdentifier((String)tenantId);
            String appNameLow = appEnglishName.toLowerCase();
            String tenantCodeLow = tenantCode.toLowerCase();
            HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
            paramMap.put("tenantCode", tenantCodeLow);
            paramMap.put("applicationCode", appNameLow);
            paramMap.put("serviceName", serviceName);
            String javaPath = FileUtil.posixPath((String[])new String[]{temp.getAbsolutePath(), this.formdesignProperties.getJavaCodePath(), this.formdesignProperties.getJavaPath(), tenantCodeLow, appNameLow});
            String configPath = FileUtil.posixPath((String[])new String[]{javaPath, "config"});
            PluginCodeGenerator configBeanGen = new PluginCodeGenerator("ConfigBean.ftl", paramMap, configPath, "ConfigBean.java");
            configBeanGen.gen();
            String appPath = tenantCodeLow + "/" + appNameLow;
            paramMap.put("applicationPath", appPath);
            PluginCodeGenerator mybatisConfigGen = new PluginCodeGenerator("PluginMybatisPlusConfiguration.ftl", paramMap, configPath, "PluginMybatisPlusConfiguration.java");
            PluginCodeGenerator pluginConfigrationGen = new PluginCodeGenerator("pluginConfigrationGen.ftl", paramMap, configPath, "PluginConfigration.java");
            mybatisConfigGen.gen();
            pluginConfigrationGen.gen();
            String newAppName = appEnglishName;
            String appFirst = appEnglishName.substring(0, 1);
            if (P.matcher(appFirst).find()) {
                newAppName = appFirst.toUpperCase() + appEnglishName.substring(1);
            }
            String tenantUp = tenantCode;
            String tenantFist = tenantCode.substring(0, 1);
            if (!"_".equals(tenantFist)) {
                tenantUp = tenantFist.toUpperCase() + tenantCode.substring(1);
            }
            String className = tenantUp + newAppName + "ParamsPlugin";
            paramMap.put("className", className);
            PluginCodeGenerator basePluginGen = new PluginCodeGenerator("ParamsPlugin.ftl", paramMap, javaPath, className + ".java");
            basePluginGen.gen();
            String propertiesPath = FileUtil.posixPath((String[])new String[]{temp.getAbsolutePath(), "src/main/resources"});
            String pluginId = tenantCode + "-" + appEnglishName;
            String provider = BaseSecurityUtil.getUser().getAccount();
            String pluginClass = FileUtil.posixPath((String[])new String[]{this.formdesignProperties.getJavaPath(), tenantCodeLow, appNameLow, className}).replace("/", ".");
            if (pluginClass.startsWith(".")) {
                pluginClass = pluginClass.substring(1);
            }
            paramMap.put("id", pluginId);
            paramMap.put("class", pluginClass);
            paramMap.put("provider", provider);
            paramMap.put("description", expansion);
            PluginCodeGenerator propertiesGen = new PluginCodeGenerator("plugin.ftl", paramMap, propertiesPath, "plugin.properties");
            propertiesGen.gen();
            paramMap.put("artifactId", this.pluginPrefix + tenantCode + "-" + appEnglishName);
            paramMap.put("pluginParentName", this.pluginParentName);
            PluginCodeGenerator pomGen = new PluginCodeGenerator("appPom.ftl", paramMap, java.getAbsolutePath(), "pom.xml");
            pomGen.gen();
            FileUtils.copyDirectory((File)temp, (File)java);
        }
        finally {
            FileUtils.forceDelete((File)temp);
        }
    }

    private void updateConfigFile(File java, File module, File pom) throws IOException, XmlPullParserException {
        block39: {
            File modulePom = FileUtils.getFile((File)module, (String[])new String[]{"pom.xml"});
            File moduleProperties = FileUtils.getFile((File)module, (String[])new String[]{"src/main/resources", "plugin.properties"});
            File importProperties = FileUtils.getFile((File)java, (String[])new String[]{"src/main/resources", "plugin.properties"});
            if (moduleProperties.exists() && modulePom.exists()) {
                Properties properties = PropertiesUtils.loadProperties((String)moduleProperties.getAbsolutePath());
                String oldVersion = properties.getProperty("plugin.version");
                int index = oldVersion.lastIndexOf(".");
                int version = Integer.parseInt(oldVersion.substring(index + 1)) + 1;
                String newVersion = oldVersion.substring(0, index + 1) + version;
                this.updateProperty(importProperties, "plugin.version", newVersion);
                MavenXpp3Reader reader = new MavenXpp3Reader();
                try (FileInputStream oldFis = new FileInputStream(modulePom);
                     FileInputStream newFis = new FileInputStream(pom);){
                    Model oldModel = reader.read((InputStream)oldFis);
                    Model newModel = reader.read((InputStream)newFis);
                    Properties pomProperties = newModel.getProperties();
                    pomProperties.setProperty("plugin.version", newVersion);
                    String oldPomVersion = oldModel.getVersion();
                    if (ToolUtil.isEmpty((Object)oldPomVersion)) {
                        newModel.setVersion("1.0.0-RELEASE");
                    } else {
                        int pomIndex = oldPomVersion.indexOf(".");
                        int pomVersion = Integer.parseInt(oldPomVersion.substring(0, pomIndex)) + 1;
                        String newPomVersion = pomVersion + oldPomVersion.substring(pomIndex);
                        newModel.setVersion(newPomVersion);
                    }
                    MavenXpp3Writer mavenXpp3Writer = new MavenXpp3Writer();
                    try (FileWriter writer = new FileWriter(pom);){
                        mavenXpp3Writer.write((Writer)writer, newModel);
                        break block39;
                    }
                }
            }
            this.updateProperty(importProperties, "plugin.version", "v1.0.0");
        }
    }

    private String replacePluginId(String pluginId, int position, String tenantCode) {
        int count;
        if (pluginId == null || pluginId.isEmpty() || position < 1) {
            return pluginId;
        }
        String tenantIdentifier = AppContextUtil.asIdentifier((String)tenantCode);
        logger.info("\u66ff\u6362\u7b2c{}\u4e2a\u4e2d\u5212\u7ebf\u524d\u5185\u5bb9, \u79df\u6237code: {}", (Object)position, (Object)tenantCode);
        int index = -1;
        for (count = 0; count < position && (index = pluginId.indexOf(45, index + 1)) != -1; ++count) {
        }
        if (index != -1 && count == position) {
            return tenantIdentifier + pluginId.substring(index);
        }
        return pluginId;
    }

    private void updateProperty(File properties, String key, String value) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try (FileInputStream fis = new FileInputStream(properties);
             InputStreamReader inputReader = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);
             BufferedReader bf = new BufferedReader(inputReader);){
            String str;
            while ((str = bf.readLine()) != null) {
                String name;
                if (!str.contains("#") && str.contains("=") && key.equals(name = str.substring(0, str.indexOf("=")).trim())) {
                    arrayList.add(key + "=" + value);
                    continue;
                }
                arrayList.add(str);
            }
            try (FileOutputStream fos = new FileOutputStream(properties);
                 OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
                 BufferedWriter bw = new BufferedWriter(osw);){
                for (String s : arrayList) {
                    bw.write(s);
                    bw.newLine();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void importJavaCode(File java, String appName, String tenantId) throws IOException {
        String parentModulePath = FileUtil.posixPath((String[])new String[]{this.modulePath, this.prefixName, this.pluginPrefix + AppContextUtil.asIdentifier((String)tenantId)});
        File parentModule = new File(parentModulePath);
        if (!parentModule.exists()) {
            parentModule.mkdirs();
        }
        String tenantAndApp = AppContextUtil.asIdentifier((String)tenantId) + "-" + AppContextUtil.asIdentifier((String)appName);
        String pluginName = this.pluginPrefix + tenantAndApp;
        File pluginModule = new File(parentModule, pluginName);
        if (!pluginModule.exists()) {
            parentModule.mkdirs();
        }
        String javaPath = FileUtil.posixPath((String[])new String[]{pluginModule.getAbsolutePath(), this.formdesignProperties.getJavaCodePath()});
        FileUtils.copyDirectory((File)java, (File)new File(javaPath));
    }

    private File mavenPackage(String serverCode, String serviceName, String appName) throws IOException, MavenInvocationException, XmlPullParserException {
        File jar;
        MavenXpp3Reader reader;
        String appPomPath;
        String modulePath;
        block38: {
            String tenAndSer = AppContextUtil.asIdentifier((String)serverCode) + "-" + AppContextUtil.asIdentifier((String)serviceName);
            String tenantAndApp = AppContextUtil.asIdentifier((String)serverCode) + "-" + AppContextUtil.asIdentifier((String)serviceName) + "-" + AppContextUtil.asIdentifier((String)appName);
            modulePath = FileUtil.posixPath((String[])new String[]{this.hussarProduceProperties.getPluginPath(), this.pluginPrefix + AppContextUtil.asIdentifier((String)serverCode), this.pluginPrefix + tenAndSer, this.pluginPrefix + tenantAndApp});
            appPomPath = FileUtil.posixPath((String[])new String[]{this.hussarProduceProperties.getPluginPath(), this.pluginPrefix + AppContextUtil.asIdentifier((String)serverCode), this.pluginPrefix + tenAndSer, this.pluginPrefix + tenantAndApp, this.pluginPrefix + tenantAndApp + "-application"});
            String parentPom = this.hussarProduceProperties.getPluginPath() + "pom.xml";
            reader = new MavenXpp3Reader();
            this.updatePluginId(appPomPath, serverCode);
            try (FileInputStream fis = new FileInputStream(parentPom);){
                Model model = reader.read((InputStream)fis);
                List modules = model.getModules();
                String moduleName = this.pluginPrefix + AppContextUtil.asIdentifier((String)serverCode) + File.separator + this.pluginPrefix + AppContextUtil.asIdentifier((String)serverCode) + "-" + AppContextUtil.asIdentifier((String)serviceName) + File.separator + this.pluginPrefix + tenantAndApp;
                if (modules.contains(moduleName)) break block38;
                modules.add(moduleName);
                MavenXpp3Writer mavenXpp3Writer = new MavenXpp3Writer();
                try (FileWriter fileWriter = new FileWriter(parentPom);){
                    mavenXpp3Writer.write((Writer)fileWriter, model);
                }
            }
        }
        String pom = FileUtil.posixPath((String[])new String[]{modulePath, "pom.xml"});
        MavenUtil.modulePackage(new File(pom));
        String appPom = FileUtil.posixPath((String[])new String[]{appPomPath, "pom.xml"});
        try (FileInputStream fis = new FileInputStream(appPom);){
            String finalName;
            Model model = reader.read((InputStream)fis);
            Build build = model.getBuild();
            String string = finalName = build == null ? expansion : build.getFinalName();
            if (ToolUtil.isNotEmpty((Object)finalName)) {
                this.replacePluginId(finalName, 2, serverCode);
                jar = new File(new File(appPomPath, "target"), finalName + ".jar");
            } else {
                String moduleId = model.getArtifactId();
                this.replacePluginId(moduleId, 2, serverCode);
                jar = new File(new File(appPomPath, "target"), moduleId + ".jar");
            }
        }
        File destFile = new File(this.hussarProduceProperties.getPluginPath(), jar.getName());
        FileUtils.copyFile((File)jar, (File)destFile);
        return jar;
    }

    private void updatePluginId(String appPomPath, String tenantCode) {
        File importProperties = FileUtils.getFile((File)new File(appPomPath), (String[])new String[]{"src/main/resources", "plugin.properties"});
        Properties properties = PropertiesUtils.loadProperties((String)importProperties.getAbsolutePath());
        String pluginId = properties.getProperty("plugin.id");
        this.updateProperty(importProperties, "plugin.id", this.replacePluginId(pluginId, 1, tenantCode));
    }

    private String getErrorInfoFromException(Exception e) {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            return "\r\n" + sw + "\r\n";
        }
        catch (Exception e2) {
            return "bad getErrorInfoFromException";
        }
    }

    private void rollbackOrDeleteAppFile(Long appId, String serverCode, String appEnglishName, String serviceName, boolean isRollback) throws IOException {
        Map<String, String> pathMap = this.getAppFilePath(appId, serverCode, appEnglishName, serviceName);
        String vuePath = pathMap.get("vuePath");
        String apiPath = pathMap.get("apiPath");
        String vueBackUpPath = pathMap.get("vueBackUpPath");
        String apiBackUpPath = pathMap.get("apiBackUpPath");
        File vueFile = new File(vuePath);
        File apiFile = new File(apiPath);
        File vueBackFile = new File(vueBackUpPath);
        File apiBackFile = new File(apiBackUpPath);
        if (isRollback) {
            if (vueFile.exists()) {
                FileUtils.forceDelete((File)vueFile);
            }
            if (apiFile.exists()) {
                FileUtils.forceDelete((File)apiFile);
            }
            if (vueBackFile.exists()) {
                FileUtils.copyDirectory((File)vueBackFile, (File)new File(vuePath));
            }
            if (apiBackFile.exists()) {
                FileUtils.copyDirectory((File)apiBackFile, (File)new File(apiPath));
            }
        }
    }

    private void rollbackPluginFile(Long appId, String serverCode, String appEnglishName, String serviceName) throws IOException {
        Map<String, String> pathMap = this.getAppFilePath(appId, serverCode, appEnglishName, serviceName);
        String pluginPath = pathMap.get("pluginPath");
        String pluginBackUpPath = pathMap.get("pluginBackUpPath");
        File pluginFile = new File(pluginPath);
        File pluginBackUpFile = new File(pluginBackUpPath);
        if (pluginFile.exists()) {
            FileUtils.forceDelete((File)pluginFile);
        }
        if (pluginBackUpFile.exists()) {
            FileUtils.copyDirectory((File)pluginBackUpFile, (File)new File(pluginPath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> synchronousImport(MultipartFile file, String serviceName, String appEnglisName, String tenantId, String compileId, String pluginId) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        InputStream inputStream = file.getInputStream();
        File temp = Files.createTempDirectory("appImportJar" + compileId, new FileAttribute[0]).toFile();
        File shareJar = new File(temp.getAbsolutePath() + File.separator + file.getOriginalFilename());
        FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)shareJar);
        try {
            if (shareJar.exists()) {
                logger.info("\u83b7\u53d6\u5171\u4eabjar\u5305\u6210\u529f\uff0c\u5730\u5740\u4e3a\uff1a" + shareJar.getAbsolutePath() + ",\u6587\u4ef6\u5927\u5c0f\uff1a" + shareJar.length());
                File localJar = new File(FileUtil.posixPath((String[])new String[]{this.localPlugin, File.separator + shareJar.getName()}));
                FileUtils.copyFile((File)shareJar, (File)localJar);
                logger.info("\u62c9\u53d6\u5171\u4eabjar\u5230\u672c\u5730\u6210\u529f\uff0c\u5730\u5740\u4e3a\uff1a" + localJar.getAbsolutePath() + ",\u6587\u4ef6\u5927\u5c0f\uff1a" + localJar.length());
                this.loadPluginJar(pluginId, localJar);
                logger.info("\u542f\u52a8\u672c\u5730jar\u5305\u6210\u529f");
            }
            map.put("success", true);
            map.put("msg", "\u5b89\u88c5\u63d2\u4ef6\u6210\u529f\uff01");
            this.hussarBaseImportAppMixmsgBoService.setImportStatusFour(Long.valueOf(compileId));
        }
        catch (IOException e1) {
            map.put("success", false);
            map.put("msg", "\u6587\u4ef6\u8bfb\u53d6\u5f02\u5e38\uff01");
            e1.printStackTrace();
            this.hussarBaseImportAppMixmsgBoService.setFailReason(Long.valueOf(compileId), e1.getMessage());
        }
        catch (Exception e) {
            map.put("success", false);
            map.put("msg", "\u5b89\u88c5\u63d2\u4ef6\u5931\u8d25\uff0c\u5df2\u56de\u6eda\u5907\u4efd\u63d2\u4ef6jar\u5305\uff01");
            e.printStackTrace();
            this.hussarBaseImportAppMixmsgBoService.setFailReason(Long.valueOf(compileId), e.getMessage());
        }
        finally {
            FileUtils.forceDelete((File)temp);
        }
        return map;
    }

    public void batchImport(File file, Long appId, String tenantCode, String authorization) {
        try {
            String[] tenantCodeList;
            MixAppInfoVo appInfo = this.hussarBaseAppMixBoService.getMixAppInfo(appId);
            if (HussarUtils.isEmpty((Object)appInfo)) {
                return;
            }
            String gatewayUrl = this.getIpAndPortByServiceName("hussar-cloud-gateway").get(0);
            for (String tCode : tenantCodeList = tenantCode.split(",")) {
                this.executeBatchImport(file, appInfo, tCode, authorization, gatewayUrl);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void executeBatchImport(File file, MixAppInfoVo appInfo, String tenantCode, String authorization, String gatewayUrl) throws IOException {
        BatchImportRecord importRecord = new BatchImportRecord();
        importRecord.setImportAppId(appInfo.getId());
        importRecord.setImportAppName(appInfo.getAppName());
        importRecord.setTenantCode(tenantCode);
        HussarTenantDefinition tenantDefinition = TenantCacheUtil.loadFromCacheByTenantCode((String)tenantCode);
        importRecord.setTenantName(tenantDefinition != null ? tenantDefinition.getTenantName() : expansion);
        OkHttpClient client = new OkHttpClient().newBuilder().connectTimeout(60L, TimeUnit.SECONDS).readTimeout(240L, TimeUnit.SECONDS).writeTimeout(60L, TimeUnit.SECONDS).build();
        MultipartBody body = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", file.getName(), RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)file)).addFormDataPart("appId", appInfo.getId().toString()).addFormDataPart("appCode", appInfo.getAppEnglishName()).build();
        Request request = new Request.Builder().url(gatewayUrl + "/" + appInfo.getServiceName() + "/application/appFile/importProduceApp").method("POST", (RequestBody)body).addHeader("Authorization", authorization).addHeader("client-id", "hussar-base").addHeader("Tcode", tenantCode).build();
        Response response = client.newCall(request).execute();
        ResponseBody responseBody = response.body();
        if (HussarUtils.isEmpty((Object)responseBody)) {
            importRecord.setImportStatus(Integer.valueOf(0));
            importRecord.setImportFailReason("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
            this.batchImportRecordBoService.save(importRecord);
            return;
        }
        ApiResponse apiResponse = (ApiResponse)JSONObject.parseObject((String)responseBody.string(), ApiResponse.class);
        if (ResultCode.FAILURE.getCode() == apiResponse.getCode()) {
            importRecord.setImportStatus(Integer.valueOf(0));
            importRecord.setImportFailReason(apiResponse.getMsg());
            this.batchImportRecordBoService.save(importRecord);
            return;
        }
        importRecord.setImportStatus(Integer.valueOf(1));
        this.batchImportRecordBoService.save(importRecord);
    }

    private List<String> getIpAndPortByServiceName(String serviceName) throws NacosException {
        NamingService namingService = this.nacosServiceManager.getNamingService();
        List allInstances = namingService.getAllInstances(serviceName);
        ArrayList result = Lists.newArrayList();
        for (Instance instance : allInstances) {
            String info = "http://" + instance.getIp() + ":" + instance.getPort();
            result.add(info);
        }
        return result;
    }
}

