/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.app.imports.controller;

import com.jxdinfo.hussar.app.imports.service.AppImportService;
import com.jxdinfo.hussar.app.imports.service.MircoAppImportCtrlService;
import com.jxdinfo.hussar.applicationmix.dto.DownloadFilePathDto;
import com.jxdinfo.hussar.applicationmix.model.SysEyImportAppMsg;
import com.jxdinfo.hussar.applicationmix.properties.HussarClusterProperties;
import com.jxdinfo.hussar.applicationmix.service.IHussarBaseAppMixBoService;
import com.jxdinfo.hussar.applicationmix.service.IHussarBaseImportAppMixMsgBoService;
import com.jxdinfo.hussar.applicationmix.vo.MixAppInfoVo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.external.inducts.InductsTableService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/application/appFile"})
public class AppImportController {
    @Resource
    private AppImportService appImportService;
    @Autowired
    private IHussarBaseAppMixBoService hussarBaseAppMixBoService;
    @Resource
    private MircoAppImportCtrlService appImportCtrlService;
    @Resource
    private InductsTableService inductsTableService;
    @Resource
    private IHussarBaseImportAppMixMsgBoService hussarBaseImportAppMixmsgBoService;
    @Resource
    private HussarClusterProperties hussarClusterProperties;
    @Value(value="${plugin.runMode:dev}")
    private String active;
    @Resource
    private HussarThreadPoolConfiguration hussarThreadPoolConfiguration;

    @PostMapping(value={"/importProduceApp"})
    public ApiResponse<Object> importProduceApp(MultipartFile file, Long appId, @RequestParam(value="appCode", required=false) String appCode, HttpServletRequest request) {
        MixAppInfoVo appInfo = this.hussarBaseAppMixBoService.getMixAppInfo(appId);
        if (ToolUtil.isEmpty((Object)appInfo) && HussarUtils.isEmpty((Object)(appInfo = this.hussarBaseAppMixBoService.getMixAppInfoByCode(appCode)))) {
            return ApiResponse.fail((String)"\u5e94\u7528\u4e0d\u5b58\u5728");
        }
        AppContextUtil.setAppId((String)appInfo.getId().toString());
        try {
            Map data = this.appImportService.importProduceApp(file, appInfo.getId());
            boolean flag = (Boolean)data.get("status");
            if (flag) {
                data.put("tenantCode", request.getHeader("tcode"));
                this.importAndCompile(data);
                return ApiResponse.success((Object)data);
            }
            return ApiResponse.fail((String)data.get("msg").toString());
        }
        catch (IOException e) {
            e.printStackTrace();
            return ApiResponse.fail((String)"\u5e94\u7528\u5bfc\u5165\u5931\u8d25");
        }
    }

    private void importAndCompile(Map<String, Object> map) {
        SecurityUser user = BaseSecurityUtil.getUser();
        boolean importMsgFlag = false;
        String tempPath = ToolUtil.isNotEmpty((Object)map.get("tempPath")) ? map.get("tempPath").toString() : "";
        this.checkFilePath(tempPath);
        Long appId = Long.parseLong(ToolUtil.isNotEmpty((Object)map.get("appId")) ? map.get("appId").toString() : null);
        String appName = ToolUtil.isNotEmpty((Object)map.get("appName")) ? map.get("appName").toString() : "";
        String sql = ToolUtil.isNotEmpty((Object)map.get("sql")) ? map.get("sql").toString() : "";
        String keys = ToolUtil.isNotEmpty((Object)map.get("keys")) ? map.get("keys").toString() : "";
        String serverCode = ToolUtil.isNotEmpty((Object)map.get("tenantCode")) ? map.get("tenantCode").toString() : user.getTenantCode();
        Long compileId = this.appImportService.addWaitingCompileTask(appId);
        boolean saveTempPathFileFlag = this.appImportService.saveTempPathFile(appId, serverCode, tempPath, compileId.toString());
        if (saveTempPathFileFlag) {
            File temp = new File(tempPath);
            if (ToolUtil.isNotEmpty((Object)temp) && temp.exists()) {
                try {
                    FileUtils.forceDelete((File)temp);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            SysEyImportAppMsg appImportMsg = new SysEyImportAppMsg();
            appImportMsg.setId(compileId);
            appImportMsg.setAppId(appId);
            appImportMsg.setImportAppName(appName);
            appImportMsg.setImportMsgSql(sql);
            appImportMsg.setImportMsgKeys(keys);
            appImportMsg.setServerCode(serverCode);
            appImportMsg.setImportStartTime(new Date());
            appImportMsg.setImportStatus("0");
            appImportMsg.setLoadFlag("0");
            appImportMsg.setImportUserId(user.getId());
            appImportMsg.setImportUserName(user.getUserName());
            appImportMsg.setServerName(user.getTenantName());
            importMsgFlag = this.appImportService.saveImportMsgToTable(appImportMsg);
        }
        if (!importMsgFlag) {
            throw new HussarException("\u4fdd\u5b58\u5bfc\u5165\u4fe1\u606f\u5931\u8d25\uff01");
        }
        SysEyImportAppMsg eyImportAppMsg = this.hussarBaseImportAppMixmsgBoService.getById(compileId);
        if (HussarUtils.isEmpty((Object)eyImportAppMsg)) {
            return;
        }
        boolean flag = this.hussarBaseImportAppMixmsgBoService.setImportStatusOne(eyImportAppMsg.getId());
        if (flag) {
            try {
                String importFileBackUpPath = FileUtil.posixPath((String[])new String[]{this.hussarClusterProperties.getImportFile(), File.separator, eyImportAppMsg.getServerCode(), File.separator, eyImportAppMsg.getAppId().toString(), File.separator, eyImportAppMsg.getId().toString()});
                this.appImportService.importAndCompileApp(importFileBackUpPath, eyImportAppMsg.getServerCode(), eyImportAppMsg.getAppId(), eyImportAppMsg.getImportMsgSql(), Arrays.asList(eyImportAppMsg.getImportMsgKeys().split(",")), eyImportAppMsg.getId(), eyImportAppMsg.getServerName());
            }
            catch (Exception e) {
                this.hussarBaseImportAppMixmsgBoService.setFailReason(eyImportAppMsg.getId(), e.getMessage());
                this.hussarBaseImportAppMixmsgBoService.setImportStatusFive(eyImportAppMsg.getId());
                throw new HussarException("\u5e94\u7528\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
    }

    @PostMapping(value={"/beforeImportAndCompile"})
    public ApiResponse<Object> beforeImportAndCompile(@RequestBody Map<String, Object> map) {
        return ApiResponse.success();
    }

    private void checkFilePath(String tempPath) {
        String regex = "^(?!(.*[\\\\/]|^)[.]{2}[\\\\/]|.*[\\\\/][.]{2}$|.*[\\\\/]\\.{1}[\\\\/]).+$";
        if (!tempPath.matches(regex)) {
            throw new HussarException("\u8def\u5f84\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
    }

    @PostMapping(value={"/importApp"})
    public ApiResponse<Object> importApp(MultipartFile file, Long appId, String type) {
        MixAppInfoVo appInfo = this.hussarBaseAppMixBoService.getMixAppInfo(appId);
        AppContextUtil.setAppId((String)appId.toString());
        if (ToolUtil.isEmpty((Object)appInfo)) {
            return ApiResponse.fail((String)"\u5e94\u7528\u4e0d\u5b58\u5728");
        }
        try {
            Map data = this.appImportService.importApp(file, appId, type);
            boolean flag = (Boolean)data.get("status");
            if (flag) {
                return ApiResponse.success((Object)data);
            }
            return ApiResponse.fail((String)data.get("msg").toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)"\u5e94\u7528\u5bfc\u5165\u5931\u8d25");
        }
    }

    @PostMapping(value={"/importExpansionApp"})
    public ApiResponse<Object> importExpansionApp(MultipartFile file, Long appId) {
        MixAppInfoVo appInfo = this.hussarBaseAppMixBoService.getMixAppInfo(appId);
        AppContextUtil.setAppId((String)appId.toString());
        if (ToolUtil.isEmpty((Object)appInfo)) {
            return ApiResponse.fail((String)"\u539f\u5e94\u7528\u4e0d\u5b58\u5728");
        }
        try {
            this.appImportService.importExpansionApp(file, appId);
            return ApiResponse.success((String)"\u6269\u5c55\u5e94\u7528\u5bfc\u5165\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)"\u6269\u5c55\u5e94\u7528\u5bfc\u5165\u5931\u8d25");
        }
    }

    @GetMapping(value={"/checkExportFile"})
    public Boolean checkExportFile(String tempPath) {
        this.checkFilePath(tempPath);
        boolean flag = false;
        if (tempPath == null) {
            return flag;
        }
        Path path = Paths.get(tempPath, new String[0]);
        if (Files.exists(path, LinkOption.NOFOLLOW_LINKS)) {
            flag = true;
        }
        return flag;
    }

    @PostMapping(value={"/downloadOffline"})
    public void downloadOffline(HttpServletResponse response, @RequestBody DownloadFilePathDto downloadFilePathDto) {
        this.appImportService.downloadOffline(downloadFilePathDto.getTempPath(), downloadFilePathDto.getFilePath(), response);
    }

    @GetMapping(value={"addPluginsModule"})
    public ApiResponse<Boolean> addPluginsModule(@RequestParam(value="applicationName") String applicationName, @RequestParam(value="chineseName") String chineseName, @RequestParam(value="serviceName") String serviceName) {
        this.checkApplicationName(applicationName);
        return ApiResponse.success((Object)this.appImportService.addPluginsModule(applicationName, chineseName, serviceName));
    }

    private void checkApplicationName(String applicationName) {
        String regex = "^[a-z][a-zA-Z0-9_]*$";
        if (!applicationName.matches(regex)) {
            throw new HussarException(applicationName + "-\u5e94\u7528\u540d\u79f0\u4e0d\u5408\u6cd5");
        }
    }

    @PostMapping(value={"/synchronousImport"})
    public ApiResponse<Object> synchronousImport(@RequestParam(value="file") MultipartFile file, @RequestParam(value="serviceName") String serviceName, @RequestParam(value="appEnglishName") String appEnglishName, @RequestParam(value="tenantId") String tenantId, @RequestParam(value="compileId") String compileId, @RequestParam(value="pluginId") String pluginId) throws IOException {
        Map map = this.appImportService.synchronousImport(file, serviceName, appEnglishName, tenantId, compileId, pluginId);
        if ("true".equals(String.valueOf(map.get("success")))) {
            return ApiResponse.success((String)String.valueOf(map.get("msg")));
        }
        return ApiResponse.fail((String)String.valueOf(map.get("msg")));
    }

    @GetMapping(value={"addExpansionPluginsModule"})
    public ApiResponse<Boolean> addExpansionPluginsModule(@RequestParam(value="applicationName") String applicationName, @RequestParam(value="serviceName") String serviceName) {
        return ApiResponse.success((Object)this.appImportService.addExpansionPluginsModule(applicationName, serviceName, false));
    }

    @PostMapping(value={"/executeSql"})
    public ApiResponse<Object> executeSql(@RequestBody Map<String, Object> map) {
        String sql = map.get("sql").toString();
        if (ToolUtil.isNotEmpty((Object)sql)) {
            this.inductsTableService.executeSql(sql);
            return ApiResponse.success((String)"sql\u6267\u884c\u6210\u529f");
        }
        return ApiResponse.fail((String)"sql\u6267\u884c\u5931\u8d25");
    }

    @PostMapping(value={"batchImport"})
    public ApiResponse batchImport(@RequestParam(value="file") MultipartFile multipartFile, @RequestParam(value="appId") Long appId, @RequestParam(value="tenantCode") String tenantCode, HttpServletRequest request) throws IOException {
        File temp = Files.createTempDirectory("batchImport" + Objects.requireNonNull(multipartFile.getName()), new FileAttribute[0]).toFile();
        File file = new File(temp.getAbsolutePath() + File.separator + multipartFile.getName() + ".hussar");
        FileUtils.copyInputStreamToFile((InputStream)multipartFile.getInputStream(), (File)file);
        String authorization = request.getHeader("Authorization");
        CompletableFuture.runAsync(() -> {
            AppImportService appImportService = (AppImportService)SpringContextHolder.getBean(AppImportService.class);
            appImportService.batchImport(file, appId, tenantCode, authorization);
        }).whenComplete((result, ex) -> {
            try {
                FileUtils.deleteDirectory((File)temp);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        return ApiResponse.success((String)"\u6279\u91cf\u5bfc\u5165\u5f00\u59cb\u6267\u884c");
    }
}

