/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.fusion.service.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.ai.fusion.model.Invoice;
import com.jxdinfo.hussar.ai.fusion.model.InvoiceMyFile;
import com.jxdinfo.hussar.ai.fusion.service.AIComponentService;
import com.jxdinfo.hussar.ai.fusion.util.FormDesignResponse;
import com.jxdinfo.hussar.ai.fusion.util.PythonRequestUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AIComponentServiceImpl
implements AIComponentService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AIComponentServiceImpl.class);

    @Override
    public FormDesignResponse<Invoice> invoice(MultipartFile file, String serverAddress) {
        FormDesignResponse<Invoice> response = new FormDesignResponse<Invoice>();
        try {
            String url = serverAddress + "/upload_invoice";
            LinkedMultiValueMap params = new LinkedMultiValueMap();
            FileUtils.writeByteArrayToFile((File)new File(file.getOriginalFilename()), (byte[])file.getBytes());
            FileSystemResource fileSystemResource = new FileSystemResource(new File(file.getOriginalFilename()));
            params.add((Object)"myfile", (Object)fileSystemResource);
            String resultCoreVO = PythonRequestUtil.sendPostRequestToText(url, (MultiValueMap<String, Object>)params);
            if (HussarUtils.isEmpty((Object)resultCoreVO)) {
                LOGGER.error("\u8c03\u7528Python\u670d\u52a1\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a\u8fd4\u56de\u7a7a\u6307\u9488");
                response.setErrorCode(HttpStatus.INTERNAL_SERVER_ERROR.value());
                response.setErrorMsg("\u8c03\u7528Python\u670d\u52a1\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a\u8fd4\u56de\u7a7a\u6307\u9488");
            } else {
                InvoiceMyFile invoiceMyFile = (InvoiceMyFile)JSON.parseObject((String)resultCoreVO, InvoiceMyFile.class);
                response.setData(Invoice.of(invoiceMyFile));
                response.setErrorCode(HttpStatus.OK.value());
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            response.setErrorCode(HttpStatus.INTERNAL_SERVER_ERROR.value());
            response.setErrorMsg("\u8c03\u7528Python\u670d\u52a1\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + e.getMessage());
        }
        return response;
    }
}

