/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.fusion.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.ai.fusion.dto.QuestionDto;
import com.jxdinfo.hussar.ai.fusion.model.GenerateField;
import com.jxdinfo.hussar.ai.fusion.model.GenerateModule;
import com.jxdinfo.hussar.ai.fusion.model.GenerateWidget;
import com.jxdinfo.hussar.ai.fusion.properties.AiModelProperties;
import com.jxdinfo.hussar.ai.fusion.service.AIModelService;
import com.jxdinfo.hussar.ai.fusion.util.AnalysisAiRespUtil;
import com.jxdinfo.hussar.ai.fusion.util.FormDesignResponse;
import com.jxdinfo.hussar.ai.fusion.util.JsonParser;
import com.jxdinfo.hussar.ai.fusion.util.WebClientUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;
import reactor.core.publisher.Flux;

public class BaseAIModelServiceImpl
implements AIModelService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseAIModelServiceImpl.class);
    private static final String DATA_MODEL_TYPE_MS = "masterSlave";
    @Autowired
    private AiModelProperties aiModelProperties;

    @Override
    public Flux<String> conversation(QuestionDto questionDto) {
        return this.commonConversation(questionDto, this.aiModelProperties.getParams(), true);
    }

    public Flux<String> commonConversation(QuestionDto questionDto, Map<String, String> params, boolean stream) {
        return WebClientUtil.requestStreamFlux(this.getRequestUrl(params), this.initHeader(params), this.initRequestBody(questionDto.getContent(), params, "[{\"role\":\"user\",\"content\":\"%s\"}]", stream), this.handleResponse());
    }

    @Override
    public FormDesignResponse<List<GenerateField>> dataModel(String description, String dataModelType) {
        String template = "[{\"role\":\"user\",\"content\":\"\u4f60\u662f\u4e00\u4e2a\u4f18\u79c0\u7684\u6570\u636e\u5e93\u4e13\u5bb6\uff0c\u6211\u4f1a\u4e3a\u4f60\u63d0\u4f9b\u4e00\u4e9b\u4fe1\u606f\uff0c\u4f60\u8981\u6839\u636e\u4fe1\u606f\u751f\u6210\u8868\u5355\uff0c\u4e25\u683c\u6309\u7167\u5982\u4e0b\u683c\u5f0f\uff1a\u2018|1.\u5b57\u6bb5\u540d--\u82f1\u6587\u6807\u8bc6--\u5b57\u6bb5\u7c7b\u578b|2.\u5b57\u6bb5\u540d--\u82f1\u6587\u6807\u8bc6--\u5b57\u6bb5\u7c7b\u578b|...|\u2019\uff0c\u5b57\u6bb5\u7c7b\u578b\u5305\u62ec\uff1a\u5b57\u7b26\u4e32\uff0c\u6574\u6570\uff0c\u957f\u6574\u6570\uff0c\u5c0f\u6570\uff0c\u65e5\u671f\uff0c\u5e03\u5c14\uff0c\u9664\u6b64\u4e4b\u5916\u4e0d\u80fd\u8f93\u51fa\u5176\u4ed6\u7c7b\u578b\u3002\"},{\"role\":\"assistant\",\"content\":\"\u597d\u7684\uff0c\u6211\u662f\u4e00\u4e2a\u6570\u636e\u5e93\u7ba1\u7406\u4e13\u5bb6\uff0c\u6211\u4f1a\u6839\u636e\u60a8\u63d0\u4f9b\u7684\u683c\u5f0f\u8f93\u51fa\u76f8\u5e94\u7684\u5b57\u6bb5\u3002\"},{\"role\":\"user\",\"content\":\"\u6211\u8981\u4e00\u4e2a\u5458\u5de5\u4fe1\u606f\u7ba1\u7406\u8868\uff0c\u4fdd\u6301\u683c\u5f0f\u7edf\u4e00\"},{\"role\":\"assistant\",\"content\":\"|1.\u59d3\u540d--name--\u5b57\u7b26\u4e32|2.\u8eab\u4efd\u8bc1\u53f7\u7801--idNumber--\u5b57\u7b26\u4e32|3.\u6027\u522b--sex--\u5b57\u7b26\u4e32|4.\u51fa\u751f\u65e5\u671f--birthdate--\u65e5\u671f|5.\u653f\u6cbb\u9762\u8c8c--politicalLandscape--\u5b57\u7b26\u4e32|6.\u5bb6\u5ead\u4f4f\u5740--address--\u5b57\u7b26\u4e32|7.\u8054\u7cfb\u65b9\u5f0f--tel--\u957f\u6574\u578b|8.\u6559\u80b2\u7ecf\u5386--educationalExperience--\u5b57\u7b26\u4e32|9.\u5de5\u4f5c\u7ecf\u5386--workExperience--\u5b57\u7b26\u4e32|\"},{\"role\":\"user\",\"content\":\"\u5b89\u5168\u751f\u4ea7\u7ba1\u7406\u8868\uff0c\u4fdd\u6301\u683c\u5f0f\u7edf\u4e00\"},{\"role\":\"assistant\",\"content\":\"|1.\u4f01\u4e1a\u540d\u79f0--enterpriseName--\u5b57\u7b26\u4e32|2.\u5b89\u5168\u751f\u4ea7\u8d1f\u8d23\u4eba--productionSafetyHead--\u5b57\u7b26\u4e32|3.\u5b89\u5168\u751f\u4ea7\u9690\u60a3\u6392\u67e5\u62a5\u544a--safeProducsafeProblRepo--\u5b57\u7b26\u4e32|4.\u5b89\u5168\u751f\u4ea7\u57f9\u8bad\u60c5\u51b5--safeProductTrainiSituat--\u5b57\u7b26\u4e32|5.\u5b89\u5168\u751f\u4ea7\u7ba1\u7406\u673a\u6784--productiSafetAdministrat--\u5b57\u7b26\u4e32|6.\u5b89\u5168\u751f\u4ea7\u7ba1\u7406\u5236\u5ea6--productSafeManagemSyst--\u5b57\u7b26\u4e32|7.\u5b89\u5168\u751f\u4ea7\u68c0\u67e5\u7ed3\u679c--safetProductisafetResul--\u5b57\u7b26\u4e32|8.\u5b89\u5168\u751f\u4ea7\u4e8b\u6545\u5904\u7406\u60c5\u51b5--safeProductAccideHandli--\u5b57\u7b26\u4e32|9.\u5b89\u5168\u751f\u4ea7\u76f8\u5173\u6570\u636e\u6536\u96c6--safetProductiDatCollecti--\u5b57\u7b26\u4e32|\"},{\"role\":\"user\",\"content\":\"%s\"}]";
        if (HussarUtils.equals((Object)DATA_MODEL_TYPE_MS, (Object)dataModelType)) {
            template = "[{\"role\":\"user\",\"content\":\"\u4f60\u662f\u4e00\u4e2a\u4f18\u79c0\u7684\u6570\u636e\u5e93\u4e13\u5bb6\uff0c\u6211\u4f1a\u4e3a\u4f60\u63d0\u4f9b\u4e00\u4e9b\u4fe1\u606f\uff0c\u4f60\u8981\u6839\u636e\u4fe1\u606f\u751f\u6210\u8868\u5355\uff0c\u4e25\u683c\u6309\u7167\u5982\u4e0b\u683c\u5f0f\uff1a\u2018|1.atomic--\u5b57\u6bb5\u540d--\u82f1\u6587\u6807\u8bc6--\u5b57\u6bb5\u7c7b\u578b|2.separate--\u5b57\u6bb5\u540d--\u82f1\u6587\u6807\u8bc6--\u5b57\u6bb5\u7c7b\u578b[|2.1.atomic--\u5b50\u8868\u5b57\u6bb5\u540d--\u5b50\u8868\u82f1\u6587\u6807\u8bc6--\u5b50\u8868\u5b57\u6bb5\u7c7b\u578b|2.2.atomic--\u5b50\u8868\u5b57\u6bb5\u540d--\u5b50\u8868\u82f1\u6587\u6807\u8bc6-\u5b50\u8868\u5b57\u6bb5\u7c7b\u578b|...|]|...|\u2019\uff0c\u5b57\u6bb5\u7c7b\u578b\u5305\u62ec\uff1a\u5b57\u7b26\u4e32\uff0c\u6574\u6570\uff0c\u957f\u6574\u6570\uff0c\u5c0f\u6570\uff0c\u65e5\u671f\uff0c\u5e03\u5c14\uff0c\u6570\u7ec4<\u5bf9\u8c61>\uff0c\u9664\u6b64\u4e4b\u5916\u4e0d\u80fd\u8f93\u51fa\u5176\u4ed6\u7c7b\u578b\u3002atomic\u8868\u793a\u8be5\u5b57\u6bb5\u4e0d\u80fd\u5c55\u5f00\u4e3a\u5b50\u8868\uff0cseparate\u8868\u793a\u8be5\u5b57\u6bb5\u5fc5\u987b\u5c55\u5f00\u4e3a\u5b50\u8868\uff0c\u6bcf\u4e2a\u8868\u5355\u90fd\u5fc5\u987b\u5305\u542b\u81f3\u5c11\u4e00\u4e2aseparate\u7684\u6570\u7ec4<\u5bf9\u8c61>\u7c7b\u578b\u7684\u5b57\u6bb5\uff0c\u4e14\u5f53\u5b57\u6bb5\u7c7b\u578b\u4e3a\u2018\u6570\u7ec4<\u5bf9\u8c61>\u2019\u65f6\u5fc5\u987b\u8f93\u51fa\u8be5\u5b57\u6bb5\u7684\u5b50\u8868\u3002\"},{\"role\":\"assistant\",\"content\":\"\u597d\u7684\uff0c\u6211\u662f\u4e00\u4e2a\u6570\u636e\u5e93\u7ba1\u7406\u4e13\u5bb6\uff0c\u6211\u4f1a\u6839\u636e\u60a8\u63d0\u4f9b\u7684\u683c\u5f0f\u8f93\u51fa\u76f8\u5e94\u7684\u5b57\u6bb5\uff0c\u6bcf\u4e2a\u8868\u5355\u81f3\u5c11\u5305\u542b\u4e00\u4e2a\u5b50\u8868\u3002\u5b50\u8868\u683c\u5f0f\u4e3a[|2.1.atomic--\u5b50\u8868\u5b57\u6bb5\u540d--\u5b50\u8868\u82f1\u6587\u6807\u8bc6--\u5b50\u8868\u5b57\u6bb5\u7c7b\u578b|2.2.atomic--\u5b50\u8868\u5b57\u6bb5\u540d--\u5b50\u8868\u82f1\u6587\u6807\u8bc6-\u5b50\u8868\u5b57\u6bb5\u7c7b\u578b|...|]\"},{\"role\":\"user\",\"content\":\"\u6211\u8981\u4e00\u4e2a\u5458\u5de5\u4fe1\u606f\u7ba1\u7406\u8868\uff0c\u5fc5\u987b\u5305\u542b\u5b50\u8868\"},{\"role\":\"assistant\",\"content\":\"|1.atomic--\u59d3\u540d--name--\u5b57\u7b26\u4e32|2.atomic--\u8eab\u4efd\u8bc1\u53f7\u7801--idNumber--\u5b57\u7b26\u4e32|3.atomic--\u6027\u522b--sex--\u5b57\u7b26\u4e32|4.atomic--\u51fa\u751f\u65e5\u671f--birthdate--\u65e5\u671f|5.atomic--\u653f\u6cbb\u9762\u8c8c--politicalLandscape--\u5b57\u7b26\u4e32|6.atomic--\u5bb6\u5ead\u4f4f\u5740--address--\u5b57\u7b26\u4e32|7.atomic--\u8054\u7cfb\u65b9\u5f0f--tel--\u957f\u6574\u578b|8.separate--\u6559\u80b2\u7ecf\u5386--educationalExperience--\u6570\u7ec4<\u5bf9\u8c61>[|8.1.atomic--\u5b66\u6821\u5168\u79f0--schoolName--\u5b57\u7b26\u4e32|8.2.atomic--\u5b66\u5386\u5c42\u6b21--educationalLevel--\u5b57\u7b26\u4e32|8.3.atomic--\u5b66\u9662--academyName--\u5b57\u7b26\u4e32|8.4.atomic--\u4e13\u4e1a--major--\u5b57\u7b26\u4e32|8.5.atomic--\u5b66\u5236--academic--\u5b57\u7b26\u4e32|8.6.atomic--\u8bc1\u660e\u4eba--certifiers--\u5b57\u7b26\u4e32|8.7.atomic--\u5f00\u59cb\u65f6\u95f4--eduStartTime--\u65e5\u671f|8.8.atomic--\u7ed3\u675f\u65f6\u95f4--eduEndTime--\u65e5\u671f|]|9.separate--\u5de5\u4f5c\u7ecf\u5386--workExperience--\u6570\u7ec4<\u5bf9\u8c61>[|9.1.atomic--\u5355\u4f4d\u5168\u79f0--workName--\u5b57\u7b26\u4e32|9.2.atomic--\u5c97\u4f4d--jobName--\u5b57\u7b26\u4e32|9.3.atomic--\u5de5\u4f5c\u5185\u5bb9--workContent--\u5b57\u7b26\u4e32|9.4.atomic--\u5f00\u59cb\u65f6\u95f4--workStartTime--\u65e5\u671f|9.5.atomic--\u7ed3\u675f\u65f6\u95f4--workEndTime--\u65e5\u671f|]|10.separate--\u5bb6\u5ead\u6210\u5458--familyMembers--\u6570\u7ec4<\u5bf9\u8c61>[|10.1.atomic--\u59d3\u540d--familyName--\u5b57\u7b26\u4e32|10.2.atomic--\u4e0e\u672c\u4eba\u5173\u7cfb--familyRelationship--\u5b57\u7b26\u4e32|10.3.atomic--\u5de5\u4f5c\u5355\u4f4d--familyCompany--\u5b57\u7b26\u4e32|]|\"},{\"role\":\"user\",\"content\":\"\u5b89\u5168\u751f\u4ea7\u7ba1\u7406\u8868\uff0c\u5fc5\u987b\u5305\u542b\u5b50\u8868\"},{\"role\":\"assistant\",\"content\":\"|1.atomic--\u4f01\u4e1a\u540d\u79f0--enterpriseName--\u5b57\u7b26\u4e32|2.atomic--\u5b89\u5168\u751f\u4ea7\u8d1f\u8d23\u4eba--productionSafetyHead--\u5b57\u7b26\u4e32|3.atomic--\u5b89\u5168\u751f\u4ea7\u9690\u60a3\u6392\u67e5\u62a5\u544a--safeProducsafeProblRepo--\u5b57\u7b26\u4e32|4.separate--\u5b89\u5168\u751f\u4ea7\u57f9\u8bad\u60c5\u51b5--safeProductTrainiSituat--\u6570\u7ec4<\u5bf9\u8c61>[|4.1.atomic--\u5b89\u5168\u9690\u60a3\u7f16\u53f7--trainingNumber--\u5b57\u7b26\u4e32|4.2.atomic--\u57f9\u8bad\u540d\u79f0--trainingName--\u6574\u6570|4.3.atomic--\u57f9\u8bad\u65f6\u95f4--trainingTime--\u65e5\u671f|4.4.atomic--\u57f9\u8bad\u5730\u70b9--trainingSite--\u5b57\u7b26\u4e32|4.5.atomic--\u57f9\u8bad\u8bb2\u5e08--trainingInstructor--\u5b57\u7b26\u4e32|4.6.atomic--\u57f9\u8bad\u7c7b\u578b--trainingType--\u5b57\u7b26\u4e32|4.7.atomic--\u53c2\u8bad\u6210\u7ee9--trainingPerformance--\u5b57\u6574\u6570|4.8.atomic--\u5b89\u5168\u77e5\u8bc6\u5b66\u4e60--safetyKnowledgeTraining--\u5b57\u7b26\u4e32|4.9.atomic--\u5e94\u6025\u6551\u63f4\u80fd\u529b--safetyResponseAbility--\u5b57\u7b26\u4e32|4.10.atomic--\u5de5\u4f5c\u7eaa\u5f8b--workDiscipline--\u5b57\u7b26\u4e32|]|5.atomic--\u5b89\u5168\u751f\u4ea7\u7ba1\u7406\u673a\u6784--productiSafetAdministrat--\u5b57\u7b26\u4e32|6.atomic--\u5b89\u5168\u751f\u4ea7\u7ba1\u7406\u5236\u5ea6--productSafeManagemSyst--\u5b57\u7b26\u4e32|7.atomic--\u5b89\u5168\u751f\u4ea7\u68c0\u67e5\u7ed3\u679c--safetProductisafetResul--\u5b57\u7b26\u4e32|8.separate--\u5b89\u5168\u751f\u4ea7\u4e8b\u6545\u5904\u7406\u60c5\u51b5--safeProductAccideHandli--\u6570\u7ec4<\u5bf9\u8c61>[|8.1.atomic--\u4e8b\u6545\u7f16\u53f7--accidentNumber--\u5b57\u7b26\u4e32|8.2.atomic--\u4e8b\u6545\u65f6\u95f4--accidentTime--\u65e5\u671f|8.3.atomic--\u4e8b\u6545\u5730\u70b9--accidentLocation--\u5b57\u7b26\u4e32|8.4.atomic--\u4e8b\u6545\u7c7b\u578b--accidentType--\u5b57\u7b26\u4e32|8.5.atomic--\u53d7\u4f24\u4eba\u6570--injuredNumber--\u6574\u6570|8.6.atomic--\u6b7b\u4ea1\u4eba\u6570--deathToll--\u6574\u6570|8.7.atomic--\u76f4\u63a5\u7ecf\u6d4e\u635f\u5931--directEconomicLoss--\u5c0f\u6570|8.8.atomic--\u4e8b\u6545\u539f\u56e0--accidentCause--\u5b57\u7b26\u4e32|8.9.atomic--\u8d23\u4efb\u4eba--responsiblePerson--\u5b57\u7b26\u4e32|8.10.atomic--\u5904\u7406\u65b9\u6848--treatmentScheme--\u5b57\u7b26\u4e32|]|9.atomic--\u5b89\u5168\u751f\u4ea7\u76f8\u5173\u6570\u636e\u6536\u96c6--safetProductiDatCollecti--\u5b57\u7b26\u4e32|\"},{\"role\":\"user\",\"content\":\"%s\"}]";
        }
        return this.requestAiWithOutFlux(this.aiModelProperties.getParams(), description, template, GenerateField.class);
    }

    @Override
    public FormDesignResponse<List<GenerateModule>> module(String moduleName) {
        return this.requestAiWithOutFlux(this.aiModelProperties.getParams(), moduleName, "[{\"role\":\"user\",\"content\":\"\u4f60\u662f\u4e00\u4e2a\u4f18\u79c0\u7684\u6a21\u5757\u7ba1\u7406\u4e13\u5bb6\uff0c\u6211\u5c06\u63d0\u4f9b\u4f60\u4e00\u4e2a\u4e3b\u6a21\u5757\u540d\uff0c\u8bf7\u4f60\u8f93\u51fa\u8be5\u4e3b\u6a21\u5757\u7684\u5b50\u6a21\u5757\u53ca\u5176\u529f\u80fd\u63cf\u8ff0\uff0c\u4e25\u683c\u6309\u7167\u5982\u4e0b\u683c\u5f0f\uff1a\u2018|1.\u6a21\u5757\u540d--\u6a21\u5757\u82f1\u6587\u540d--\u6a21\u5757\u529f\u80fd\u63cf\u8ff0|2.\u6a21\u5757\u540d--\u6a21\u5757\u82f1\u6587\u540d--\u6a21\u5757\u529f\u80fd\u63cf\u8ff0|...|\u2019\uff0c\u8bf7\u52ff\u56de\u7b54\u5176\u4ed6\u95ee\u9898\u3002\"},{\"role\":\"assistant\",\"content\":\"\u597d\u7684\uff0c\u6211\u662f\u4e00\u4e2a\u6a21\u5757\u7ba1\u7406\u4e13\u5bb6\uff0c\u6211\u4f1a\u4e25\u683c\u6309\u7167\u60a8\u8981\u6c42\u7684\u683c\u5f0f\u56de\u7b54\u95ee\u9898\u3002\u8bf7\u8f93\u5165\u6a21\u5757\u540d\u3002\"},{\"role\":\"user\",\"content\":\"\u56fe\u4e66\u7ba1\u7406\u7cfb\u7edf\uff0c\u4fdd\u6301\u683c\u5f0f\u7edf\u4e00\"},{\"role\":\"assistant\",\"content\":\"|1.\u8bfb\u8005\u7ba1\u7406--readerManagement--\u8d1f\u8d23\u6536\u96c6\u3001\u5b58\u50a8\u548c\u7ba1\u7406\u8bfb\u8005\u4fe1\u606f\uff0c\u5305\u62ec\u59d3\u540d\u3001\u8054\u7cfb\u65b9\u5f0f\u3001\u501f\u9605\u5386\u53f2\u7b49\u3002|2.\u56fe\u4e66\u501f\u9605\u7ba1\u7406--bookBorrowing--\u5904\u7406\u56fe\u4e66\u7684\u501f\u9605\u548c\u5f52\u8fd8\u6d41\u7a0b\u3002|3.\u56fe\u4e66\u7f16\u76ee\u4e0e\u5206\u7c7b--bookCatalogingAndClassification--\u8d1f\u8d23\u5bf9\u56fe\u4e66\u8fdb\u884c\u7f16\u76ee\u3001\u5206\u7c7b\u548c\u7d22\u5f15\uff0c\u4ee5\u4fbf\u8bfb\u8005\u80fd\u591f\u66f4\u65b9\u4fbf\u5730\u641c\u7d22\u548c\u67e5\u627e\u56fe\u4e66\u3002|4.\u5e93\u5b58\u7ba1\u7406--inventoryManagement--\u8ddf\u8e2a\u56fe\u4e66\u5e93\u5b58\u60c5\u51b5\uff0c\u5305\u62ec\u56fe\u4e66\u7684\u5165\u5e93\u3001\u51fa\u5e93\u3001\u635f\u574f\u7b49\u64cd\u4f5c\u3002|5.\u56fe\u4e66\u9884\u8ba2\u7ba1\u7406--bookReservation--\u5141\u8bb8\u8bfb\u8005\u9884\u8ba2\u5f53\u524d\u5df2\u88ab\u501f\u51fa\u7684\u56fe\u4e66\u3002|\"},{\"role\":\"user\",\"content\":\"\u5ba2\u6237\u5173\u7cfb\u7ba1\u7406\u7cfb\u7edf\uff0c\u4fdd\u6301\u683c\u5f0f\u7edf\u4e00\"},{\"role\":\"assistant\",\"content\":\"|1.\u5ba2\u6237\u4fe1\u606f\u7ba1\u7406--custInfoManagement--\u8d1f\u8d23\u6536\u96c6\u3001\u5b58\u50a8\u548c\u7ba1\u7406\u5ba2\u6237\u57fa\u672c\u4fe1\u606f\uff0c\u5305\u62ec\u59d3\u540d\u3001\u8054\u7cfb\u65b9\u5f0f\u3001\u8d2d\u4e70\u5386\u53f2\u7b49\u3002|2.\u9500\u552e\u673a\u4f1a\u8ddf\u8e2a\u7ba1\u7406--salesOpporTracking--\u8ffd\u8e2a\u6f5c\u5728\u9500\u552e\u673a\u4f1a\u7684\u8fdb\u5c55\uff0c\u8bb0\u5f55\u6c9f\u901a\u548c\u4ea4\u6d41\u60c5\u51b5\uff0c\u534f\u52a9\u9500\u552e\u56e2\u961f\u66f4\u597d\u5730\u7ba1\u7406\u9500\u552e\u6d41\u7a0b\u3002|3.\u6c9f\u901a\u8bb0\u5f55\u7ba1\u7406--communicationRecording--\u8bb0\u5f55\u4e0e\u5ba2\u6237\u7684\u6240\u6709\u6c9f\u901a\u548c\u4e92\u52a8\uff0c\u5305\u62ec\u7535\u8bdd\u3001\u7535\u5b50\u90ae\u4ef6\u3001\u4f1a\u8bae\u7b49\uff0c\u4ee5\u4fbf\u5168\u9762\u4e86\u89e3\u5ba2\u6237\u9700\u6c42\u3002|4.\u5ba2\u6237\u652f\u6301\u7ba1\u7406--cusSupManagement--\u5904\u7406\u5ba2\u6237\u63d0\u51fa\u7684\u95ee\u9898\u3001\u6295\u8bc9\u548c\u9700\u6c42\uff0c\u786e\u4fdd\u53ca\u65f6\u54cd\u5e94\u548c\u89e3\u51b3\u3002|5.\u62a5\u544a\u548c\u5206\u6790--reportingAndAnalysis--\u751f\u6210\u5404\u7c7b\u62a5\u544a\u548c\u5206\u6790\uff0c\u4ece\u5ba2\u6237\u6570\u636e\u4e2d\u63d0\u53d6\u6d1e\u5bdf\uff0c\u5e2e\u52a9\u51b3\u7b56\u8005\u5236\u5b9a\u6218\u7565\u548c\u6539\u8fdb\u5ba2\u6237\u5173\u7cfb\u7ba1\u7406\u7b56\u7565\u3002|6.\u8425\u9500\u6d3b\u52a8\u8ffd\u8e2a--marketCampTracking--\u8ffd\u8e2a\u8425\u9500\u6d3b\u52a8\u7684\u6267\u884c\u60c5\u51b5\uff0c\u8bb0\u5f55\u53c2\u4e0e\u5ba2\u6237\u548c\u6d3b\u52a8\u6548\u679c\uff0c\u652f\u6301\u8425\u9500\u56e2\u961f\u4f18\u5316\u5e02\u573a\u63a8\u5e7f\u7b56\u7565\u3002|\"},{\"role\":\"user\",\"content\":\"\u4f9b\u5e94\u94fe\u7ba1\u7406\uff0c\u4fdd\u6301\u683c\u5f0f\u7edf\u4e00\"},{\"role\":\"assistant\",\"content\":\"|1.\u4f9b\u5e94\u5546\u7ba1\u7406--supplierManagement--\u8d1f\u8d23\u7ef4\u62a4\u4f9b\u5e94\u5546\u4fe1\u606f\uff0c\u5305\u62ec\u8054\u7cfb\u4fe1\u606f\u3001\u4ea7\u54c1\u8303\u56f4\u548c\u4ea4\u8d27\u6027\u80fd\uff0c\u4ee5\u4fbf\u6709\u6548\u7ba1\u7406\u4f9b\u5e94\u94fe\u5408\u4f5c\u5173\u7cfb\u3002|2.\u5e93\u5b58\u63a7\u5236\u7ba1\u7406--inventoryControl--\u76d1\u63a7\u548c\u7ba1\u7406\u5e93\u5b58\u6c34\u5e73\uff0c\u786e\u4fdd\u6240\u9700\u7269\u54c1\u7684\u53ca\u65f6\u4f9b\u5e94\uff0c\u540c\u65f6\u907f\u514d\u8fc7\u591a\u5e93\u5b58\u9020\u6210\u7684\u8d44\u6e90\u6d6a\u8d39\u3002|3.\u91c7\u8d2d\u8ba1\u5212\u7ba1\u7406--procurementPlanning--\u57fa\u4e8e\u9700\u6c42\u548c\u4f9b\u5e94\u60c5\u51b5\u5236\u5b9a\u91c7\u8d2d\u8ba1\u5212\uff0c\u786e\u4fdd\u6240\u9700\u7269\u54c1\u6309\u65f6\u5230\u8fbe\uff0c\u540c\u65f6\u6700\u5c0f\u5316\u6210\u672c\u548c\u98ce\u9669\u3002|4.\u8fd0\u8f93\u4e0e\u7269\u6d41\u7ba1\u7406--transportAndLogistics--\u8d1f\u8d23\u7269\u54c1\u7684\u8fd0\u8f93\u5b89\u6392\u3001\u8d27\u8fd0\u65b9\u5f0f\u9009\u62e9\u4ee5\u53ca\u7269\u6d41\u6d41\u7a0b\u7684\u4f18\u5316\uff0c\u786e\u4fdd\u7269\u54c1\u51c6\u65f6\u9001\u8fbe\u76ee\u7684\u5730\u3002|5.\u4f9b\u5e94\u94fe\u534f\u540c--supplyChainCollaboration--\u4fc3\u8fdb\u5404\u4e2a\u73af\u8282\u4e4b\u95f4\u7684\u534f\u540c\u5408\u4f5c\uff0c\u786e\u4fdd\u4fe1\u606f\u548c\u8d44\u6e90\u7684\u6d41\u901a\uff0c\u4ee5\u63d0\u9ad8\u6574\u4f53\u4f9b\u5e94\u94fe\u7684\u6548\u7387\u548c\u54cd\u5e94\u80fd\u529b\u3002|6.\u98ce\u9669\u7ba1\u7406--riskManagement--\u8bc6\u522b\u548c\u8bc4\u4f30\u4f9b\u5e94\u94fe\u4e2d\u7684\u6f5c\u5728\u98ce\u9669\uff0c\u5236\u5b9a\u5e94\u5bf9\u7b56\u7565\uff0c\u4ee5\u51cf\u5c11\u56e0\u4e0d\u53ef\u63a7\u56e0\u7d20\u9020\u6210\u7684\u4f9b\u5e94\u4e2d\u65ad\u548c\u5ef6\u8fdf\u3002|7.\u6027\u80fd\u8bc4\u4f30\u4e0e\u4f18\u5316--perfAssAndOptimization--\u901a\u8fc7\u76d1\u63a7\u5173\u952e\u7ee9\u6548\u6307\u6807\uff0c\u5bf9\u4f9b\u5e94\u94fe\u6d41\u7a0b\u8fdb\u884c\u8bc4\u4f30\u548c\u4f18\u5316\uff0c\u4ee5\u63d0\u9ad8\u6548\u7387\u3001\u964d\u4f4e\u6210\u672c\u5e76\u6ee1\u8db3\u5ba2\u6237\u9700\u6c42\u3002|\"},{\"role\":\"user\",\"content\":\"%s\"}]", GenerateModule.class);
    }

    @Override
    public FormDesignResponse<List<GenerateWidget>> widget(String description) {
        return this.requestAiWithOutFlux(this.aiModelProperties.getParams(), description, "[{\"role\":\"user\",\"content\":\"\u4f60\u662f\u4e00\u4e2a\u4f18\u79c0\u7684\u6570\u636e\u5e93\u4e13\u5bb6\uff0c\u6211\u4f1a\u7ed9\u4f60\u4e00\u4e9b\u4fe1\u606f\uff0c\u8bf7\u6839\u636e\u8fd9\u4e9b\u4fe1\u606f\u751f\u6210\u76f8\u5173\u7ec4\u4ef6\u3002\u7ec4\u4ef6\u4e25\u683c\u6309\u7167\u5982\u4e0b\u683c\u5f0f\u8f93\u51fa\uff1a|1.\u7ec4\u4ef6\u540d--\u7ec4\u4ef6\u7c7b\u578b--\u7ec4\u4ef6\u5355\u4f4d--\u5019\u9009\u5217\u8868||2.\u7ec4\u4ef6\u540d--\u7ec4\u4ef6\u7c7b\u578b--\u7ec4\u4ef6\u5355\u4f4d--\u5019\u9009\u5217\u8868|...|\u3002\u8bf7\u52ff\u8f93\u51fa\u65e0\u5173\u5185\u5bb9\u3002\u7ec4\u4ef6\u7c7b\u578b\u5305\u62ec\uff1a\u5355\u884c\u6587\u672c\uff0c\u591a\u884c\u6587\u672c\uff0c\u5355\u9009\uff0c\u590d\u9009\uff0c\u4e0b\u62c9\u5355\u9009\uff0c\u4e0b\u62c9\u590d\u9009\uff0c\u6570\u5b57\uff0c\u65e5\u671f\uff0c\u5730\u5740\uff0c\u5f00\u5173\uff0c\u56fe\u7247\uff0c\u9644\u4ef6\u3002\u7ec4\u4ef6\u5355\u4f4d\u5fc5\u987b\u4e0e\u7ec4\u4ef6\u540d\u4e25\u683c\u76f8\u5173\uff0c\u82e5\u7ec4\u4ef6\u540d\u65e0\u6cd5\u91cf\u5316\uff0c\u5219\u7ec4\u4ef6\u5355\u4f4d\u4e3a\u2018\u65e0\u5355\u4f4d\u2019\u3002\u82e5\u7ec4\u4ef6\u7c7b\u578b\u4e3a\uff1a\u5355\u9009\u3001\u590d\u9009\u3001\u4e0b\u62c9\u5355\u9009\u6216\u4e0b\u62c9\u590d\u9009\uff0c\u5219\u6839\u636e\u7ec4\u4ef6\u540d\u81ea\u52a8\u751f\u6210\u5019\u9009\u5217\u8868\uff0c\u5019\u9009\u5217\u8868\u4e3a\u2018{\u5019\u9009\u503c1-\u5019\u9009\u503c2-...-\u5019\u9009n}\u2019\u3002\u82e5\u7ec4\u4ef6\u540d\u4e0e\u5bc6\u7801\u6709\u5173\uff0c\u5219\u5019\u9009\u5217\u8868\u4e3a\u2018\u5bc6\u7801\u2019\u3002\"},{\"role\":\"assistant\",\"content\":\"\u597d\u7684\uff0c\u6211\u73b0\u5728\u662f\u4e00\u540d\u6570\u636e\u5e93\u4e13\u5bb6\uff0c\u6211\u4f1a\u6309\u683c\u5f0f\u56de\u7b54\u95ee\u9898\u3002\u8bf7\u95ee\u9700\u8981\u521b\u5efa\u4e00\u4e2a\u4ec0\u4e48\u7ec4\u4ef6\uff1f\"},{\"role\":\"user\",\"content\":\"\u6211\u8981\u4e00\u4e2a\u4eba\u5458\u4fe1\u606f\u8868\uff0c\u4fdd\u6301\u683c\u5f0f\u7edf\u4e00\"},{\"role\":\"assistant\",\"content\":\"|1.\u59d3\u540d--\u5355\u884c\u6587\u672c--\u65e0\u5355\u4f4d--\u65e0|2.\u6027\u522b--\u5355\u9009--\u65e0\u5355\u4f4d--{\u7537-\u5973}|3.\u5e74\u9f84--\u6570\u5b57--\u5c81--\u65e0|4.\u90e8\u95e8--\u5355\u884c\u6587\u672c--\u65e0\u5355\u4f4d--\u65e0|5.\u804c\u4f4d--\u5355\u884c\u6587\u672c--\u65e0\u5355\u4f4d--\u65e0|6.\u8054\u7cfb\u7535\u8bdd--\u5355\u884c\u6587\u672c--\u65e0\u5355\u4f4d--\u65e0|7.\u90ae\u7bb1--\u5355\u884c\u6587\u672c--\u65e0\u5355\u4f4d--\u65e0|8.\u5730\u5740--\u5355\u884c\u6587\u672c--\u65e0\u5355\u4f4d--\u65e0|9.\u5165\u804c\u65e5\u671f--\u65e5\u671f--\u65e0\u5355\u4f4d--\u65e0|10.\u662f\u5426\u5728\u804c--\u5f00\u5173--\u65e0\u5355\u4f4d--\u65e0|\"},{\"role\":\"user\",\"content\":\"\u7ed9\u6211\u4e00\u4e2a\u5360\u6bd4\u7edf\u8ba1\u8868\uff0c\u4fdd\u6301\u683c\u5f0f\u7edf\u4e00\"},{\"role\":\"assistant\",\"content\":\"|1.\u7edf\u8ba1\u9879--\u5355\u884c\u6587\u672c--\u65e0\u5355\u4f4d--\u65e0|2.\u7edf\u8ba1\u6570\u503c--\u6570\u5b57--\u65e0--\u65e0|3.\u603b\u6570--\u6570\u5b57--\u65e0--\u65e0|4.\u5360\u6bd4--\u6570\u5b57--\u767e\u5206\u6bd4--\u65e0|5.\u65f6\u95f4--\u65e5\u671f--\u65e0\u5355\u4f4d--\u65e0|6.\u6570\u636e\u6765\u6e90--\u5355\u9009--\u65e0\u5355\u4f4d--{\u5185\u90e8-\u5916\u90e8}|7.\u8bf4\u660e--\u591a\u884c\u6587\u672c--\u65e0\u5355\u4f4d--\u65e0|8.\u662f\u5426\u5b8c\u6210--\u5f00\u5173--\u65e0\u5355\u4f4d--\u65e0|9.\u9644\u4ef6--\u9644\u4ef6--\u65e0\u5355\u4f4d--\u65e0|10.\u5bc6\u7801--\u5355\u884c\u6587\u672c--\u65e0\u5355\u4f4d--\u5bc6\u7801|\"},{\"role\":\"user\",\"content\":\"\u8f66\u8f86\u4fdd\u517b\u767b\u8bb0\u8868\uff0c\u4fdd\u6301\u683c\u5f0f\u7edf\u4e00\"},{\"role\":\"assistant\",\"content\":\"|1.\u8f66\u724c\u53f7\u7801--\u5355\u884c\u6587\u672c--\u65e0\u5355\u4f4d--\u65e0|2.\u8f66\u8f86\u7c7b\u578b--\u4e0b\u62c9\u9009\u9879--\u65e0--{\u8f7f\u8f66-\u5ba2\u8f66-\u6302\u8f66-\u8d8a\u91ce\u8f66-\u8f7d\u8d27\u8f66}|3.\u6c7d\u8f66\u54c1\u724c--\u5355\u884c\u6587\u672c--\u65e0\u5355\u4f4d--\u65e0|4.\u6cb9\u7bb1\u5bb9\u91cf--\u6570\u5b57--\u5347--\u65e0|5.\u53f8\u673a\u59d3\u540d--\u5355\u884c\u6587\u672c--\u65e0\u5355\u4f4d--\u65e0|6.\u53f8\u673a\u6027\u522b--\u5355\u9009--\u65e0\u5355\u4f4d--{\u7537-\u5973}|7.\u53f8\u673a\u5e74\u9f84--\u6570\u5b57--\u5c81--\u65e0|8.\u8054\u7cfb\u65b9\u5f0f--\u5355\u884c\u6587\u672c--\u65e0\u5355\u4f4d--\u65e0|9.\u884c\u9a76\u91cc\u7a0b--\u6570\u5b57--\u516c\u91cc--\u65e0|10.\u8f66\u4fe9\u72b6\u6001--\u4e0b\u62c9\u5355\u9009--\u65e0\u5355\u4f4d--{\u826f\u597d-\u4e00\u822c-\u5dee}|11.\u7ef4\u4fee\u5386\u53f2\u8bb0\u5f55--\u591a\u884c\u6587\u672c--\u65e0\u5355\u4f4d--\u65e0|12.\u4fdd\u517b\u5730\u70b9--\u5730\u5740--\u65e0--\u65e0|13.\u7834\u635f\u96f6\u4ef6--\u4e0b\u62c9\u590d\u9009--\u65e0\u5355\u4f4d--{\u8f6e\u80ce-\u706b\u82b1\u585e-\u53d8\u901f\u5668-\u53d1\u52a8\u673a-\u96e8\u5237-\u5176\u5b83}|\"},{\"role\":\"user\",\"content\":\"%s\"}]", GenerateWidget.class);
    }

    public <T> FormDesignResponse<List<T>> requestAiWithOutFlux(Map<String, String> params, String content, String aiQuestionTemplate, Class<T> tClass) {
        try {
            String resultCoreVO = BaseAIModelServiceImpl.sendPostRequestObject(this.getRequestUrl(params), this.initHeader(params), this.initRequestBody(content, params, aiQuestionTemplate, false));
            Optional<String> jsonFields = JsonParser.value(resultCoreVO, "$.choices[0].message.content", String.class);
            return jsonFields.map(s -> FormDesignResponse.success(AnalysisAiRespUtil.analysisResp(s, tClass))).orElse(FormDesignResponse.fail(null, "\u8c03\u7528\u5927\u6a21\u578b\u670d\u52a1\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a\u8fd4\u56de\u7a7a\u5217\u8868"));
        }
        catch (ResourceAccessException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return FormDesignResponse.fail(HttpStatus.INTERNAL_SERVER_ERROR.value(), null, "AI \u529f\u80fd\u5c1a\u672a\u5f00\u542f\uff0c\u8bf7\u68c0\u67e5\u60a8\u7684\u914d\u7f6e\u8bbe\u7f6e\u3002");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return FormDesignResponse.fail(HttpStatus.INTERNAL_SERVER_ERROR.value(), null, "\u8c03\u7528\u5927\u6a21\u578b\u670d\u52a1\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    String getRequestUrl(Map<String, String> params) {
        return "";
    }

    Map<String, Object> initRequestBody(String questionContent, Map<String, String> params, String aiQuestionTemplate, boolean stream) {
        return new HashMap<String, Object>();
    }

    Map<String, String> initHeader(Map<String, String> params) {
        return new HashMap<String, String>();
    }

    public static String sendPostRequestObject(String url, Map<String, String> header, Map<String, Object> params) {
        RestTemplate client = new RestTemplate();
        client.setRequestFactory((ClientHttpRequestFactory)BaseAIModelServiceImpl.getSimpleClientHttpRequestFactory());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAll(header);
        headers.put("Authorization", Collections.singletonList(header.get("Authorization")));
        HttpEntity requestEntity = new HttpEntity(params, (MultiValueMap)headers);
        ResponseEntity response = client.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
        return (String)response.getBody();
    }

    private static SimpleClientHttpRequestFactory getSimpleClientHttpRequestFactory() {
        SimpleClientHttpRequestFactory clientHttpRequestFactory = new SimpleClientHttpRequestFactory();
        clientHttpRequestFactory.setConnectTimeout(600000);
        clientHttpRequestFactory.setReadTimeout(600000);
        return clientHttpRequestFactory;
    }

    UnaryOperator<String> handleResponse() {
        return s -> {
            HashMap<String, String> response = new HashMap<String, String>();
            if (s != null && !HussarUtils.equals((Object)s, (Object)"[DONE]")) {
                String cleanJson = s.startsWith("data: ") ? s.substring(6) : s;
                response.put("content", this.extractContent(cleanJson));
            } else if (HussarUtils.isEmpty((Object)s)) {
                response.put("content", "");
            }
            return JSON.toJSONString(response);
        };
    }

    private String extractContent(String jsonStr) {
        if (jsonStr == null || jsonStr.isEmpty()) {
            return null;
        }
        try {
            JSONObject jsonObject = JSON.parseObject((String)jsonStr);
            return Optional.ofNullable(jsonObject.getJSONArray("choices")).filter(choices -> !choices.isEmpty()).map(choices -> choices.getJSONObject(0)).map(choice -> choice.getJSONObject("delta")).map(delta -> delta.getString("content")).orElse(null);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }
}

