/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.fusion.controller;

import com.jxdinfo.hussar.ai.fusion.model.GenerateField;
import com.jxdinfo.hussar.ai.fusion.model.GenerateModule;
import com.jxdinfo.hussar.ai.fusion.service.AIFormDesignService;
import com.jxdinfo.hussar.ai.fusion.service.AIModelService;
import com.jxdinfo.hussar.ai.fusion.util.FormDesignResponse;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/formdesign/ai/lowcode"})
public class AILowCodeModelController {
    @Resource
    private AIFormDesignService aiFormDesignService;
    @Resource
    private AIModelService aiModelService;

    @GetMapping(value={"/enabled"})
    public FormDesignResponse<Boolean> enabled() {
        return this.aiFormDesignService.enabled();
    }

    @PostMapping(value={"/dataModel"})
    public FormDesignResponse<List<GenerateField>> dataModel(@RequestParam String description, @RequestParam String dataModelType) {
        FormDesignResponse<List<GenerateField>> formDesignResponse = this.aiModelService.dataModel(description, dataModelType);
        formDesignResponse.setErrorCode(200);
        return formDesignResponse;
    }

    @PostMapping(value={"/module"})
    public FormDesignResponse<List<GenerateModule>> module(@RequestParam String description) {
        FormDesignResponse<List<GenerateModule>> formDesignResponse = this.aiModelService.module(description);
        formDesignResponse.setErrorCode(200);
        return formDesignResponse;
    }
}

