/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.fusion.qa.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.ai.fusion.qa.dto.AiQuestionDto;
import com.jxdinfo.hussar.ai.fusion.qa.properties.AiQaProperties;
import com.jxdinfo.hussar.ai.fusion.qa.service.AiQaService;
import com.jxdinfo.hussar.ai.fusion.util.WebClientUtil;
import java.util.HashMap;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;

@Service
@ConditionalOnProperty(name={"hussar.ai.qa.mode"}, havingValue="jxd-zsk")
public class JxdZskServiceImpl
implements AiQaService {
    @Resource
    private AiQaProperties aiQaProperties;

    @Override
    public Flux<String> aiQa(AiQuestionDto aiQuestionDto) {
        JSONObject params = JSON.parseObject((String)this.aiQaProperties.getParams());
        String url = params.getString("url");
        HashMap<String, String> headers = new HashMap<String, String>();
        HashMap<String, String> requestBody = new HashMap<String, String>();
        requestBody.put("knowledge_base_name", params.getString("knowledge_base_name"));
        requestBody.put("top_k", params.getString("top_k"));
        requestBody.put("query", aiQuestionDto.getContent());
        requestBody.put("uid", aiQuestionDto.getUid());
        return WebClientUtil.requestStreamFlux(url, headers, requestBody);
    }

    @Override
    public String handleResponse(String s) {
        HashMap<String, String> response = new HashMap<String, String>();
        String cleanJson = s.startsWith("data:") ? s.substring(5) : s;
        String content = JSON.parseObject((String)cleanJson).getString("message");
        response.put("content", content);
        return "data:" + JSON.toJSONString(response);
    }
}

