/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.fusion.qa.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.ai.fusion.qa.dto.AiQuestionDto;
import com.jxdinfo.hussar.ai.fusion.qa.properties.AiQaProperties;
import com.jxdinfo.hussar.ai.fusion.qa.service.AiQaService;
import com.jxdinfo.hussar.ai.fusion.util.WebClientUtil;
import java.util.HashMap;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;

@Service
@ConditionalOnProperty(name={"hussar.ai.qa.mode"}, havingValue="jxd-ds")
public class JxdDsServiceImpl
implements AiQaService {
    @Resource
    private AiQaProperties aiQaProperties;

    @Override
    public Flux<String> aiQa(AiQuestionDto aiQuestionDto) {
        JSONObject params = JSON.parseObject((String)this.aiQaProperties.getParams());
        String url = params.getString("url");
        HashMap<String, String> headers = new HashMap<String, String>();
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("content", aiQuestionDto.getContent());
        requestBody.put("stream", true);
        return WebClientUtil.requestStreamFlux(url, headers, requestBody);
    }

    @Override
    public String handleResponse(String s) {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("content", s);
        return "data:" + JSON.toJSONString(response);
    }
}

