/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.fusion.qa.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.ai.fusion.qa.dto.AiQuestionDto;
import com.jxdinfo.hussar.ai.fusion.qa.properties.AiQaProperties;
import com.jxdinfo.hussar.ai.fusion.qa.service.AiQaService;
import com.jxdinfo.hussar.ai.fusion.util.WebClientUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.HashMap;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;

@Service
@ConditionalOnProperty(name={"hussar.ai.qa.mode"}, havingValue="huawei-ds")
public class HuaWeiDsServiceImpl
implements AiQaService {
    @Resource
    private AiQaProperties aiQaProperties;

    @Override
    public Flux<String> aiQa(AiQuestionDto aiQuestionDto) {
        JSONObject params = JSON.parseObject((String)this.aiQaProperties.getParams());
        String url = params.getString("url");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Authorization", "Bearer " + params.getString("appKey"));
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("model", params.getString("model"));
        requestBody.put("max_tokens", params.getString("max_tokens"));
        requestBody.put("stream", true);
        requestBody.put("temperature", params.getString("temperature"));
        JSONArray messages = new JSONArray();
        JSONObject question = new JSONObject();
        question.put("role", (Object)"user");
        question.put("content", (Object)aiQuestionDto.getContent());
        messages.add((Object)question);
        requestBody.put("messages", messages);
        return WebClientUtil.requestStreamFlux(url, headers, requestBody);
    }

    @Override
    public String handleResponse(String s) {
        HashMap<String, String> response = new HashMap<String, String>();
        if (!HussarUtils.equals((Object)s, (Object)"[DONE]")) {
            String cleanJson = s.startsWith("data: ") ? s.substring(6) : s;
            response.put("content", this.extractContent(cleanJson));
        }
        return JSON.toJSONString(response);
    }

    private String extractContent(String jsonStr) {
        JSONObject delta;
        JSONObject firstChoice;
        JSONArray choices;
        JSONObject jsonObject = JSON.parseObject((String)jsonStr);
        if (jsonObject.containsKey((Object)"choices") && !(choices = jsonObject.getJSONArray("choices")).isEmpty() && (firstChoice = choices.getJSONObject(0)).containsKey((Object)"delta") && (delta = firstChoice.getJSONObject("delta")).containsKey((Object)"content")) {
            return delta.getString("content");
        }
        return null;
    }
}

