/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.agenda.service.impl;

import com.jxdinfo.hussar.agenda.dao.SysAgendaMapper;
import com.jxdinfo.hussar.agenda.enums.AgendaTipEnum;
import com.jxdinfo.hussar.agenda.model.SysAgenda;
import com.jxdinfo.hussar.agenda.service.ISysAgendaService;
import com.jxdinfo.hussar.agenda.vo.AgendaVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SysAgendaServiceImpl
extends HussarServiceImpl<SysAgendaMapper, SysAgenda>
implements ISysAgendaService {
    @Resource
    private SysAgendaMapper sysAgendaMapper;

    public List<AgendaVo> getAgendaInfo(String selectDate) {
        if (HussarUtils.isBlank((CharSequence)selectDate)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)AgendaTipEnum.AGENDA_DATA_EMPTY.getMessage()));
        }
        DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime selectDateStart = LocalDateTime.parse(selectDate, dateFormat);
        LocalDateTime selectDateEnd = selectDateStart.plusDays(1L);
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        assert (securityUser != null);
        List<AgendaVo> agendaVoList = this.sysAgendaMapper.getAgendaInfo(selectDateStart, selectDateEnd, securityUser.getUserId());
        for (AgendaVo agendaVo : agendaVoList) {
            String hourMinString = dateFormat.format(agendaVo.getStartTime());
            hourMinString = hourMinString.substring(11, 16);
            agendaVo.setHourMins(hourMinString);
        }
        return agendaVoList;
    }

    public Boolean addAgenda(SysAgenda agenda) {
        this.checkParameter(agenda);
        return this.save((BaseEntity)agenda);
    }

    public Boolean editAgenda(SysAgenda agenda) {
        if (HussarUtils.isEmpty((Object)agenda.getAgendaId())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)AgendaTipEnum.AGENDA_ID_EMPTY.getMessage()));
        }
        this.checkParameter(agenda);
        return this.updateById((BaseEntity)agenda);
    }

    public Boolean deleteAgenda(Long agendaId) {
        if (HussarUtils.isEmpty((Object)agendaId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)AgendaTipEnum.AGENDA_ID_EMPTY.getMessage()));
        }
        return this.removeById(agendaId);
    }

    public List<String> getMouthAgenda(String selectMouth) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime selectMouthDate = LocalDateTime.parse(selectMouth, formatter);
        LocalDateTime startTime = LocalDateTime.of(LocalDate.from(selectMouthDate.with(TemporalAdjusters.firstDayOfMonth())), LocalTime.MIN).plusDays(-7L);
        LocalDateTime endTime = LocalDateTime.of(LocalDate.from(selectMouthDate.with(TemporalAdjusters.lastDayOfMonth())), LocalTime.MAX).plusDays(14L);
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        assert (securityUser != null);
        List<AgendaVo> allAgendaList = this.sysAgendaMapper.getAgendaInfo(startTime, endTime, securityUser.getUserId());
        ArrayList<String> agendaDateList = new ArrayList();
        DateTimeFormatter formatterDay = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        for (AgendaVo agenda : allAgendaList) {
            String agendaDateString = formatterDay.format(agenda.getStartTime());
            agendaDateList.add(agendaDateString);
        }
        agendaDateList = agendaDateList.stream().distinct().collect(Collectors.toList());
        return agendaDateList;
    }

    private void checkParameter(SysAgenda agenda) {
        if (HussarUtils.isBlank((CharSequence)agenda.getAgendaTitle())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)AgendaTipEnum.AGENDA_TITLE_EMPTY.getMessage()));
        }
        if (HussarUtils.isEmpty((Object)agenda.getStartTime())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)AgendaTipEnum.AGENDA_START_TIME_EMPTY.getMessage()));
        }
        if (HussarUtils.isEmpty((Object)agenda.getEndTime())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)AgendaTipEnum.AGENDA_END_TIME_EMPTY.getMessage()));
        }
        if (agenda.getEndTime().isBefore(agenda.getStartTime())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)AgendaTipEnum.AGENDA_END_BEFORE_START.getMessage()));
        }
    }
}

