/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.advanced.components.unitselect.service.impl;

import com.jxdinfo.hussar.advanced.components.unitselect.dto.OrganUserIdDto;
import com.jxdinfo.hussar.advanced.components.unitselect.dto.UnitSelectSearchDto;
import com.jxdinfo.hussar.advanced.components.unitselect.service.UnitSelectService;
import com.jxdinfo.hussar.advanced.components.unitselect.vo.UnitSelectEchoVo;
import com.jxdinfo.hussar.authorization.organ.dto.SearchOrganUserDto;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganizationBoService;
import com.jxdinfo.hussar.authorization.organ.vo.OrganVo;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.permit.vo.OrganUserTreeVo;
import com.jxdinfo.hussar.authorization.permit.vo.UserOrganPostVo;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.advanced.components.unitselect.service.impl")
public class UnitSelectServiceImpl
implements UnitSelectService {
    @Autowired
    IHussarBaseOrganizationBoService hussarBaseOrganizationBoService;
    @Autowired
    IHussarBaseUserBoService hussarBaseUserBoService;

    @Override
    public List<UnitSelectEchoVo> echo(OrganUserIdDto organUserIdDto) {
        switch (organUserIdDto.getType()) {
            case 0: {
                return this.selectOrganByIds(organUserIdDto.getIds());
            }
            case 1: {
                return this.selectUserByIdAndOrgan(organUserIdDto.getIds());
            }
        }
        return new ArrayList<UnitSelectEchoVo>();
    }

    @Override
    public List<OrganUserTreeVo> lazyOrganUserTree(Long departmentId, Integer resultType) {
        return this.hussarBaseUserBoService.lazyOrganUserTree(Collections.singletonList(departmentId), Boolean.valueOf(false), resultType);
    }

    @Override
    public ApiResponse<Object> search(UnitSelectSearchDto searchDto) {
        PageInfo pageInfo = new PageInfo(searchDto.getCurrent().longValue(), searchDto.getSize().longValue());
        SearchOrganUserDto searchOrganUserDto = new SearchOrganUserDto();
        searchOrganUserDto.setName(searchDto.getKeyword());
        searchOrganUserDto.setResultType("2");
        switch (searchDto.getType()) {
            case 0: {
                return ApiResponse.success((Object)this.hussarBaseOrganizationBoService.searchOrgan(pageInfo, searchOrganUserDto));
            }
            case 1: {
                return ApiResponse.success((Object)this.hussarBaseUserBoService.searchUser(pageInfo, searchOrganUserDto));
            }
        }
        return ApiResponse.fail((String)"\u672a\u77e5\u7c7b\u578b");
    }

    public List<UnitSelectEchoVo> selectOrganByIds(List<Long> organIds) {
        ArrayList<UnitSelectEchoVo> unitSelectEchoVos = new ArrayList<UnitSelectEchoVo>();
        if (HussarUtils.isEmpty(organIds)) {
            return unitSelectEchoVos;
        }
        List organVos = this.hussarBaseOrganizationBoService.getSimpleOrganByIds(organIds);
        Map organVoMap = organVos.stream().collect(Collectors.toMap(OrganVo::getId, Function.identity()));
        for (Long organId : organIds) {
            OrganVo organVo = (OrganVo)organVoMap.get(String.valueOf(organId));
            if (HussarUtils.isEmpty((Object)organVo)) continue;
            UnitSelectEchoVo unitSelectEchoVo = new UnitSelectEchoVo(organVo.getLabel(), Long.parseLong(organVo.getId()));
            unitSelectEchoVos.add(unitSelectEchoVo);
        }
        return unitSelectEchoVos;
    }

    public List<UnitSelectEchoVo> selectUserByIdAndOrgan(List<Long> userIds) {
        ArrayList<UnitSelectEchoVo> unitSelectEchoVos = new ArrayList<UnitSelectEchoVo>();
        if (HussarUtils.isEmpty(userIds)) {
            return unitSelectEchoVos;
        }
        List userOrganPostVos = this.hussarBaseOrganizationBoService.getOrganByUserIds(userIds);
        HashMap<Long, UserOrganPostVo> userOrganMap = new HashMap<Long, UserOrganPostVo>();
        for (UserOrganPostVo userOrganPostVo : userOrganPostVos) {
            userOrganMap.put(userOrganPostVo.getUserId(), userOrganPostVo);
        }
        Map userInfo = this.hussarBaseUserBoService.getUserInfo(userIds);
        for (Long userId : userIds) {
            SysUsers sysUsers = (SysUsers)userInfo.get(userId);
            if (HussarUtils.isEmpty((Object)sysUsers)) continue;
            UnitSelectEchoVo unitSelectEchoVo = new UnitSelectEchoVo(sysUsers.getUserName(), sysUsers.getId());
            UserOrganPostVo userOrganPost = (UserOrganPostVo)userOrganMap.get(sysUsers.getId());
            if (HussarUtils.isNotEmpty((Object)userOrganPost)) {
                unitSelectEchoVo.setParentOrganId(userOrganPost.getStruId());
                unitSelectEchoVo.setParentOrganLabel(userOrganPost.getOrganName());
            }
            unitSelectEchoVos.add(unitSelectEchoVo);
        }
        return unitSelectEchoVos;
    }
}

