/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.advanced.components.unitselect.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.advanced.components.businessconfig.constant.BusinessConfigConstant;
import com.jxdinfo.hussar.advanced.components.businessconfig.constant.SceneType;
import com.jxdinfo.hussar.advanced.components.businessconfig.model.SysBusinessConfig;
import com.jxdinfo.hussar.advanced.components.businessconfig.service.SysBusinessConfigService;
import com.jxdinfo.hussar.advanced.components.unitselect.dao.SysCommonlyUsedMapper;
import com.jxdinfo.hussar.advanced.components.unitselect.dto.OrganUserIdDto;
import com.jxdinfo.hussar.advanced.components.unitselect.model.SysCommonlyUsed;
import com.jxdinfo.hussar.advanced.components.unitselect.service.SysCommonlyUsedService;
import com.jxdinfo.hussar.advanced.components.unitselect.service.UnitSelectService;
import com.jxdinfo.hussar.advanced.components.unitselect.vo.UnitSelectEchoVo;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.advanced.components.unitselect.service.impl.CommonlyUsedServiceImpl")
public class SysCommonlyUsedServiceImpl
extends HussarServiceImpl<SysCommonlyUsedMapper, SysCommonlyUsed>
implements SysCommonlyUsedService {
    @Autowired
    private SysBusinessConfigService businessConfigService;
    @Autowired
    private UnitSelectService unitSelectService;

    @Override
    public ApiResponse<Void> add(OrganUserIdDto organUserIdDto) {
        if (organUserIdDto.getType() == null) {
            return ApiResponse.fail((String)"\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.updateCommon(organUserIdDto);
        this.pushConfig(organUserIdDto.getType());
        return ApiResponse.success();
    }

    @Override
    public ApiResponse<List<UnitSelectEchoVo>> get(Integer type) {
        if (type == null) {
            return ApiResponse.fail((String)"\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<Long> ids = this.getSysIds(String.valueOf(type));
        HashSet<Long> idSet = new HashSet<Long>(ids);
        List<Long> commonIds = this.getUserIds(String.valueOf(type));
        for (Long commonId : commonIds) {
            if (!idSet.contains(commonId)) {
                ids.add(commonId);
            }
            if (ids.size() != 20) continue;
            break;
        }
        OrganUserIdDto organUserIdDto = new OrganUserIdDto();
        organUserIdDto.setType(type);
        organUserIdDto.setIds(ids);
        return ApiResponse.success(this.unitSelectService.echo(organUserIdDto));
    }

    private List<Long> getSysIds(String key) {
        SysBusinessConfig businessConfig = this.businessConfigService.get(BusinessConfigConstant.SYS, SceneType.COMMON_USE.getValue(), key);
        List<Long> ids = new ArrayList<Long>();
        if (HussarUtils.isNotEmpty((Object)((Object)businessConfig)) && HussarUtils.isNotBlank((CharSequence)businessConfig.getConfig())) {
            ids = JSON.parseArray((String)businessConfig.getConfig(), Long.class);
        }
        return ids;
    }

    private List<Long> getUserIds(String key) {
        SysBusinessConfig businessConfig = this.businessConfigService.get(BusinessConfigConstant.PERSONAL, SceneType.COMMON_USE.getValue(), key);
        List<Long> ids = new ArrayList<Long>();
        if (HussarUtils.isNotEmpty((Object)((Object)businessConfig)) && HussarUtils.isNotBlank((CharSequence)businessConfig.getConfig())) {
            ids = JSON.parseArray((String)businessConfig.getConfig(), Long.class);
        }
        return ids;
    }

    private void updateCommon(OrganUserIdDto organUserIdDto) {
        Long currentUserId = BaseSecurityUtil.getUser().getId();
        Integer type = organUserIdDto.getType();
        List<Long> ids = organUserIdDto.getIds();
        if (HussarUtils.isEmpty(ids) || HussarUtils.isEmpty((Object)type)) {
            return;
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        List editCommonlyUseds = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQueryWrapper.in(SysCommonlyUsed::getCommonId, ids)).eq(SysCommonlyUsed::getType, (Object)type)).eq(HussarBaseEntity::getCreator, (Object)currentUserId));
        HashMap<Long, SysCommonlyUsed> editCommonlyUsedMap = new HashMap<Long, SysCommonlyUsed>();
        for (SysCommonlyUsed editCommonlyUsed : editCommonlyUseds) {
            editCommonlyUsed.setCount(editCommonlyUsed.getCount() + 1);
            editCommonlyUsedMap.put(editCommonlyUsed.getCommonId(), editCommonlyUsed);
        }
        this.updateBatchById(editCommonlyUseds);
        ArrayList<SysCommonlyUsed> addCommonlyUseds = new ArrayList<SysCommonlyUsed>();
        for (Long id : ids) {
            if (!HussarUtils.isEmpty(editCommonlyUsedMap.get(id))) continue;
            SysCommonlyUsed addCommonlyUsed = new SysCommonlyUsed();
            addCommonlyUsed.setCommonId(id);
            addCommonlyUsed.setType(type);
            addCommonlyUsed.setCount(1);
            addCommonlyUseds.add(addCommonlyUsed);
        }
        this.saveBatch(addCommonlyUseds);
    }

    private void pushConfig(int type) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        Long currentUserId = BaseSecurityUtil.getUser().getId();
        Page pageInfo = new Page(1L, 20L);
        List sysCommonlyUseds = ((Page)this.page((IPage)pageInfo, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQueryWrapper.eq(SysCommonlyUsed::getType, (Object)type)).eq(HussarBaseEntity::getCreator, (Object)currentUserId)).orderByDesc(SysCommonlyUsed::getCount))).getRecords();
        this.saveOrUpdateConfig(type, sysCommonlyUseds);
    }

    void saveOrUpdateConfig(int type, List<SysCommonlyUsed> sysCommonlyUseds) {
        List ids = sysCommonlyUseds.stream().map(SysCommonlyUsed::getCommonId).collect(Collectors.toList());
        SysBusinessConfig sysBusinessConfig = this.businessConfigService.get(BusinessConfigConstant.PERSONAL, SceneType.COMMON_USE.getValue(), String.valueOf(type));
        if (HussarUtils.isEmpty((Object)((Object)sysBusinessConfig))) {
            sysBusinessConfig = new SysBusinessConfig();
            sysBusinessConfig.setName(SceneType.COMMON_USE.getType());
            sysBusinessConfig.setScene(SceneType.COMMON_USE.getValue());
            sysBusinessConfig.setConfigKey(String.valueOf(type));
            sysBusinessConfig.setType(BusinessConfigConstant.PERSONAL);
        }
        sysBusinessConfig.setConfig(JSON.toJSONString(ids));
        this.businessConfigService.saveOrUpdate((Object)sysBusinessConfig);
    }
}

