/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.advanced.components.queryconfig.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.advanced.components.businessconfig.constant.BusinessConfigConstant;
import com.jxdinfo.hussar.advanced.components.businessconfig.constant.SceneType;
import com.jxdinfo.hussar.advanced.components.businessconfig.model.SysBusinessConfig;
import com.jxdinfo.hussar.advanced.components.businessconfig.model.SysBusinessConfigSeq;
import com.jxdinfo.hussar.advanced.components.businessconfig.service.SysBusinessConfigService;
import com.jxdinfo.hussar.advanced.components.queryconfig.dto.QueryConfigSortDto;
import com.jxdinfo.hussar.advanced.components.queryconfig.model.QueryConfig;
import com.jxdinfo.hussar.advanced.components.queryconfig.model.QueryConfigSeq;
import com.jxdinfo.hussar.advanced.components.queryconfig.service.QueryConfigService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QueryConfigServiceImpl
implements QueryConfigService {
    @Autowired
    SysBusinessConfigService businessConfigService;

    @Override
    public ApiResponse<Long> addOrUpdate(QueryConfig queryConfig) {
        if (queryConfig == null) {
            return ApiResponse.fail((String)"\u65b0\u589e\u6216\u4fee\u6539\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<QueryConfig> queryConfigs = new ArrayList();
        SysBusinessConfig sysBusinessConfig = this.businessConfigService.get(queryConfig.isSys() ? BusinessConfigConstant.SYS : BusinessConfigConstant.PERSONAL, SceneType.CUSTOM_QUERY_CONFIG.getValue(), queryConfig.getInstantsKey());
        if (sysBusinessConfig == null) {
            sysBusinessConfig = new SysBusinessConfig();
            sysBusinessConfig.setName(SceneType.CUSTOM_QUERY_CONFIG.getType());
            sysBusinessConfig.setScene(SceneType.CUSTOM_QUERY_CONFIG.getValue());
            sysBusinessConfig.setType(queryConfig.isSys() ? BusinessConfigConstant.SYS : BusinessConfigConstant.PERSONAL);
            sysBusinessConfig.setConfigKey(queryConfig.getInstantsKey());
        }
        if (HussarUtils.isNotBlank((CharSequence)sysBusinessConfig.getConfig())) {
            queryConfigs = JSON.parseArray((String)sysBusinessConfig.getConfig(), QueryConfig.class);
        }
        QueryConfig config = null;
        for (QueryConfig queryConfig1 : queryConfigs) {
            if (!HussarUtils.equals((Object)queryConfig1.getId(), (Object)queryConfig.getId())) continue;
            config = queryConfig1;
            break;
        }
        if (config == null) {
            queryConfig.setId(IdWorker.getId((Object)queryConfig));
            queryConfigs.add(queryConfig);
            SysBusinessConfigSeq configSeq = new SysBusinessConfigSeq(queryConfig.getId(), queryConfig.getSeq());
            this.addSeq(configSeq, queryConfig.isSys(), queryConfig.getInstantsKey());
        } else {
            config.setCode(queryConfig.getCode());
            config.setName(queryConfig.getName());
            config.setIsDefault(queryConfig.getIsDefault());
            config.setSeq(queryConfig.getSeq());
            config.setValue(queryConfig.getValue());
        }
        sysBusinessConfig.setConfig(JSON.toJSONString(queryConfigs));
        this.businessConfigService.saveOrUpdate((Object)sysBusinessConfig);
        return ApiResponse.success((Object)queryConfig.getId());
    }

    @Override
    public List<QueryConfig> list(String instantsKey) {
        List<SysBusinessConfigSeq> sysConfigSeqs;
        List<SysBusinessConfigSeq> configSeqs;
        ArrayList<QueryConfig> endQueryConfigs = new ArrayList<QueryConfig>();
        List<QueryConfig> sysQueryConfigs = this.businessConfigService.getArray(BusinessConfigConstant.SYS, SceneType.CUSTOM_QUERY_CONFIG.getValue(), instantsKey, QueryConfig.class);
        HashMap<Long, QueryConfig> sysConfigMap = new HashMap<Long, QueryConfig>();
        for (QueryConfig sysQueryConfig : sysQueryConfigs) {
            sysConfigMap.put(sysQueryConfig.getId(), sysQueryConfig);
        }
        List<QueryConfig> userQueryConfigs = this.businessConfigService.getArray(BusinessConfigConstant.PERSONAL, SceneType.CUSTOM_QUERY_CONFIG.getValue(), instantsKey, QueryConfig.class);
        HashMap<Long, QueryConfig> userConfigMap = new HashMap<Long, QueryConfig>();
        for (QueryConfig queryConfig : userQueryConfigs) {
            userConfigMap.put(queryConfig.getId(), queryConfig);
        }
        QueryConfigSeq queryConfigSeq = this.businessConfigService.getObject(BusinessConfigConstant.PERSONAL, SceneType.CUSTOM_QUERY_CONFIG_SEQ.getValue(), instantsKey, QueryConfigSeq.class);
        if (HussarUtils.isEmpty((Object)queryConfigSeq)) {
            queryConfigSeq = new QueryConfigSeq();
        }
        if (HussarUtils.isEmpty(configSeqs = queryConfigSeq.getConfigSeq())) {
            configSeqs = new ArrayList<SysBusinessConfigSeq>();
        }
        Long defaultId = queryConfigSeq.getDefaultId();
        configSeqs.sort(Comparator.comparingInt(SysBusinessConfigSeq::getSeq));
        QueryConfigSeq sysQueryConfigSeq = this.businessConfigService.getObject(BusinessConfigConstant.SYS, SceneType.CUSTOM_QUERY_CONFIG_SEQ.getValue(), instantsKey, QueryConfigSeq.class);
        if (HussarUtils.isEmpty((Object)sysQueryConfigSeq)) {
            sysQueryConfigSeq = new QueryConfigSeq();
        }
        if (HussarUtils.isEmpty(sysConfigSeqs = sysQueryConfigSeq.getConfigSeq())) {
            sysConfigSeqs = new ArrayList<SysBusinessConfigSeq>();
        }
        if (HussarUtils.isEmpty((Object)defaultId)) {
            defaultId = sysQueryConfigSeq.getDefaultId();
        }
        sysConfigSeqs.sort(Comparator.comparingInt(SysBusinessConfigSeq::getSeq));
        for (SysBusinessConfigSeq configSeq : configSeqs) {
            QueryConfig queryConfig;
            if (HussarUtils.isNotEmpty(userConfigMap.get(configSeq.getConfigId()))) {
                queryConfig = (QueryConfig)userConfigMap.get(configSeq.getConfigId());
            } else {
                if (!HussarUtils.isNotEmpty(sysConfigMap.get(configSeq.getConfigId()))) continue;
                queryConfig = (QueryConfig)sysConfigMap.get(configSeq.getConfigId());
                sysConfigMap.remove(configSeq.getConfigId());
            }
            if (HussarUtils.equals((Object)defaultId, (Object)queryConfig.getId())) {
                queryConfig.setIsDefault("1");
            } else {
                queryConfig.setIsDefault("0");
            }
            queryConfig.setSeq(configSeq.getSeq());
            endQueryConfigs.add(queryConfig);
        }
        ArrayList<QueryConfig> queryConfigs = new ArrayList<QueryConfig>();
        for (SysBusinessConfigSeq sysConfigSeq : sysConfigSeqs) {
            QueryConfig sysQueryConfig = (QueryConfig)sysConfigMap.get(sysConfigSeq.getConfigId());
            if (!HussarUtils.isNotEmpty((Object)sysQueryConfig)) continue;
            if (HussarUtils.equals((Object)defaultId, (Object)sysQueryConfig.getId())) {
                sysQueryConfig.setIsDefault("1");
            } else {
                sysQueryConfig.setIsDefault("0");
            }
            queryConfigs.add(sysQueryConfig);
        }
        queryConfigs.addAll(endQueryConfigs);
        return queryConfigs;
    }

    void addSeq(SysBusinessConfigSeq configSeq, boolean sys, String instantsKey) {
        List<SysBusinessConfigSeq> configSeqs;
        QueryConfigSeq queryConfigSeq = new QueryConfigSeq();
        SysBusinessConfig sysBusinessConfig = this.businessConfigService.get(sys ? BusinessConfigConstant.SYS : BusinessConfigConstant.PERSONAL, SceneType.CUSTOM_QUERY_CONFIG_SEQ.getValue(), instantsKey);
        if (sysBusinessConfig == null) {
            sysBusinessConfig = new SysBusinessConfig();
            sysBusinessConfig.setName(SceneType.CUSTOM_QUERY_CONFIG_SEQ.getType());
            sysBusinessConfig.setScene(SceneType.CUSTOM_QUERY_CONFIG_SEQ.getValue());
            sysBusinessConfig.setType(sys ? BusinessConfigConstant.SYS : BusinessConfigConstant.PERSONAL);
            sysBusinessConfig.setConfigKey(instantsKey);
        }
        if (HussarUtils.isNotBlank((CharSequence)sysBusinessConfig.getConfig())) {
            queryConfigSeq = (QueryConfigSeq)JSON.parseObject((String)sysBusinessConfig.getConfig(), QueryConfigSeq.class);
        }
        if (HussarUtils.isEmpty(configSeqs = queryConfigSeq.getConfigSeq())) {
            configSeqs = new ArrayList<SysBusinessConfigSeq>();
        }
        configSeqs.add(configSeq);
        queryConfigSeq.setConfigSeq(configSeqs);
        sysBusinessConfig.setConfig(JSON.toJSONString((Object)queryConfigSeq));
        this.businessConfigService.saveOrUpdate((Object)sysBusinessConfig);
    }

    @Override
    public ApiResponse<Void> sort(QueryConfigSortDto queryConfigSortDto) {
        List<Long> ids = queryConfigSortDto.getIds();
        String instantsKey = queryConfigSortDto.getInstantsKey();
        ArrayList<SysBusinessConfigSeq> sysBusinessConfigSeqs = new ArrayList<SysBusinessConfigSeq>();
        for (int i = 0; i < ids.size(); ++i) {
            SysBusinessConfigSeq configSeq = new SysBusinessConfigSeq(ids.get(i), i);
            sysBusinessConfigSeqs.add(configSeq);
        }
        SysBusinessConfig sysBusinessConfig = this.businessConfigService.get(BusinessConfigConstant.PERSONAL, SceneType.CUSTOM_QUERY_CONFIG_SEQ.getValue(), instantsKey);
        if (sysBusinessConfig == null) {
            sysBusinessConfig = new SysBusinessConfig();
            sysBusinessConfig.setName(SceneType.CUSTOM_QUERY_CONFIG_SEQ.getType());
            sysBusinessConfig.setScene(SceneType.CUSTOM_QUERY_CONFIG_SEQ.getValue());
            sysBusinessConfig.setType(BusinessConfigConstant.PERSONAL);
            sysBusinessConfig.setConfigKey(instantsKey);
        }
        QueryConfigSeq queryConfigSeq = new QueryConfigSeq();
        if (HussarUtils.isNotBlank((CharSequence)sysBusinessConfig.getConfig())) {
            queryConfigSeq = (QueryConfigSeq)JSON.parseObject((String)sysBusinessConfig.getConfig(), QueryConfigSeq.class);
        }
        queryConfigSeq.setConfigSeq(sysBusinessConfigSeqs);
        sysBusinessConfig.setConfig(JSON.toJSONString((Object)queryConfigSeq));
        this.businessConfigService.saveOrUpdate((Object)sysBusinessConfig);
        return ApiResponse.success();
    }

    @Override
    public ApiResponse<Void> del(Long id, String instantsKey) {
        SysBusinessConfig sysBusinessConfig = this.businessConfigService.get(BusinessConfigConstant.PERSONAL, SceneType.CUSTOM_QUERY_CONFIG.getValue(), instantsKey);
        if (sysBusinessConfig == null || HussarUtils.isBlank((CharSequence)sysBusinessConfig.getConfig())) {
            return ApiResponse.fail((String)"\u8981\u5220\u9664\u7684\u914d\u7f6e\u4e0d\u5b58\u5728");
        }
        List queryConfigs = JSON.parseArray((String)sysBusinessConfig.getConfig(), QueryConfig.class);
        Iterator iterator = queryConfigs.iterator();
        while (iterator.hasNext()) {
            QueryConfig queryConfig = (QueryConfig)iterator.next();
            if (!HussarUtils.equals((Object)queryConfig.getId(), (Object)id)) continue;
            iterator.remove();
            break;
        }
        sysBusinessConfig.setConfig(JSON.toJSONString((Object)queryConfigs));
        this.businessConfigService.saveOrUpdate((Object)sysBusinessConfig);
        return ApiResponse.success();
    }

    @Override
    public ApiResponse<Void> setDefault(Long id, String instantsKey) {
        SysBusinessConfig sysBusinessConfig = this.businessConfigService.get(BusinessConfigConstant.PERSONAL, SceneType.CUSTOM_QUERY_CONFIG_SEQ.getValue(), instantsKey);
        if (sysBusinessConfig == null) {
            sysBusinessConfig = new SysBusinessConfig();
            sysBusinessConfig.setName(SceneType.CUSTOM_QUERY_CONFIG_SEQ.getType());
            sysBusinessConfig.setScene(SceneType.CUSTOM_QUERY_CONFIG_SEQ.getValue());
            sysBusinessConfig.setType(BusinessConfigConstant.PERSONAL);
            sysBusinessConfig.setConfigKey(instantsKey);
        }
        QueryConfigSeq queryConfigSeq = new QueryConfigSeq();
        if (HussarUtils.isNotBlank((CharSequence)sysBusinessConfig.getConfig())) {
            queryConfigSeq = (QueryConfigSeq)JSON.parseObject((String)sysBusinessConfig.getConfig(), QueryConfigSeq.class);
        }
        queryConfigSeq.setDefaultId(id);
        sysBusinessConfig.setConfig(JSON.toJSONString((Object)queryConfigSeq));
        this.businessConfigService.saveOrUpdate((Object)sysBusinessConfig);
        return ApiResponse.success();
    }
}

