const glob = require('glob');
const path = require('path');
const webpack = require('webpack');

function resolve(dir) {
    return path.join(__dirname, dir)
}

const getBackgroundJS = function (globPath) {
    let entries = [];
    glob.sync(globPath).forEach(function (entry) {
        entries.push(entry);
    });
    return entries;
};

module.exports = {
    lintOnSave: false,
    publicPath: './',
    assetsDir: 'static',
    css: {
        loaderOptions: {
            sass: {
                prependData: `
          @import "@/assets/css/_variable.scss";
        `,
                implementation: require("sass")
            }
        }
    },
    devServer: {
        hot: true,
        disableHostCheck: true, // 禁用webpack热重载检查 解决热更新失效问题
        port: 8082,// 端口号
        //解决跨域
        proxy: {
            '/hussar': {
                target: process.env.VUE_APP_HUSSAR_DEFAULT_API,
                ws: true,
                changeOrigin: true,
                pathRewrite: {
                    '^/hussar': ''
                }
            }
        },
    },
    productionSourceMap: true,
    chainWebpack(config) {
        // set svg-sprite-loader
        config.module
            .rule('svg')
            .exclude.add(resolve('src/icons'))
            .end()
        config.module
            .rule('icons')
            .test(/\.svg$/)
            .include.add(resolve('src/icons'))
            .end()
            .use('svg-sprite-loader')
            .loader('svg-sprite-loader')
            .options({
                symbolId: 'icon-[name]'
            })
            .end()
        config.module
            .rule('vue')
            .test(/\.vue$/)
            .use('style-rem-loader')
            .loader('style-rem-loader')
            .options({
                viewportWidth: 500,//传参
            })
    },
    configureWebpack: {
        resolve: {
            alias: {
                '@': resolve('src')
            }
        },
        plugins: [
            new webpack.ProvidePlugin({
                $: "jquery",
                jQuery: "jquery",
                "windows.jQuery": "jquery"
            })
        ]
    },
    lintOnSave: true,
    // css: {
    //     loaderOptions: {
    //         postcss: {
    //             plugins: [
    //                   require('postcss-plugin-px2rem')({
    //                     rootValue: 100,
    //                     exclude: 'pc', // 排除pc
    //                     propList: ['*'],
    //                     selectorBlackList: ['ig-'],
    //                     minPixelValue: 1,
    //                   })
    //             ],
    //         },
    //     },
    // },
};
