/**
 * Created by OTt on 2019/3/11.
 */
'use strict'
import { refreshToken } from '@/api/login'
const tokenName = process.env.VUE_APP_TOKEN_NAME
const expireIn = process.env.VUE_APP_TOKEN_EXPIRE_IN
const checkToken = {
  refreshOld: () => {
    if (checkToken.getToken()) {
      // 保活token 每x-1分钟换取一次token
      window.setInterval(() => {
        window.console.log('重启定时刷新token:' + new Date().getMinutes())
        refreshToken().then(response => {
          if (response.status === 200) {
            const token = response.data
            sessionStorage.setItem(tokenName, token)
          }
        })
      }, (15) * 60 * 1000)
    }
  },
  globalRefresh: () => {
    const token = checkToken.getToken()
    if (token) {
      refreshToken().then(response => {
        if (response.status == 200) {
          const token = response.data
          checkToken.saveToken(token)
        }
      })
    }
  },
  tokenName: tokenName,
  getToken: () => {
    return sessionStorage.getItem(tokenName)
  },
  saveToken: (token) => {
    // 登陆保存token 并启动刷新定时器
    sessionStorage.setItem(tokenName, token)
  },
  removeToken: () => {
    sessionStorage.removeItem(tokenName)
  },
  refresh: () => {
    if (needRefresh) {
      sessionStorage.setItem('refreshToken', '1')
      refreshToken().then(res => {
        if (res.code === 200) {
          let token = res.data.accessToken
          sessionStorage.setItem(tokenName, token)
          sessionStorage.setItem(expireIn, res.data.expiresIn)
          window.console.log('刷新token成功')
          sessionStorage.removeItem('refreshToken')
        }
      })
    }
  },
  needRefresh() {
    let expireTime = sessionStorage.getItem(expireIn)
    let currentTime = new Date().getTime()
    return expireTime - currentTime < 5 * 60 * 1000 && expireTime - currentTime > 0 && sessionStorage.getItem('refreshToken') !== '1'
  }
}

export default checkToken
