/**
 * Created by OTt on 2019/5/7.
 */
import axios from 'axios'
import router from '@/router'
import md5 from "js-md5";
const Base64 = require('js-base64').Base64
const tokenName = process.env.VUE_APP_TOKEN_NAME
const config = {
  baseURL: process.env.VUE_APP_URL_PREFIX,
  timeout: 60 * 1000, // Timeour
  withCredentials: false // Check cross-site Access-Control
}

const _axios = axios.create(config)
_axios.interceptors.request.use(
  function(config) {
    // Do something before request is sent
    /*    store.commit("setLoad",true)*/
    if (sessionStorage.getItem(tokenName)) {
      config.headers.token = sessionStorage.getItem(tokenName)
    } else {
      window.console.log('token is not exist')
    }
    return config
  },
  function(error) {
    // Do something with request error
    return Promise.reject(error)
  }
)

_axios.getImg = (url, params) => {
  return _axios({
    method: 'get',
    url: url,
    params: params,
    responseType: "blob",
    headers: {
      'dataId': params === undefined || params === '' || params === null ? '' : md5(JSON.stringify(params)),
      'jstime': new Date().getTime()
    }
  })
}

// axios请求拦截处理
_axios.interceptors.response.use(

  response => {
    switch (response.data.code) {
      case 401:
        sessionStorage.clear()
        location.reload()
        router.push({
          path: '/login'
        })
        return Promise.resolve
      case 402:
      case 403:
        /* 登录提示*/
        // window.location.href = process.env.VUE_APP_BASE_LOGIN_URL
        break
      case 404:
        /* 路径错误提示*/
        break
      case 500:
        /* 服务器错误提示*/
        break
    }
    return response.data
  },
  error => {
    if (error.response) {
      switch (error.response.status) {
        // 如果后台返回401 则表示token验证失败，跳回登陆界面
        case 403:
          //sessionStorage.clear()
          router.push({
            path: '/Forbidden'
          })
      }
    }
    return Promise.reject(error.response.data)
  }
)
// 通过requestBody接收参数时的请求方式
_axios.postJson = (url, params) => {
  return _axios({
    method: 'post',
    url: url,
    data: JSON.stringify(params),
    headers: {
      'Content-Type': 'application/json',
      'dataId': params === undefined || params === '' || params === null ? '' : md5(JSON.stringify(params)),
      'jstime': new Date().getTime()
    }
  })
}
// formData接收参数时的请求方式
_axios.postForm = (url, params) => {
  return _axios({
    method: 'post',
    url: url,
    data: params,
    transformRequest: [function(data) {
      let ret = ''
      for (const it in data) {
        ret += encodeURIComponent(it) + '=' + encodeURIComponent(data[it]) + '&'
      }
      return ret
    }],
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      'dataId': params === undefined || params === '' || params === null ? '' : md5(JSON.stringify(params)),
      'jstime': new Date().getTime()
    }
  })
}

_axios.get = (url, params) => {
  return _axios({
    method: 'get',
    url: url,
    params: params,
    headers: {
      'dataId': params === undefined || params === '' || params === null ? '' : md5(JSON.stringify(params)),
      'jstime': new Date().getTime()
    }
  })
}
_axios.delete = (url, params) => {
  return _axios({
    method: 'delete',
    url: url,
    params: params
  })
}
_axios.postFile = (url, params) => {
  return _axios({
    method: 'post',
    url: url,
    data: params,
    headers: {
      'Content-Type': "multipart/form-data;charset=UTF-8",
      'dataId': params === undefined || params === '' || params === null ? '' : md5(JSON.stringify(params)),
      'jstime': new Date().getTime()
    }
  })
}
_axios.download = (url, params) => {
  return _axios({
    method: 'post',
    url: url,
    data: params,
    transformRequest: [function (data) {
      let ret = ''
      for (const it in data) {
        ret += encodeURIComponent(it) + '=' + encodeURIComponent(data[it]) + '&'
      }
      return ret
    }],
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded'
    },
    responseType: 'blob'
  })
}
export default _axios

