import {login, logout, getBaseData, jqxLogin} from '@/api/login'
import { getToken } from '@/utils/auth'
import checkToken from '@/utils/token-alive'

const user = {
    state: {
        token: getToken(),
        name: '',
        avatar: '',
        roles: []
    },

    mutations: {
        SET_TOKEN: (state, token) => {
            state.token = token
            sessionStorage.setItem(process.env.VUE_APP_TOKEN_NAME, token)
        },
        SET_NAME: (state, name) => {
            state.name = name
            sessionStorage.setItem(process.env.VUE_APP_USERNAME, name)
        },
        SET_EXPIRE_IN: (state, expireIn) => {
            state.expireIn = expireIn
            sessionStorage.setItem(process.env.VUE_APP_TOKEN_EXPIRE_IN, expireIn)
        },
        SET_ROLES: (state, roles) => {
            state.roles = roles
            sessionStorage.setItem(process.env.VUE_APP_ROLE, roles)
        },
        SET_PERMISSION: (state, permissions) => {
            state.permissions = permissions
            sessionStorage.setItem(process.env.VUE_APP_PERMISSION, permissions)
        },
        SET_PUBLICKEY: (state, publickey) => {
            state.publickey = publickey
            sessionStorage.setItem(process.env.VUE_APP_PUBLICKEY, publickey)
        },
        SET_SECURITYTYPE: (state, securityType) => {
            state.securityType = securityType
            sessionStorage.setItem(process.env.VUE_APP_SECURITYTYPE, securityType)
        },
        SET_GRADEADMIN: (state, gradeAdmin) => {
            state.gradeAdmin = gradeAdmin
            sessionStorage.setItem(process.env.VUE_APP_GRADEADMIN, gradeAdmin)
        },
        SET_KAPTCHA: (state, kaptcha) => {
            state.kaptcha = kaptcha
            sessionStorage.setItem(process.env.VUE_APP_KAPTCHA, kaptcha)
        },
        SET_TOTP: (state, totp) => {
            state.totp = totp
            sessionStorage.setItem(process.env.VUE_APP_TOTP, totp)
        },
        SM2PRIKEY: (state, SM2PriKey) => {
            state.SM2PriKey = SM2PriKey
            sessionStorage.setItem(process.env.VUE_APP_SM2PRIKEY, SM2PriKey)
        },
        SM2PUBKEY: (state, SM2PubKey) => {
            state.SM2PubKey = SM2PubKey
            sessionStorage.setItem(process.env.VUE_APP_SM2PUBKEY, SM2PubKey)
        },
        SIGNOPEN: (state, signOpen) => {
            state.signOpen = signOpen
            sessionStorage.setItem(process.env.VUE_APP_SIGNOPEN, signOpen)
        },
        SET_ID: (state, id) => {
            state.id = id
            sessionStorage.setItem(process.env.VUE_APP_USERID, id)
        },
        SET_DEPTID: (state, deptId) => {
            state.deptId = deptId
            sessionStorage.setItem(process.env.VUE_APP_DEPTID, deptId)
        },
        SET_DEPTNAME: (state, deptName) => {
            state.deptName = deptName
            sessionStorage.setItem(process.env.VUE_APP_DEPTNAME, deptName)
        }
    },
    actions: {
        // 登录
        Login({commit}, userInfo) {
            return new Promise((resolve, reject) => {
                // 调用登录接口
                login(userInfo).then(response => {
                    if (response.code === 200) {
                        // 用户登录成功
                        // 获取数据
                        const data = response.data;
                        // 保存token
                        checkToken.saveToken(data.accessToken);
                        // 设置token
                        commit('SET_TOKEN', data.accessToken);
                        // 设置当前登录用户名
                        commit('SET_NAME', data.userName);
                        // 设置权限列表
                        commit('SET_PERMISSION', data.permissions);
                        commit('SET_GRADEADMIN', data.gradeAdmin);
                        // 设置用户id
                        commit('SET_ID', data.userId);
                        // 设置部门id
                        commit('SET_DEPTID', data.deptId);
                        // 设置部门名称
                        commit('SET_DEPTNAME', data.deptName)
                    }
                    resolve(response)
                }).catch(error => {
                    reject(error)
                })
            })
        },
        // 通过金企信token登录
        jqxLogin({commit},token) {
            return new Promise((resolve, reject) => {
                jqxLogin(token).then(response => {
                    if (response.code === 200) {
                        // 用户登录成功
                        // 获取数据
                        const data = response.data;
                        // 保存token
                        checkToken.saveToken(data.accessToken);
                        // 设置token
                        commit('SET_TOKEN', data.accessToken);
                        // 设置当前登录用户名
                        commit('SET_NAME', data.userName);
                        // 设置权限列表
                        commit('SET_PERMISSION', data.permissions);
                        commit('SET_GRADEADMIN', data.gradeAdmin);
                        // 设置用户id
                        commit('SET_ID', data.userId);
                        // 设置部门id
                        commit('SET_DEPTID', data.deptId);
                        // 设置部门名称
                        commit('SET_DEPTNAME', data.deptName)
                    }
                    resolve(response)
                }).catch(err => {
                    reject(err)
                })
            })
        },
        // 登出
        LogOut({commit, state}) {
            return new Promise((resolve, reject) => {
                // 登出操作，调用登出接口
                logout().then(() => {
                    // 清空缓存
                    sessionStorage.clear()
                    resolve()
                }).catch(error => {
                    reject(error)
                })
            })
        },
        //获取公共属性
        getBaseData({commit}) {
            return new Promise((resolve, reject) => {
                getBaseData().then(response => {
                    if (response.code === 200) {
                        // 获取数据
                        const data = response.data;
                        commit('SET_PUBLICKEY', data.publicKey)
                        commit('SET_SECURITYTYPE', data.securityType)
                        commit('SET_KAPTCHA', data.kaptcha)
                        commit('SET_TOTP', data.totp)
                        commit('SM2PRIKEY', data.SM2PriKey)
                        commit('SM2PUBKEY', data.SM2PubKey)
                        commit('SIGNOPEN', data.signOpen)
                    }
                    resolve(response)
                }).catch(error => {
                    reject(error)
                })


            })
        }
    }
}
export default user
