import Vue from 'vue'
import Vuex from 'vuex'
import user from '@/store/modules/user'
import getters from '@/store/getters'
import storeRegister from '../utils/store_register';
import storePluginRegister from '../utils/store_plugin_register';

Vue.use(Vuex);

const index = new Vuex.Store({
state: {
    user:"",// 存储用户信息
    transportList:0,//传输列表数量
    token:"",// 存储token【obj】，包含有效时间
    headTitle: "" // headBar的标题
    },
    mutations: {
    SET_TOKEN: (state, token) => {
        state.token = token
    },
    set_transport: (state, downloadSize) => {
        state.transportList=downloadSize
    },
    SET_USER: (state, user) => {
        state.user = user
    },
    SET_HEAD_TITLE: (state, title) => {
        console.log(title)
        state.headTitle = title;
    }
    },
    actions: {

    },
    modules: {
        ...storeRegister,
        user,
    },
    plugins:[...storePluginRegister],
    getters
});

export default index
