import moment from 'moment';

import vanillaSdkInstance from './jxdMobileJsSdk';

/**
 * 金企信 API 模拟，覆盖了原版 SDK 的一部分 API。
 */
function JxdMobileJsSdk() {
}
JxdMobileJsSdk.prototype = vanillaSdkInstance;

/**
 * GPS 定位模拟。
 */
JxdMobileJsSdk.prototype.getGeolocation = function (options) {
  let coordType = (options.coordType || "GCJ02").toUpperCase();
  let needAddress = options.needAddress || false;

  // 应该返回 GCJ02 坐标的场景下，尝试调高德地图
  if (coordType === 'GCJ02' || coordType === 'BD09II' || coordType === 'WGS84') {
    return mockGetGeolocationUsingAMap(needAddress);
  }

  return new Promise((accept, reject) => {
    let now = moment(new Date()).format("YYYY-MM-DD HH:mm:ss");
    if (coordType === 'BD09') {
      // 该返回百度坐标系时，直接上假数据
      setTimeout(() => {
        accept({
          latitude: 4369264.651945,
          longitude: 13040487.434662,
          radius: 40,
          time: now,
          coorType: "bd09",
          addr: "中国山东省济南市历下区颖秀路",
          country: "中国",
          province: "山东省",
          city: "济南市",
          district: "历下区",
          street: "颖秀路",
          locationDescribe: "在奥盛大厦附近",
          errorCode: 161,
          describe: ""
        });
      }, 500);
    } else {
      reject("不支持的方法");
    }
  });
}

// 使用高德地图 API 来模拟金企信定位 API 的 GCJ02 坐标系获取
function mockGetGeolocationUsingAMap(needAddress) {
  // 默认的假数据
  let now = moment(new Date()).format("YYYY-MM-DD HH:mm:ss");
  let fallback = {
    latitude: 36.676894,
    longitude: 117.137001,
    radius: 40,
    time: now,
    coorType: "gcj02",
    addr: "中国山东省济南市历下区颖秀路",
    country: "中国",
    province: "山东省",
    city: "济南市",
    district: "历下区",
    street: "颖秀路",
    locationDescribe: "在奥盛大厦附近",
    errorCode: 161,
    describe: ""
  };

  // 没有正确配置高德地图时使用假数据
  if (!process.env.VUE_APP_AMAP_KEY || !window.AMap || !window.AMap.Geolocation) {
    return new Promise((resolve) => {
      setTimeout(function () {
        resolve(fallback);
      }, 500);
    });
  }

  // 调高德地图 API
  return new Promise((resolve) => {
    let geolocation = new window.AMap.Geolocation({
      enableHighAccuracy: true,
      timeout: 500,
      maximumAge: 0,
      // 使用国内的 GCJ02 坐标系，而不是 WGS84 坐标系
      convert: true,
    });
    geolocation.getCurrentPosition();

    // 获取成功时，转换成金企信的数据格式
    window.AMap.event.addListener(geolocation, 'complete', function (data) {
      let converted = {
        latitude: data.position.lat,
        longitude: data.position.lng,
        radius: 40,
        time: now,
        coorType: "gcj02",
        addr: data.formattedAddress,
        country: data.addressComponent.country,
        province: data.addressComponent.province,
        city: data.addressComponent.city,
        district: data.addressComponent.district,
        street: data.addressComponent.street,
        locationDescribe: "",
        errorCode: 161,
        describe: "",
      };
      resolve(converted);
    });

    // 失败直接用假数据
    window.AMap.event.addListener(geolocation, 'error', function (err) {
      console.log(err);
      resolve(fallback);
    });
  });
}

export default new JxdMobileJsSdk();
