import Vue from 'vue'
import Router from 'vue-router'
Vue.use(Router)
const _import = require('@/utils/_import_development')// 获取组件的方法
import Login from '@/views/Login'
import pageConfig from '@/config/page.config.json'
//   解决Avoided redundant navigation to current location 这个错误，
const originalPush = Router.prototype.push;
Router.prototype.push = function push(location) {
    return originalPush.call(this, location).catch(err => err)
}
const routes = [
    {
        path: '/',
        redirect: '/index'
    },
    {
        path: '/index',
        name: 'index',
        component: () => import('@/views/index.vue'),
        redirect: '',
        children: []
    },
    {
        path: '/login',
        name: 'login',
        component: Login,
    },

];
const publishRoutes = [];
importJs(require.context('./', true, /\.js$/));
function importJs(r) {
    r.keys().forEach(key => {
        if (key !== './index.js') {
            let flag = false;
            if (pageConfig.homePage) {
                routes[1].redirect = pageConfig.homePage
            }
            pageConfig.list.forEach(pageList => {
                if (key.indexOf(pageList.pageID) === 1) {
                    routes[1].children.push(_import(key))
                    flag = true;
                }
            })
            if (!flag){
                routes.push(_import(key))
                publishRoutes.push(_import(key))
            }
        }
    });
}
let router = new Router({
    routes: routes.concat(publishRoutes)
});
router.beforeEach((to, from, next) => {
    console.log(to.path,from.path)
    let token = sessionStorage.getItem(process.env.VUE_APP_TOKEN_NAME);
    if(token || to.path === '/login') {
        next()
    }else {
        // messages.info('您还未登录，请先登录');
        next({
            path: '/login',
            query: {
                redirect: to.path
            }
        })
    }
})
export const menus = publishRoutes.map((v) => {
    return {
        title: v['meta']['title'] || '',
        path: v['path'],
    }
});
export default router

