import JSEncrypt from 'jsencrypt'
import CryptoJS from 'crypto-js';

const HussarSecurity = {};

HussarSecurity.encode = function (cipher) {
    let securityType = sessionStorage.getItem(process.env.VUE_APP_SECURITYTYPE);
    let publickey = sessionStorage.getItem(process.env.VUE_APP_PUBLICKEY);
    cipher = decodeURIComponent(cipher, true);
    if ("RSACryptoProvider" === securityType) {
        let encrypt = new JSEncrypt();
        encrypt.setPublicKey(publickey);
        return encrypt.encrypt(cipher);
    }
    if ("AESCryptoProvider" === securityType) {
        let key = CryptoJS.enc.Utf8.parse(publickey);
        let srcs = CryptoJS.enc.Utf8.parse(cipher);
        let encrypted = CryptoJS.AES.encrypt(srcs, key, {mode: CryptoJS.mode.ECB, padding: CryptoJS.pad.Pkcs7});
        return encrypted.toString();
    }
    if ("Base64CryptoProvider" === securityType) {
        let base64Encrypted = encode64(cipher);
        return base64Encrypted.toString();
    }
};

function encode64(input) {
    let keyStr = "ABCDEFGHIJKLMNOP" + "QRSTUVWXYZabcdef" + "ghijklmnopqrstuv"
        + "wxyz0123456789+/" + "=";
    let output = "";
    let chr1, chr2, chr3 = "";
    let enc1, enc2, enc3, enc4 = "";
    let i = 0;
    do {
        chr1 = input.charCodeAt(i++);
        chr2 = input.charCodeAt(i++);
        chr3 = input.charCodeAt(i++);
        enc1 = chr1 >> 2;
        enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
        enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
        enc4 = chr3 & 63;
        if (isNaN(chr2)) {
            enc3 = enc4 = 64;
        } else if (isNaN(chr3)) {
            enc4 = 64;
        }
        output = output + keyStr.charAt(enc1) + keyStr.charAt(enc2)
            + keyStr.charAt(enc3) + keyStr.charAt(enc4);
        chr1 = chr2 = chr3 = "";
        enc1 = enc2 = enc3 = enc4 = "";
    } while (i < input.length);

    return output;
}

export default HussarSecurity;
