// The Vue build version to load with the `import` command
// (runtime-only or standalone) has been set in webpack.base.conf with an alias.
import Vue from 'vue'
import store from './store'
import ionic from '@ionic/vue';
import Loading from "./components/loading";
import Meta from 'vue-meta'
Vue.use(Meta)
import '@/config/routerStick'
import { Search } from 'mint-ui';
Vue.component(Search.name, Search);
import '@ionic/core/css/ionic.bundle.css';
import '@/assets/css/default_value.css'
// import '@/assets/css/scheme1.css'.
import './assets/styles/reset.css'//样式重置文件
import './assets/styles/border.css'//样式重置文件
import './assets/icon/iconfont.css'
import MintUI from 'mint-ui'
import 'mint-ui/lib/style.css'
import vView from 'vue-view-lazy'
import "pdfh5/css/pdfh5.css";
import './assets/fonts/ionicIcon/iconfont.css';
import './assets/fonts/ionicIcon/iconfont';
import './assets/fonts/axeMobile/iconfont.css';
import './assets/fonts/axeMobile/iconfont';
import VueTouch from 'vue-touch'
Vue.use(VueTouch, {name: 'v-touch'});
import router from './router'
import waterfall from 'vue-waterfall2'
import VueScroller from 'vue-scroller'
Vue.use(waterfall)
import VueClipboard from 'vue-clipboard2'
Vue.use(VueClipboard)
import '@/icons'
import vant, { Icon as vantIcon } from 'vant';
import 'vant/lib/index.css';
import numeral from 'numeral';
import accountingNumFormat from '@/utils/accountingNumFormat'
import moment from 'moment';
import VueAMap from 'vue-amap';
import './custom'
Vue.prototype.$numeral = numeral;
Vue.prototype.$moment = moment;
Vue.prototype.$accountingNumFormat = accountingNumFormat
Vue.use(vant)
Vue.use(vantIcon);
Vue.use(ionic);
Vue.use(MintUI);
Vue.use(vView);
Vue.use(Loading);
Vue.use(VueScroller)
Vue.use(VueAMap);
VueAMap.initAMapApiLoader({
  v: '1.4.4',
  key: process.env.VUE_APP_AMAP_KEY, // 从 webpack 环境变量拿到高德地图 Web 端 API 的 key
  plugin: ['AMap.Scale', 'AMap.ToolBar', 'AMap.Autocomplete', 'AMap.PlaceSearch', 'AMap.Geolocation', 'AMap.Geocoder'],
});
Vue.config.productionTip = false
import App from './App'
import echarts from 'echarts'

Vue.prototype.$echarts = echarts

/* eslint-disable no-new */
new Vue({
  router,
  store,
  render: h => h(App),

}).$mount('#app')

