(function (doc, win) {
    // let winWidth =  document.body.clientWidth;
    let sUserAgent = navigator.userAgent;
    let phoneFlag = sUserAgent.indexOf('Android') > -1 || sUserAgent.indexOf('iPhone') > -1 || sUserAgent.indexOf('iPad') > -1 || sUserAgent.indexOf('iPod') > -1 || sUserAgent.indexOf('Symbian') > -1;
    let docEl = doc.documentElement,
        resizeEvt = 'orientationchange' in window ? 'orientationchange' : 'resize',
        recalc = function () {
            let clientWidth = docEl.clientWidth;
            if (!clientWidth) return;
            if(clientWidth>=1080 && phoneFlag){  // 移动端高分辨率
                docEl.style.fontSize = '100px';
            }else if(clientWidth <= 1440 && !phoneFlag){  // 非移动端 低分辨率
                docEl.style.fontSize = '36px';
                document.getElementById("app").style.maxWidth = 388+"px";
            }else if(clientWidth > 1440 && !phoneFlag){  //  // 非移动端 高分辨率
                docEl.style.fontSize = '40px';
                document.getElementById("app").style.maxWidth = 496+"px";
            }else{
                docEl.style.fontSize = 20 * (clientWidth / 1080) + 'px';
            }
        };
    if (!doc.addEventListener) return;
    win.addEventListener(resizeEvt, recalc, false);
    doc.addEventListener('DOMContentLoaded', recalc, false);
})(document, window);