import hussarRequest from '@/utils/hussar-default-request'

/**
 * 用户详情
 */
export function detail(userId) {
    return hussarRequest.postJson('/userFront/userInfo',{'id':userId});
}

/**
 * 获取用户关联的角色树
 */
export function userRoleTree(userId) {
    return hussarRequest.postJson('/roleManagerFront/selfRoleTree',{
        'roleIds':userId
    },false);
}

/**
 * 获取图片
 */
export function getImgSrc(code,userName) {
    return hussarRequest.getImg('/qrcode/getTotpKey',{
        'code':code,
        'userName':userName
    });
}

/**
 * 用户修改保存
 */
export function updateUser(form) {
    return hussarRequest.postJson('/userFront/edit',form);
}

/**
 * 用户新增保存
 */
export function saveUser(form) {
    return hussarRequest.postJson('/userFront/add',form);
}

/**
 * 用户新增角色信息保存
 */
export function saveUserRole(form) {
    return hussarRequest.postJson('/userFront/addUserRole',form);
}

/**
 * 获取用户关联的角色
 */
export function getGrantedRoleId(userId) {
    return hussarRequest.postJson('/userFront/userInfo',{'id':userId});
}

/**
 *获取分级树默认选中id
 */
export function getRoleChecked(userId) {
    return hussarRequest.postJson('/roleManagerFront/getUserRole',{
        'userId':userId
    });
}

/**
 * 用户管理获取角色树
 */
export function getRoleTree() {
    return hussarRequest.postJson('/roleManagerFront/roleTree',{
        "1":"1"
    },false);
}

// 根据组织机构id获取人员树信息
export function getStaffTree(data) {
    return hussarRequest.postJson('/employeeFront/employeeTreeById', data)
}

// 根据组织机构id获取人员树信息
export function getOrganTree(data) {
    return hussarRequest.postJson('/roleManagerFront/roleTree', data)
}
/**
 * 获取分级用户关联的角色树
 */
export function gradeuserRoleTree(userId,parentId,funT) {
    return hussarRequest.postJson('/roleManagerFront/roleTree',{
        'userId':userId,
        'nodeId':parentId,
        'functionType':funT
    },false);
}
/**
 * 导入接口
 */
export function importData(data) {
    return hussarRequest.postFile('/userFront/importData',data);
}
/**
 * 获取导出资源树
 */
export function getExportResourceTree(data) {
    return hussarRequest.postJson('/userFront/userTree',data,false);
}
/**
 * 保存导出资源树
 */
export function saveExportTree(data) {
    return hussarRequest.download('/userFront/exportData',{
        'ids':data
    });
}
