import hussarRequest from '@/utils/hussar-default-request'
/**
 * 用户登录接口
 * @method login
 * @param username 用户名
 * @param password 密码
 * @returns {AxiosPromise}
 */
export function login(params) {
  return hussarRequest.postJson('/frontLogin/login', params)
}
export function jqxLogin(token) {
  return hussarRequest.postJson(`/jqx/login/${token}`)
}
export function logout() {
  return hussarRequest.postJson('/frontLogin/logout')
}

export function refreshToken() {
  return hussarRequest.postJson('/auth/refreshToken')
}

export function getBaseData() {
  return hussarRequest.postJson('/vue/baseData/getBaseData')
}
