const pxtorem = require('postcss-pxtorem')
const autoprefixer = require('autoprefixer')

module.exports = ({ file }) => {
    let rootValue
    if (file && file.dirname && file.dirname.indexOf('vant') > -1) {
        rootValue = 50
    } else {
        rootValue = 50
    }
    return {
        plugins: [
            autoprefixer(),
            pxtorem({
                rootValue: rootValue,
                propList: ['*'],
                minPixelValue: 2
            })
        ]
    }
}

