/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.file.fileoperate.service.onlineimpl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.speedcode.common.config.condition.ConditionUseSharedStorage;
import com.jxdinfo.speedcode.common.exception.LcdpException;
import com.jxdinfo.speedcode.common.exception.LcdpExceptionEnum;
import com.jxdinfo.speedcode.common.file.FileMappingService;
import com.jxdinfo.speedcode.common.file.ResourcePathService;
import com.jxdinfo.speedcode.common.model.CustomComponentCategoryInfo;
import com.jxdinfo.speedcode.common.model.PageTemplateCategoryInfo;
import com.jxdinfo.speedcode.common.model.PageTemplateInfo;
import com.jxdinfo.speedcode.common.response.SpeedCodeResponse;
import com.jxdinfo.speedcode.common.util.ToolUtil;
import com.jxdinfo.speedcode.file.fileoperate.service.PageTemplateInfoService;
import com.jxdinfo.speedcode.storage.client.service.StorageService;
import java.io.File;
import java.io.IOException;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="PageTemplateInfoServiceOnLineImpl")
@Conditional(value={ConditionUseSharedStorage.class})
public class PageTemplateInfoServiceOnLineImpl
implements PageTemplateInfoService {
    @Resource
    private ResourcePathService resourcePathService;
    @Resource
    private FileMappingService fileMappingService;
    @Resource
    private StorageService storageService;

    protected String relativeToAbsolute(String a, String a2) {
        return new StringBuilder().insert(0, a2).append(File.separator).append(a).toString().replace(CustomComponentCategoryInfo.long("\u0014"), File.separator).replace(PageTemplateCategoryInfo.short("<"), File.separator).replace(CustomComponentCategoryInfo.long("V\u0014"), File.separator).replace(PageTemplateCategoryInfo.short("z<"), File.separator);
    }

    @Override
    public void delete(PageTemplateInfo a) throws LcdpException {
        PageTemplateInfoServiceOnLineImpl a2;
        String string = a2.resourcePathService.projectStorePageTemplate(new String[0]).getRemotePath();
        String string2 = new StringBuilder().insert(0, ((PageTemplateInfo)a).getPageType()).append(File.separator).append(((PageTemplateInfo)a).getCategory()).toString();
        PageTemplateInfoServiceOnLineImpl pageTemplateInfoServiceOnLineImpl = a2;
        string = pageTemplateInfoServiceOnLineImpl.relativeToAbsolute(string2 + File.separator + ((PageTemplateInfo)a).getName() + ".meta", string);
        pageTemplateInfoServiceOnLineImpl.storageService.deleteByPath(string, false);
        a = ((PageTemplateInfo)a).getCover();
        a2.delCover((String)a);
    }

    @Override
    public void getCover(String a, HttpServletResponse a2) throws IOException {
        PageTemplateInfoServiceOnLineImpl a3;
        String string = a3.resourcePathService.projectStorePageTemplateCover(new String[0]).getRemotePath();
        a = new StringBuilder().insert(0, string).append(File.separator).append((String)a).toString();
        a2.setContentType(PageTemplateCategoryInfo.short("\tK\u0001A\u0005\t\u0010H\u0007"));
        a = (byte[])a3.storageService.downloadByPath((String)a).getData();
        ServletOutputStream servletOutputStream = a2.getOutputStream();
        servletOutputStream.write((byte[])a);
        servletOutputStream.flush();
        servletOutputStream.close();
    }

    @Override
    public void create(PageTemplateInfo a3) throws LcdpException, IOException {
        PageTemplateInfoServiceOnLineImpl a2;
        String string = a2.resourcePathService.projectStorePageTemplate(new String[0]).getRemotePath();
        if (!(ToolUtil.isEmpty((Object)a3.getPageType()) || ToolUtil.isEmpty((Object)a3.getCategory()) || ToolUtil.isEmpty((Object)a3.getName()))) {
            String string2 = a3.getPageType();
            string2 = new StringBuilder().insert(0, string2).append(File.separator).append(a3.getCategory()).toString();
            string = a2.relativeToAbsolute(string2 + File.separator + a3.getName() + ".meta", string);
            if (Boolean.valueOf(Boolean.TRUE.equals(a2.storageService.existsByPath(string).getData())).booleanValue()) {
                throw new LcdpException(LcdpExceptionEnum.FILE_ALREADY_EXIST, string);
            }
            try {
                a2.storageService.uploadByPath(string, new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)a3).getBytes(), false);
                return;
            }
            catch (IOException a3) {
                throw new LcdpException(LcdpExceptionEnum.FILE_WRITE_FAIL, string);
            }
        }
        throw new LcdpException(LcdpExceptionEnum.UPLOAD_ERROR, PageTemplateCategoryInfo.short("\u6a07\u671f\u4fc7\u600f\u953f\u8b8f"));
    }

    @Override
    public void updateFileMeta(PageTemplateInfo a3) throws IOException, LcdpException {
        PageTemplateInfoServiceOnLineImpl a2;
        String string = a2.resourcePathService.projectStorePageTemplate(new String[0]).getRemotePath();
        if (!(ToolUtil.isEmpty((Object)a3.getPageType()) || ToolUtil.isEmpty((Object)a3.getCategory()) || ToolUtil.isEmpty((Object)a3.getName()))) {
            String string2 = a3.getPageType();
            string2 = new StringBuilder().insert(0, string2).append(File.separator).append(a3.getCategory()).toString();
            string = a2.relativeToAbsolute(string2 + File.separator + a3.getName() + ".meta", string);
            try {
                a2.storageService.uploadByPath(string, new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)a3).getBytes(), false);
            }
            catch (IOException a3) {
                throw new LcdpException(LcdpExceptionEnum.FILE_WRITE_FAIL, string);
            }
            a2.fileMappingService.fileMappingCacheEvict();
            return;
        }
        throw new LcdpException(LcdpExceptionEnum.UPLOAD_ERROR, CustomComponentCategoryInfo.long("\u6a58\u6744\u4f98\u6054\u9560\u8bd4"));
    }

    @Override
    public void delCover(String a) throws LcdpException {
        if (!"".equals(a)) {
            PageTemplateInfoServiceOnLineImpl a2;
            String string = a2.resourcePathService.projectStorePageTemplateCover(new String[0]).getRemotePath();
            a = new StringBuilder().insert(0, ToolUtil.pathFomatterByOS((String)string)).append(File.separator).append(a).toString();
            a2.storageService.deleteByPath(a, false);
        }
    }

    public PageTemplateInfoServiceOnLineImpl() {
        PageTemplateInfoServiceOnLineImpl a;
    }

    @Override
    public SpeedCodeResponse<String> upload(MultipartFile a) throws IOException {
        PageTemplateInfoServiceOnLineImpl a2;
        SpeedCodeResponse speedCodeResponse = new SpeedCodeResponse();
        String string = a2.resourcePathService.projectStorePageTemplateCover(new String[0]).getRemotePath();
        MultipartFile multipartFile = a;
        a = multipartFile.getOriginalFilename();
        string = new StringBuilder().insert(0, string).append(File.separator).append((String)a).toString();
        byte[] byArray = multipartFile.getBytes();
        SpeedCodeResponse speedCodeResponse2 = speedCodeResponse;
        a2.storageService.uploadByPath(string, byArray, false);
        speedCodeResponse2.setData(a);
        return speedCodeResponse2;
    }
}

