/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.file.fileoperate.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.speedcode.common.config.condition.ConditionNotSharedStorage;
import com.jxdinfo.speedcode.common.exception.LcdpException;
import com.jxdinfo.speedcode.common.exception.LcdpExceptionEnum;
import com.jxdinfo.speedcode.common.file.FileMappingService;
import com.jxdinfo.speedcode.common.model.CustomComponentGroupInfo;
import com.jxdinfo.speedcode.common.model.MobileProjectInfo;
import com.jxdinfo.speedcode.common.model.PageTemplateInfo;
import com.jxdinfo.speedcode.common.properties.SpeedCodeProperties;
import com.jxdinfo.speedcode.common.response.SpeedCodeResponse;
import com.jxdinfo.speedcode.common.util.ToolUtil;
import com.jxdinfo.speedcode.file.fileoperate.service.PageTemplateInfoService;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="PageTemplateInfoServiceImpl")
@Conditional(value={ConditionNotSharedStorage.class})
public class PageTemplateInfoServiceImpl
implements PageTemplateInfoService {
    @Resource
    private SpeedCodeProperties speedCodeProperties;
    @Resource
    private FileMappingService fileMappingService;

    @Override
    public void delete(PageTemplateInfo a) throws LcdpException {
        PageTemplateInfoServiceImpl a2;
        Object object = a2.speedCodeProperties.getProjectAndPageTemplatePath();
        String string = new StringBuilder().insert(0, a.getPageType()).append(File.separator).append(a.getCategory()).toString();
        object = new File(a2.relativeToAbsolute(string + File.separator + a.getName() + ".meta", (String)object));
        try {
            FileUtils.forceDelete((File)object);
        }
        catch (IOException iOException) {
            throw new LcdpException(LcdpExceptionEnum.FILE_DELETE_FAIL, ((File)object).getAbsolutePath());
        }
        string = a.getCover();
        if (!"".equals(string)) {
            a2.delCover(string);
        }
        a2.fileMappingService.fileMappingCacheEvict();
    }

    @Override
    public void getCover(String a, HttpServletResponse a2) throws IOException, LcdpException {
        Object object;
        PageTemplateInfoServiceImpl a3;
        Object object2 = a3.speedCodeProperties.getProjectAndPageTemplateCoverPath();
        object2 = new File(new StringBuilder().insert(0, (String)object2).append(File.separator).append((String)a).toString());
        String string = a;
        a = string.substring(string.lastIndexOf(CustomComponentGroupInfo.char("*")) + 1);
        if (((String)a).equals(MobileProjectInfo.volatile("y\u0018t"))) {
            object = object2;
            a2.setContentType(CustomComponentGroupInfo.char("\u000fi\u0007c\u0003+\ft\u0003c"));
        } else if (((String)a).equals(MobileProjectInfo.volatile("Y8T"))) {
            object = object2;
            a2.setContentType(CustomComponentGroupInfo.char("\u000fi\u0007c\u0003+\ft\u0003c"));
        } else if (((String)a).equals(MobileProjectInfo.volatile("c\u0006t"))) {
            object = object2;
            a2.setContentType(CustomComponentGroupInfo.char("m\u000be\u0001aIt\bc"));
        } else {
            if (((String)a).equals(MobileProjectInfo.volatile("C&T"))) {
                a2.setContentType(CustomComponentGroupInfo.char("m\u000be\u0001aIt\bc"));
            }
            object = object2;
        }
        if (((File)object).exists()) {
            int n;
            a = new FileInputStream((File)object2);
            a2 = new BufferedOutputStream((OutputStream)a2.getOutputStream());
            byte[] byArray = new byte[10240];
            Object object3 = a;
            while ((n = ((InputStream)object3).read(byArray)) != -1) {
                object3 = a;
                ((OutputStream)a2).write(byArray, 0, n);
            }
            Object object4 = a2;
            ((OutputStream)object4).flush();
            ((OutputStream)object4).close();
            ((InputStream)a).close();
            return;
        }
        throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, ((File)object2).getAbsolutePath());
    }

    public PageTemplateInfoServiceImpl() {
        PageTemplateInfoServiceImpl a;
    }

    @Override
    public SpeedCodeResponse<String> upload(MultipartFile a) throws LcdpException {
        PageTemplateInfoServiceImpl a2;
        String string = a2.speedCodeProperties.getProjectAndPageTemplateCoverPath();
        SpeedCodeResponse speedCodeResponse = new SpeedCodeResponse();
        String string2 = a.getOriginalFilename();
        try {
            File file = new File(string);
            if (!file.exists()) {
                FileUtils.forceMkdir((File)file);
            }
            a.transferTo(new File(new StringBuilder().insert(0, string).append(File.separator).append(string2).toString()));
            speedCodeResponse.setData((Object)string2);
            return speedCodeResponse;
        }
        catch (IOException iOException) {
            throw new LcdpException(LcdpExceptionEnum.UPLOAD_ERROR, string2);
        }
    }

    @Override
    public void updateFileMeta(PageTemplateInfo a) throws IOException, LcdpException {
        PageTemplateInfoServiceImpl a2;
        Object object = a2.speedCodeProperties.getProjectAndPageTemplatePath();
        String string = a.getPageType();
        string = new StringBuilder().insert(0, string).append(File.separator).append(a.getCategory()).toString();
        object = new File(a2.relativeToAbsolute(string + File.separator + a.getName() + ".meta", (String)object));
        if (!((File)object).exists()) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, a.getName());
        }
        FileUtils.writeStringToFile((File)object, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)a), (String)MobileProjectInfo.volatile("F<UE+"));
        a2.fileMappingService.fileMappingCacheEvict();
    }

    @Override
    public void create(PageTemplateInfo a) throws LcdpException, IOException {
        PageTemplateInfoServiceImpl a2;
        Object object = a2.speedCodeProperties.getProjectAndPageTemplatePath();
        String string = a.getPageType();
        string = new StringBuilder().insert(0, string).append(File.separator).append(a.getCategory()).toString();
        object = new File(a2.relativeToAbsolute(string + File.separator + a.getName() + ".meta", (String)object));
        if (((File)object).exists()) {
            throw new LcdpException(LcdpExceptionEnum.FILE_ALREADY_EXIST, ((File)object).getAbsolutePath());
        }
        FileUtils.writeStringToFile((File)object, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)a), (String)CustomComponentGroupInfo.char("Q2BK<"), (boolean)false);
        a2.fileMappingService.fileMappingCacheEvict();
    }

    protected String relativeToAbsolute(String a, String a2) {
        return new StringBuilder().insert(0, a2).append(File.separator).append(a).toString().replace(MobileProjectInfo.volatile("<"), File.separator).replace(CustomComponentGroupInfo.char("X"), File.separator).replace(MobileProjectInfo.volatile("G<"), File.separator).replace(CustomComponentGroupInfo.char(":X"), File.separator);
    }

    @Override
    public void delCover(String a) throws LcdpException {
        PageTemplateInfoServiceImpl a2;
        String string = a2.speedCodeProperties.getProjectAndPageTemplateCoverPath();
        a = new File(new StringBuilder().insert(0, ToolUtil.pathFomatterByOS((String)string)).append(File.separator).append((String)a).toString());
        if (((File)a).exists()) {
            try {
                FileUtils.forceDelete((File)a);
            }
            catch (IOException iOException) {
                throw new LcdpException(LcdpExceptionEnum.FILE_DELETE_FAIL, ((File)a).getAbsolutePath());
            }
            a2.fileMappingService.fileMappingCacheEvict();
        }
    }
}

