/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.file.fileoperate.controller;

import com.jxdinfo.hussar.util.BpmConfigReadService;
import com.jxdinfo.speedcode.common.exception.LcdpException;
import com.jxdinfo.speedcode.common.model.OperateFileVO;
import com.jxdinfo.speedcode.common.model.PageInfo;
import com.jxdinfo.speedcode.common.model.WorkflowInfo;
import com.jxdinfo.speedcode.common.properties.SpeedCodeProperties;
import com.jxdinfo.speedcode.common.response.SpeedCodeResponse;
import com.jxdinfo.speedcode.common.util.ToolUtil;
import com.jxdinfo.speedcode.file.fileoperate.service.WorkflowService;
import java.io.IOException;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/speed/workflowinfo"})
public class WorkflowInfoController {
    private final WorkflowService workflowService;
    private final SpeedCodeProperties speedCodeProperties;
    private static final String GOD_AXE_MODEL = "/godaxeModel/";
    private BpmConfigReadService bpmConfigReadService;

    @Autowired
    public WorkflowInfoController(WorkflowService workflowService, SpeedCodeProperties speedCodeProperties, BpmConfigReadService bpmConfigReadService) {
        this.workflowService = workflowService;
        this.speedCodeProperties = speedCodeProperties;
        this.bpmConfigReadService = bpmConfigReadService;
    }

    @PostMapping
    public SpeedCodeResponse<WorkflowInfo> addDataInfo(@RequestBody WorkflowInfo workflowInfo) throws IOException, LcdpException {
        this.workflowService.createWorkflow(workflowInfo);
        return new SpeedCodeResponse();
    }

    @PutMapping(value={"/data/meta"})
    public SpeedCodeResponse<WorkflowInfo> updateAllDataInfo(@RequestBody WorkflowInfo workflowInfo) throws IOException, LcdpException {
        if (ToolUtil.isNotEmpty((Object)workflowInfo.getData())) {
            this.workflowService.updateWorkFlowFile(workflowInfo);
        } else {
            this.workflowService.updateFileMeta(workflowInfo);
        }
        return new SpeedCodeResponse();
    }

    @PutMapping(value={"/adjustProcess"})
    public SpeedCodeResponse<WorkflowInfo> adjustProcess(@RequestBody WorkflowInfo workflowInfo) throws IOException, LcdpException {
        if (ToolUtil.isNotEmpty((Object)workflowInfo.getData())) {
            return this.workflowService.adjustProcess(workflowInfo);
        }
        this.workflowService.updateFileMeta(workflowInfo);
        return new SpeedCodeResponse();
    }

    @PutMapping(value={"/save"})
    public SpeedCodeResponse<PageInfo> saveDataInfo(@RequestBody WorkflowInfo workflowInfo) throws IOException, LcdpException {
        this.workflowService.updateFileData(workflowInfo);
        return new SpeedCodeResponse();
    }

    @PutMapping(value={"/move"})
    public SpeedCodeResponse<PageInfo> moveDataInfo(@RequestBody OperateFileVO operateFileVO) throws IOException, LcdpException {
        this.workflowService.moveWorkFlow(operateFileVO.getId(), operateFileVO.getParentId(), operateFileVO.getNewName(), operateFileVO.getNewDesc(), operateFileVO.getCategory());
        return new SpeedCodeResponse();
    }

    @PostMapping(value={"/copy"})
    public SpeedCodeResponse copyDataInfo(@RequestBody OperateFileVO operateFileVO) throws IOException, LcdpException {
        String processKey = this.workflowService.copyWorkFlow(operateFileVO.getId(), operateFileVO.getParentId(), operateFileVO.getNewId(), operateFileVO.getNewName(), operateFileVO.getNewDesc(), operateFileVO.getCategory());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processKey", processKey);
        SpeedCodeResponse response = new SpeedCodeResponse();
        response.setData(map);
        return response;
    }

    @PutMapping
    public SpeedCodeResponse<WorkflowInfo> updateDataInfo(@RequestBody WorkflowInfo workflowInfo) throws IOException, LcdpException {
        this.workflowService.updateFileMeta(workflowInfo);
        return new SpeedCodeResponse();
    }

    @GetMapping
    public SpeedCodeResponse<WorkflowInfo> getDataInfo(String id) throws IOException, LcdpException {
        SpeedCodeResponse stringSpeedCodeResponse = new SpeedCodeResponse();
        stringSpeedCodeResponse.setData(this.workflowService.get(id));
        return stringSpeedCodeResponse;
    }

    @DeleteMapping
    public SpeedCodeResponse<WorkflowInfo> deleteDataInfo(String id, String identity) throws IOException, LcdpException {
        this.workflowService.delete(id);
        return new SpeedCodeResponse();
    }
}

