/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.file.fileoperate.controller;

import cn.hutool.core.util.StrUtil;
import com.jxdinfo.speedcode.common.response.SpeedCodeResponse;
import com.jxdinfo.speedcode.file.fileoperate.service.ResourcesService;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/speed/resources"})
public class ResourcesController {
    private final ResourcesService resourcesService;

    @Autowired
    public ResourcesController(ResourcesService resourcesService) {
        this.resourcesService = resourcesService;
    }

    @GetMapping(value={"/image"})
    public SpeedCodeResponse<Map<String, Object>> getImage(@RequestParam(required=false) String id) throws Exception {
        SpeedCodeResponse response = new SpeedCodeResponse();
        if (StrUtil.isEmpty((CharSequence)id) || id.equals("null")) {
            response.setErrorCode(200);
            response.setData(null);
            return response;
        }
        response.setData(this.resourcesService.getImgResources(id));
        response.setErrorCode(200);
        return response;
    }

    @GetMapping(value={"/bimImage"})
    public SpeedCodeResponse<Map<String, Object>> getBimImage(@RequestParam(required=false) String id, @RequestParam(required=false) String frontImgPath) throws Exception {
        SpeedCodeResponse response = new SpeedCodeResponse();
        if (StrUtil.isEmpty((CharSequence)id) || id.equals("null")) {
            response.setErrorCode(200);
            response.setData(null);
            return response;
        }
        response.setData(this.resourcesService.getBimImgResources(id, frontImgPath));
        response.setErrorCode(200);
        return response;
    }

    @RequestMapping(value={"/file"})
    @ResponseBody
    public void getFile(String path, HttpServletResponse response) {
        this.resourcesService.getFile(path, response);
    }

    @PostMapping(value={"/image"})
    public List<Map<String, String>> getImage() {
        return this.resourcesService.getImgResources();
    }
}

