/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.file.fileoperate.controller;

import com.jxdinfo.speedcode.common.exception.LcdpException;
import com.jxdinfo.speedcode.common.model.CustomComponentGroupInfo;
import com.jxdinfo.speedcode.common.model.PageInfo;
import com.jxdinfo.speedcode.common.model.PageTemplateInfo;
import com.jxdinfo.speedcode.common.response.SpeedCodeResponse;
import com.jxdinfo.speedcode.file.fileoperate.service.PageTemplateInfoService;
import java.io.IOException;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/speed/pageTemplateInfo"})
public class PageTemplateInfoController {
    @Resource
    private PageTemplateInfoService pageTemplateInfoService;

    @PostMapping
    public SpeedCodeResponse<CustomComponentGroupInfo> addDataInfo(@RequestBody PageTemplateInfo pageTemplateInfo) throws IOException, LcdpException {
        this.pageTemplateInfoService.create(pageTemplateInfo);
        return new SpeedCodeResponse();
    }

    @PutMapping
    public SpeedCodeResponse<PageInfo> updateDataInfo(@RequestBody PageTemplateInfo pageTemplateInfo) throws IOException, LcdpException {
        this.pageTemplateInfoService.updateFileMeta(pageTemplateInfo);
        return new SpeedCodeResponse();
    }

    @PutMapping(value={"/delete"})
    public SpeedCodeResponse<PageInfo> deleteDataInfo(@RequestBody PageTemplateInfo pageTemplateInfo) throws IOException, LcdpException {
        this.pageTemplateInfoService.delete(pageTemplateInfo);
        return new SpeedCodeResponse();
    }

    @RequestMapping(value={"/upload"})
    @ResponseBody
    public SpeedCodeResponse<String> upload(@RequestPart(value="file") MultipartFile file) throws LcdpException, IOException {
        return this.pageTemplateInfoService.upload(file);
    }

    @GetMapping(value={"/delCover"})
    public SpeedCodeResponse<PageInfo> delCover(String fileName) throws LcdpException, IOException {
        this.pageTemplateInfoService.delCover(fileName);
        return new SpeedCodeResponse();
    }

    @GetMapping(value={"/getCover"})
    public void getCover(String fileName, HttpServletResponse response) throws IOException, LcdpException {
        this.pageTemplateInfoService.getCover(fileName, response);
    }
}

