/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.file.fileoperate.controller;

import com.jxdinfo.speedcode.common.exception.LcdpException;
import com.jxdinfo.speedcode.common.model.OperateFileVO;
import com.jxdinfo.speedcode.common.model.PageInfo;
import com.jxdinfo.speedcode.common.properties.SpeedCodeProperties;
import com.jxdinfo.speedcode.common.response.SpeedCodeResponse;
import com.jxdinfo.speedcode.common.util.ToolUtil;
import com.jxdinfo.speedcode.file.fileoperate.service.PageInfoService;
import com.jxdinfo.speedcode.file.fileoperate.service.WorkflowService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/speed/pageinfo"})
public class PageInfoController {
    private final PageInfoService pageInfoService;
    private final SpeedCodeProperties speedCodeProperties;

    @Autowired
    public PageInfoController(PageInfoService pageInfoService, SpeedCodeProperties speedCodeProperties, WorkflowService workflowService) {
        this.pageInfoService = pageInfoService;
        this.speedCodeProperties = speedCodeProperties;
    }

    @PostMapping
    public SpeedCodeResponse<PageInfo> addDataInfo(@RequestBody PageInfo pageInfo) throws IOException, LcdpException {
        this.pageInfoService.create(pageInfo);
        return new SpeedCodeResponse();
    }

    @PutMapping(value={"/data/meta"})
    public SpeedCodeResponse<PageInfo> updateAllDataInfo(@RequestBody PageInfo pageInfo) throws IOException, LcdpException {
        if (ToolUtil.isNotEmpty((Object)pageInfo.getData())) {
            this.pageInfoService.updateFile(pageInfo);
        } else {
            this.pageInfoService.updateFileMeta(pageInfo);
        }
        return new SpeedCodeResponse();
    }

    @PostMapping(value={"/save/pages"})
    public SpeedCodeResponse<PageInfo> saveMultiPageInfo(@RequestBody List<PageInfo> pageInfos) throws IOException, LcdpException {
        if (ToolUtil.isNotEmpty(pageInfos)) {
            for (PageInfo pageInfo : pageInfos) {
                if (ToolUtil.isNotEmpty((Object)pageInfo.getData())) {
                    this.pageInfoService.updateFile(pageInfo);
                    continue;
                }
                this.pageInfoService.updateFileMeta(pageInfo);
            }
        }
        return new SpeedCodeResponse();
    }

    @PutMapping
    public SpeedCodeResponse<PageInfo> updateDataInfo(@RequestBody PageInfo pageInfo) throws IOException, LcdpException {
        this.pageInfoService.updateFileMeta(pageInfo);
        return new SpeedCodeResponse();
    }

    @PutMapping(value={"/save"})
    public SpeedCodeResponse<PageInfo> saveDataInfo(@RequestBody PageInfo pageInfo) throws IOException, LcdpException {
        this.pageInfoService.updateFileData(pageInfo);
        return new SpeedCodeResponse();
    }

    @GetMapping
    public SpeedCodeResponse<PageInfo> getDataInfo(String id) throws IOException, LcdpException {
        SpeedCodeResponse stringSpeedCodeResponse = new SpeedCodeResponse();
        stringSpeedCodeResponse.setData(this.pageInfoService.get(id));
        return stringSpeedCodeResponse;
    }

    @PostMapping(value={"/datas"})
    public SpeedCodeResponse<List<PageInfo>> getDataInfos(@RequestBody List<PageInfo> pageInfoList) throws IOException, LcdpException {
        SpeedCodeResponse stringSpeedCodeResponse = new SpeedCodeResponse();
        ArrayList pageInfos = new ArrayList();
        if (ToolUtil.isNotEmpty(pageInfoList)) {
            for (PageInfo pageInfo : pageInfoList) {
                pageInfos.add(this.pageInfoService.get(pageInfo.getId()));
            }
        }
        stringSpeedCodeResponse.setData(pageInfos);
        return stringSpeedCodeResponse;
    }

    @DeleteMapping
    public SpeedCodeResponse<PageInfo> deleteDataInfo(String id) throws IOException, LcdpException {
        this.pageInfoService.delete(id);
        return new SpeedCodeResponse();
    }

    @PostMapping(value={"/copy"})
    public SpeedCodeResponse<PageInfo> copyDataInfo(@RequestBody OperateFileVO operateFileVO) throws IOException, LcdpException {
        this.pageInfoService.copy(operateFileVO.getId(), operateFileVO.getParentId(), operateFileVO.getNewId(), operateFileVO.getNewName(), operateFileVO.getNewDesc());
        return new SpeedCodeResponse();
    }

    @PutMapping(value={"/move"})
    public SpeedCodeResponse<PageInfo> moveDataInfo(@RequestBody OperateFileVO operateFileVO) throws IOException, LcdpException {
        this.pageInfoService.move(operateFileVO.getId(), operateFileVO.getParentId(), operateFileVO.getNewName(), operateFileVO.getNewDesc());
        return new SpeedCodeResponse();
    }

    @GetMapping(value={"/getWebPort"})
    public SpeedCodeResponse<Integer> getWebPort() {
        SpeedCodeResponse speedCodeResponse = new SpeedCodeResponse();
        speedCodeResponse.setData((Object)this.pageInfoService.getWebPort());
        return speedCodeResponse;
    }

    @GetMapping(value={"/getWebHost"})
    public SpeedCodeResponse<String> getWebHost() {
        SpeedCodeResponse speedCodeResponse = new SpeedCodeResponse();
        speedCodeResponse.setData((Object)this.pageInfoService.getWebHost());
        return speedCodeResponse;
    }
}

