/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.file.fileoperate.controller;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.speedcode.common.exception.LcdpException;
import com.jxdinfo.speedcode.common.model.ModuleInfo;
import com.jxdinfo.speedcode.common.model.OperateFileVO;
import com.jxdinfo.speedcode.common.properties.SpeedCodeProperties;
import com.jxdinfo.speedcode.common.response.SpeedCodeResponse;
import com.jxdinfo.speedcode.common.util.ToolUtil;
import com.jxdinfo.speedcode.file.fileoperate.service.FileTreeService;
import com.jxdinfo.speedcode.file.fileoperate.service.ModuleInfoService;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/speed/moduleinfo"})
public class ModuleInfoController {
    private final ModuleInfoService moduleInfoService;
    private final SpeedCodeProperties speedCodeProperties;
    private final FileTreeService fileTreeService;

    @Autowired
    public ModuleInfoController(ModuleInfoService moduleInfoService, SpeedCodeProperties speedCodeProperties, FileTreeService fileTreeService) {
        this.moduleInfoService = moduleInfoService;
        this.speedCodeProperties = speedCodeProperties;
        this.fileTreeService = fileTreeService;
    }

    @PostMapping
    public SpeedCodeResponse<ModuleInfo> addDataInfo(@RequestBody ModuleInfo moduleInfo) throws IOException, LcdpException {
        this.moduleInfoService.createDirectory(moduleInfo);
        return new SpeedCodeResponse();
    }

    @PutMapping
    public SpeedCodeResponse<ModuleInfo> updateDataInfo(@RequestBody ModuleInfo moduleInfo) throws IOException, LcdpException {
        this.moduleInfoService.updateDirectory(moduleInfo);
        return new SpeedCodeResponse();
    }

    @DeleteMapping
    public SpeedCodeResponse<ModuleInfo> deleteDataInfo(String id) throws IOException, LcdpException {
        return this.moduleInfoService.deleteDirectory(id);
    }

    @PostMapping(value={"/copy"})
    public SpeedCodeResponse<List<JSONObject>> copyDirectory(@RequestBody OperateFileVO operateFileVO) throws IOException, LcdpException {
        String uuid = ToolUtil.get36UUID();
        this.moduleInfoService.copyDirectory(operateFileVO.getId(), operateFileVO.getParentId(), uuid, operateFileVO.getNewName(), operateFileVO.getNewDesc());
        SpeedCodeResponse<List<JSONObject>> stringSpeedCodeResponse = this.fileTreeService.getFileTree(uuid);
        if (!this.speedCodeProperties.getScenes().isSharedStorage()) {
            JSONObject baseFile = (JSONObject)JSONObject.parseObject((String)JSONObject.toJSONString(this.moduleInfoService.get(uuid)), JSONObject.class);
            List list = (List)stringSpeedCodeResponse.getData();
            list.add(baseFile);
            stringSpeedCodeResponse.setData((Object)list);
        }
        return stringSpeedCodeResponse;
    }

    @PostMapping(value={"/move"})
    public SpeedCodeResponse<ModuleInfo> moveDirectory(@RequestBody OperateFileVO operateFileVO) throws IOException, LcdpException {
        this.moduleInfoService.moveDirectory(operateFileVO.getId(), operateFileVO.getParentId(), operateFileVO.getNewName(), operateFileVO.getNewDesc());
        return new SpeedCodeResponse();
    }
}

