/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.file.fileoperate.controller;

import com.jxdinfo.speedcode.common.annotation.ExceptionCatcher;
import com.jxdinfo.speedcode.common.exception.LcdpException;
import com.jxdinfo.speedcode.common.file.FileMappingService;
import com.jxdinfo.speedcode.common.model.MicroAppInfo;
import com.jxdinfo.speedcode.common.model.OperateFileVO;
import com.jxdinfo.speedcode.common.properties.SpeedCodeProperties;
import com.jxdinfo.speedcode.common.response.SpeedCodeResponse;
import com.jxdinfo.speedcode.common.util.ToolUtil;
import com.jxdinfo.speedcode.file.fileoperate.service.MicroAppInfoService;
import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/speed/microappinfo"})
public class MicroAppInfoController {
    private final MicroAppInfoService microAppInfoService;
    @Resource
    private FileMappingService fileMappingService;
    private final SpeedCodeProperties speedCodeProperties;

    @Autowired
    public MicroAppInfoController(MicroAppInfoService microAppInfoService, SpeedCodeProperties speedCodeProperties) {
        this.microAppInfoService = microAppInfoService;
        this.speedCodeProperties = speedCodeProperties;
    }

    @PostMapping
    public SpeedCodeResponse<MicroAppInfo> addDataInfo(@RequestBody MicroAppInfo microAppInfo) throws IOException, LcdpException {
        microAppInfo.setProjectPath(this.fileMappingService.getDataPath(microAppInfo.getParentId()) + "\\" + microAppInfo.getName());
        this.microAppInfoService.create(microAppInfo);
        return new SpeedCodeResponse();
    }

    @PutMapping(value={"/folderIsExist"})
    public SpeedCodeResponse<MicroAppInfo> folderIsExist(@RequestBody MicroAppInfo microAppInfo) throws LcdpException {
        Boolean isExist = this.microAppInfoService.folderIsExist(this.speedCodeProperties.getWorkspace() + this.fileMappingService.getDataPath(microAppInfo.getParentId()) + "\\" + microAppInfo.getName());
        SpeedCodeResponse speedCodeResponse = new SpeedCodeResponse();
        speedCodeResponse.setData((Object)isExist);
        return speedCodeResponse;
    }

    @PutMapping(value={"/createProject"})
    @ExceptionCatcher
    public SpeedCodeResponse<MicroAppInfo> createProject(@RequestBody MicroAppInfo microAppInfo) throws IOException, LcdpException {
        String projectPath = this.speedCodeProperties.getWorkspace() + this.fileMappingService.getDataPath(microAppInfo.getParentId()) + "\\" + microAppInfo.getName();
        microAppInfo.setProjectPath(projectPath);
        this.microAppInfoService.createProject(projectPath);
        this.microAppInfoService.updateAppPort(microAppInfo);
        this.microAppInfoService.updateServerPort(projectPath);
        return new SpeedCodeResponse();
    }

    @PutMapping(value={"/data/meta"})
    public SpeedCodeResponse<MicroAppInfo> updateAllDataInfo(@RequestBody MicroAppInfo microAppInfo) throws IOException, LcdpException {
        if (ToolUtil.isNotEmpty((Object)microAppInfo.getData())) {
            this.microAppInfoService.updateFile(microAppInfo);
        } else {
            this.microAppInfoService.updateFileMeta(microAppInfo);
        }
        this.microAppInfoService.updateAppPort(microAppInfo);
        return new SpeedCodeResponse();
    }

    @PutMapping
    public SpeedCodeResponse<MicroAppInfo> updateDataInfo(@RequestBody MicroAppInfo microAppInfo) throws IOException, LcdpException {
        this.microAppInfoService.updateFileMeta(microAppInfo);
        this.microAppInfoService.updateAppPort(microAppInfo);
        return new SpeedCodeResponse();
    }

    @PutMapping(value={"/save"})
    public SpeedCodeResponse<MicroAppInfo> saveDataInfo(@RequestBody MicroAppInfo microAppInfo) throws IOException, LcdpException {
        this.microAppInfoService.updateFileData(microAppInfo);
        return new SpeedCodeResponse();
    }

    @GetMapping(value={"/getFolder"})
    public SpeedCodeResponse<List<String>> getFolder(String path) throws LcdpException {
        List<String> data = this.microAppInfoService.getFolder(path);
        SpeedCodeResponse speedCodeResponse = new SpeedCodeResponse();
        speedCodeResponse.setData(data);
        return speedCodeResponse;
    }

    @GetMapping(value={"/getProjectPath"})
    public SpeedCodeResponse<String> getProjectPath() throws IOException {
        String data = this.microAppInfoService.getProjectPath();
        SpeedCodeResponse speedCodeResponse = new SpeedCodeResponse();
        speedCodeResponse.setData((Object)data);
        return speedCodeResponse;
    }

    @GetMapping(value={"/getMicroInfo"})
    public SpeedCodeResponse<MicroAppInfo> getMicroInfo(String id) throws IOException, LcdpException {
        SpeedCodeResponse stringSpeedCodeResponse = new SpeedCodeResponse();
        stringSpeedCodeResponse.setData(this.microAppInfoService.get(id));
        return stringSpeedCodeResponse;
    }

    @DeleteMapping
    public SpeedCodeResponse<MicroAppInfo> deleteDataInfo(String id) throws IOException, LcdpException {
        this.microAppInfoService.delete(id);
        return new SpeedCodeResponse();
    }

    @PostMapping(value={"/copy"})
    public SpeedCodeResponse<MicroAppInfo> copyDataInfo(@RequestBody OperateFileVO operateFileVO) throws IOException, LcdpException {
        this.microAppInfoService.copy(operateFileVO.getId(), operateFileVO.getParentId(), operateFileVO.getNewId(), operateFileVO.getNewName(), operateFileVO.getNewDesc());
        return new SpeedCodeResponse();
    }

    @PutMapping(value={"/move"})
    public SpeedCodeResponse<MicroAppInfo> moveDataInfo(@RequestBody OperateFileVO operateFileVO) throws IOException, LcdpException {
        this.microAppInfoService.move(operateFileVO.getId(), operateFileVO.getParentId(), operateFileVO.getNewName(), operateFileVO.getNewDesc());
        return new SpeedCodeResponse();
    }

    @GetMapping(value={"/getMaxPort"})
    public SpeedCodeResponse<Integer> getMaxPort() throws LcdpException {
        List<MicroAppInfo> microAppInfoList = this.microAppInfoService.getMicroAppInfo();
        return this.microAppInfoService.getMaxPort(microAppInfoList);
    }
}

