/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.file.fileoperate.controller;

import com.jxdinfo.speedcode.common.annotation.ExceptionCatcher;
import com.jxdinfo.speedcode.common.exception.LcdpException;
import com.jxdinfo.speedcode.common.model.MobilePageInfo;
import com.jxdinfo.speedcode.common.response.SpeedCodeResponse;
import com.jxdinfo.speedcode.common.util.ToolUtil;
import com.jxdinfo.speedcode.file.fileoperate.service.DataInfoService;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/speed/mobileinfo"})
public class DataInfoController {
    private final DataInfoService dataInfoService;

    @Autowired
    public DataInfoController(DataInfoService dataInfoService) {
        this.dataInfoService = dataInfoService;
    }

    @PostMapping
    @ExceptionCatcher
    public SpeedCodeResponse<MobilePageInfo> addDataInfo(@RequestBody MobilePageInfo mobilePageInfo) throws IOException, LcdpException {
        this.dataInfoService.create(mobilePageInfo);
        return new SpeedCodeResponse();
    }

    @PostMapping(value={"/frame"})
    @ExceptionCatcher
    public SpeedCodeResponse<MobilePageInfo> saveFrame(@RequestBody MobilePageInfo mobilePageInfo) throws IOException, LcdpException {
        this.dataInfoService.saveFrame(mobilePageInfo);
        return new SpeedCodeResponse();
    }

    @PostMapping(value={"/frame/publish"})
    @ExceptionCatcher
    public SpeedCodeResponse<Void> publishFrame(@RequestBody Map<String, String> idMap) throws IOException, LcdpException {
        this.dataInfoService.publishFrame(idMap);
        return new SpeedCodeResponse();
    }

    @GetMapping(value={"/frame"})
    @ExceptionCatcher
    public SpeedCodeResponse<MobilePageInfo> getFrameData(@RequestParam String id) throws IOException, LcdpException {
        SpeedCodeResponse stringSpeedCodeResponse = new SpeedCodeResponse();
        stringSpeedCodeResponse.setData((Object)this.dataInfoService.updateFrameJson(id));
        return stringSpeedCodeResponse;
    }

    @PostMapping(value={"/package"})
    @ExceptionCatcher
    public SpeedCodeResponse<Void> packageToJQX(@RequestBody Map<String, String> pubMap) throws Exception {
        SpeedCodeResponse<Void> response = "3".equals(pubMap.get("pubType")) ? this.dataInfoService.packageToJQX(pubMap) : this.dataInfoService.putPathToJQX(pubMap);
        return response;
    }

    @RequestMapping(value={"/home"})
    @ExceptionCatcher
    public SpeedCodeResponse<Void> setHomePage(@RequestParam String id) throws Exception {
        SpeedCodeResponse response = new SpeedCodeResponse();
        this.dataInfoService.setHomePage(id);
        response.setErrorCode(200);
        return response;
    }

    @PutMapping(value={"/data/meta"})
    public SpeedCodeResponse<MobilePageInfo> updateAllDataInfo(@RequestBody MobilePageInfo mobilePageInfo) throws IOException, LcdpException {
        if (ToolUtil.isNotEmpty((Object)mobilePageInfo.getData())) {
            this.dataInfoService.updateFile(mobilePageInfo);
        } else {
            this.dataInfoService.updateFileMeta(mobilePageInfo);
        }
        return new SpeedCodeResponse();
    }

    @PostMapping(value={"/save/pages"})
    public SpeedCodeResponse<MobilePageInfo> saveMultiPageInfo(@RequestBody List<MobilePageInfo> mobilePageInfo) throws IOException, LcdpException {
        if (ToolUtil.isNotEmpty(mobilePageInfo)) {
            for (MobilePageInfo pageInfo : mobilePageInfo) {
                if (ToolUtil.isNotEmpty((Object)pageInfo.getData())) {
                    this.dataInfoService.updateFile(pageInfo);
                    continue;
                }
                this.dataInfoService.updateFileMeta(pageInfo);
            }
        }
        return new SpeedCodeResponse();
    }

    @PutMapping
    public SpeedCodeResponse<MobilePageInfo> updateDataInfo(@RequestBody MobilePageInfo mobilePageInfo) throws IOException, LcdpException {
        this.dataInfoService.updateFileMeta(mobilePageInfo);
        return new SpeedCodeResponse();
    }

    @GetMapping
    public SpeedCodeResponse<MobilePageInfo> getDataInfo(String id) throws IOException, LcdpException {
        SpeedCodeResponse stringSpeedCodeResponse = new SpeedCodeResponse();
        stringSpeedCodeResponse.setData(this.dataInfoService.get(id));
        return stringSpeedCodeResponse;
    }
}

