/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.file.fileoperate.controller;

import com.jxdinfo.speedcode.common.exception.LcdpException;
import com.jxdinfo.speedcode.common.model.CustomComponentGroupInfo;
import com.jxdinfo.speedcode.common.response.SpeedCodeResponse;
import com.jxdinfo.speedcode.file.fileoperate.service.CustomComponentGroupInfoService;
import java.io.IOException;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/speed/customComponentGroupInfo"})
public class CustomComponentGroupInfoController {
    @Resource
    private CustomComponentGroupInfoService customComponentGroupInfoService;

    @PostMapping
    public SpeedCodeResponse<CustomComponentGroupInfo> addDataInfo(@RequestBody CustomComponentGroupInfo customComponentGroupInfo) throws IOException, LcdpException {
        this.customComponentGroupInfoService.create(customComponentGroupInfo);
        return new SpeedCodeResponse();
    }

    @PutMapping
    public SpeedCodeResponse<CustomComponentGroupInfo> updateDataInfo(@RequestBody CustomComponentGroupInfo customComponentGroupInfo) throws IOException, LcdpException {
        this.customComponentGroupInfoService.updateFileMeta(customComponentGroupInfo);
        return new SpeedCodeResponse();
    }

    @DeleteMapping
    public SpeedCodeResponse<CustomComponentGroupInfo> deleteDataInfo(String name) throws IOException, LcdpException {
        this.customComponentGroupInfoService.delete(name);
        return new SpeedCodeResponse();
    }

    @RequestMapping(value={"/upload"})
    @ResponseBody
    public SpeedCodeResponse<String> upload(@RequestPart(value="file") MultipartFile file) throws LcdpException, IOException {
        return this.customComponentGroupInfoService.upload(file);
    }

    @GetMapping(value={"/delCover"})
    public SpeedCodeResponse<CustomComponentGroupInfo> delCover(String fileName) throws LcdpException, IOException {
        this.customComponentGroupInfoService.delCover(fileName);
        return new SpeedCodeResponse();
    }

    @PostMapping(value={"/getCover"})
    public void getFile(String fileName, HttpServletResponse response) throws IOException, LcdpException {
        this.customComponentGroupInfoService.getFile(fileName, response);
    }
}

