<#if instanceKey?? && instanceKey != "" && importName?? && importMethod??>
// 拿到选中的数据
const val = self.${instanceKey!}TableDataChecked;
// 如果选中数据存在
if (val.length > 0) {
    let ids = [];
    val.forEach((value) => {
        ids.push(value.${primaryFieldName!"id"})
    })
    let tableDeleteBatch = {
        ids: ids.join(',')
    };

    <#if importName != "">
        self.$confirm('确定要删除吗?', '提示', {
            confirmButtonText: '确定',
            cancelButtonText: '取消',
            type: 'warning'
            }).then(() => {
                ${importName!}['${importMethod!}'](tableDeleteBatch).then(res => {
                    if (res.code == 200) {
                        <#if strategy??>
                            top.window.showSuccessMessage('删除成功');
                        <#else>
                            self.$message.success('删除成功');
                        </#if>
                        <#if bodies?? && (bodies?size>0)>
                            <#list bodies as body>
                                ${body}
                            </#list>
                        </#if>
                        self.${instanceKey!}TableLoad();
                    } else {
                        <#if strategy??>
                            top.window.showErrorMessage(res.msg);
                        <#else>
                            self.$message.error(res.msg);
                        </#if>
                    }
                }).catch(function() {
                    <#if strategy??>
                        top.window.showErrorMessage('数据请求失败');
                    <#else>
                        self.$message.error('数据请求失败');
                    </#if>
                })
            })
    </#if>
} else {
    <#if strategy??>
	    top.window.showWarningMessage('请选择至少一条数据');
    <#else>
        self.$message.warning('请选择至少一条数据');
    </#if>
}
<#else>
// 表格未绑定数据模型，该动作及后续动作未成功生成
</#if>